/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database;

import ghidra.util.LockHold;
import java.util.Spliterator;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.function.Consumer;

public class DBSynchronizedSpliterator<T>
implements Spliterator<T> {
    private final Spliterator<T> spliterator;
    private final Lock lock;

    public DBSynchronizedSpliterator(Spliterator<T> spliterator, Lock lock) {
        this.spliterator = spliterator;
        this.lock = lock;
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        boolean result;
        AtomicReference ref = new AtomicReference();
        try (LockHold hold = LockHold.lock(this.lock);){
            result = this.spliterator.tryAdvance(ref::set);
        }
        if (!result) {
            return false;
        }
        action.accept(ref.get());
        return true;
    }

    @Override
    public Spliterator<T> trySplit() {
        Spliterator<T> newSplit;
        try (LockHold hold = LockHold.lock(this.lock);){
            newSplit = this.spliterator.trySplit();
        }
        if (newSplit == null) {
            return null;
        }
        return new DBSynchronizedSpliterator<T>(newSplit, this.lock);
    }

    @Override
    public long estimateSize() {
        try (LockHold hold = LockHold.lock(this.lock);){
            long l = this.spliterator.estimateSize();
            return l;
        }
    }

    @Override
    public int characteristics() {
        try (LockHold hold = LockHold.lock(this.lock);){
            int n = this.spliterator.characteristics();
            return n;
        }
    }
}

