/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.protocol;

import ghidra.features.bsim.gui.filters.BSimFilterType;
import ghidra.features.bsim.query.protocol.FilterAtom;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;

public class ChildAtom
extends FilterAtom {
    public String name = null;
    public String exename = null;

    @Override
    public void saveXml(Writer fwrite) throws IOException {
        fwrite.append("<childatom");
        this.type.saveXml(fwrite);
        if (this.exename != null) {
            fwrite.append(" exe=\"");
            SpecXmlUtils.xmlEscapeWriter((Writer)fwrite, (String)this.exename);
            fwrite.append('\"');
        }
        fwrite.append('>');
        SpecXmlUtils.xmlEscapeWriter((Writer)fwrite, (String)this.name);
        fwrite.append("</childatom>\n");
    }

    @Override
    public void restoreXml(XmlPullParser parser) {
        XmlElement el = parser.start(new String[]{"childatom"});
        this.type = BSimFilterType.nameToType(el);
        this.value = null;
        this.exename = el.getAttribute("exe");
        this.name = parser.end(el).getText();
    }

    @Override
    public FilterAtom clone() {
        ChildAtom newatom = new ChildAtom();
        newatom.type = this.type;
        newatom.value = this.value;
        newatom.name = this.name;
        newatom.exename = this.exename;
        return newatom;
    }

    @Override
    public String getInfoString() {
        if (this.name == null) {
            return null;
        }
        Object res = "Has child ";
        if (this.exename != null) {
            res = (String)res + "[" + this.exename + "]";
        }
        res = (String)res + this.name;
        return res;
    }

    @Override
    public String getValueString() {
        if (this.exename != null) {
            return "[" + this.exename + "]" + this.name;
        }
        return this.name;
    }
}

