/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.cmd.comments.SetCommentCmd;
import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.app.cmd.label.SetLabelPrimaryCmd;
import ghidra.app.plugin.core.analysis.TransientProgramProperties;
import ghidra.app.util.NamespaceUtils;
import ghidra.app.util.PseudoDisassembler;
import ghidra.app.util.SymbolPath;
import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.GlobalSymbolInformation;
import ghidra.app.util.bin.format.pdb2.pdbreader.ModuleInformation;
import ghidra.app.util.bin.format.pdb2.pdbreader.MsSymbolIterator;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbDebugInfo;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbLog;
import ghidra.app.util.bin.format.pdb2.pdbreader.PublicSymbolInformation;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.SectionContribution;
import ghidra.app.util.bin.format.pdb2.pdbreader.TypeProgramInterface;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractCompile2MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractPublicMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractThunkMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractUserDefinedTypeMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AddressMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.Compile3MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.PeCoffGroupMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.PeCoffSectionMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.PrimitiveMsType;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.pdb.PdbCategories;
import ghidra.app.util.pdb.classtype.ClassTypeManager;
import ghidra.app.util.pdb.classtype.MsVxtManager;
import ghidra.app.util.pdb.pdbapplicator.ComplexTypeMapper;
import ghidra.app.util.pdb.pdbapplicator.CppCompositeType;
import ghidra.app.util.pdb.pdbapplicator.DeferrableFunctionSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.DirectSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.DisassembleableAddressSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.MsDataTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.MsSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.MsTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.MultiphaseDataTypeResolver;
import ghidra.app.util.pdb.pdbapplicator.PdbAddressManager;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicatorControl;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicatorMetrics;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicatorOptions;
import ghidra.app.util.pdb.pdbapplicator.PdbPeHeaderInfoManager;
import ghidra.app.util.pdb.pdbapplicator.PdbPrimitiveTypeApplicator;
import ghidra.app.util.pdb.pdbapplicator.PdbRegisterNameToProgramRegisterMapper;
import ghidra.app.util.pdb.pdbapplicator.PdbResearch;
import ghidra.app.util.pdb.pdbapplicator.PdbSourceLinesApplicator;
import ghidra.app.util.pdb.pdbapplicator.SymbolApplierFactory;
import ghidra.app.util.pdb.pdbapplicator.SymbolGroup;
import ghidra.app.util.pdb.pdbapplicator.TypeApplierFactory;
import ghidra.framework.options.Options;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.disassemble.DisassemblerContextImpl;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.BuiltInDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeImpl;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.lang.DisassemblerContext;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.GhidraClass;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.CancelOnlyWrappingTaskMonitor;
import ghidra.util.task.TaskMonitor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import mdemangler.MDMangUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class DefaultPdbApplicator
implements PdbApplicator {
    private static final String THUNK_NAME_PREFIX = "[thunk]:";
    private static final String PDB_ANALYSIS_LOOKUP_STATE = "PDB_UNIVERSAL_ANALYSIS_STATE";
    private AbstractPdb pdb;
    private PdbUniversalAnalysisState pdbAnalysisLookupState;
    private PdbApplicatorMetrics pdbApplicatorMetrics;
    private boolean preWorkDone = false;
    private Program program;
    private PdbApplicatorOptions applicatorOptions;
    private MessageLog log;
    private TaskMonitor monitor;
    private CancelOnlyWrappingTaskMonitor cancelOnlyWrappingMonitor;
    private Address imageBase;
    private int linkerModuleNumber = -1;
    private DataTypeManager dataTypeManager;
    private ClassTypeManager classTypeManager;
    private PdbAddressManager pdbAddressManager;
    private List<SymbolGroup> symbolGroups;
    private PdbPeHeaderInfoManager pdbPeHeaderInfoManager;
    private List<PeCoffSectionMsSymbol> linkerPeCoffSectionSymbols = null;
    private AbstractMsSymbol compileSymbolForLinkerModule = null;
    private boolean processedLinkerModule = false;
    private PdbSourceLinesApplicator linesApplicator;
    private MsVxtManager vxtManager;
    private PdbRegisterNameToProgramRegisterMapper registerNameToRegisterMapper;
    private MultiphaseDataTypeResolver multiphaseResolver;
    private int resolveCount;
    private int conflictCount;
    private PdbCategories pdbCategories;
    private PdbPrimitiveTypeApplicator pdbPrimitiveTypeApplicator;
    private TypeApplierFactory typeApplierParser;
    private Map<RecordNumber, DataType> dataTypeByMsTypeNum;
    private Set<RecordNumber> filledInStructure;
    private Map<RecordNumber, CppCompositeType> classTypeByMsTypeNum;
    private ComplexTypeMapper complexTypeMapper;
    private Map<SymbolPath, Boolean> isClassByNamespace;
    private SymbolApplierFactory symbolApplierParser;
    private Map<Address, Set<String>> labelsByAddress;
    private Map<String, Set<RecordNumber>> recordNumbersByFileName;
    private Map<Integer, Set<RecordNumber>> recordNumbersByModuleNumber;
    private int currentModuleNumber = 0;

    public static PdbUniversalAnalysisState getPdbAnalysisLookupState(Program program, boolean asAnalysis) {
        if (program == null || !asAnalysis) {
            return new PdbUniversalAnalysisState();
        }
        PdbUniversalAnalysisState pdbAnalysisLookupState = (PdbUniversalAnalysisState)TransientProgramProperties.getProperty((Program)program, (Object)PDB_ANALYSIS_LOOKUP_STATE, (TransientProgramProperties.SCOPE)TransientProgramProperties.SCOPE.ANALYSIS_SESSION, PdbUniversalAnalysisState.class, () -> new PdbUniversalAnalysisState());
        return pdbAnalysisLookupState;
    }

    long bigIntegerToLong(BigInteger big) {
        try {
            return big.longValueExact();
        }
        catch (ArithmeticException e) {
            String msg = "BigInteger value greater than max Long: " + String.valueOf(big);
            PdbLog.message(msg);
            this.appendLogMsg(msg);
            return Long.MAX_VALUE;
        }
    }

    int bigIntegerToInt(BigInteger big) {
        try {
            return big.intValueExact();
        }
        catch (ArithmeticException e) {
            String msg = "BigInteger value greater than max Integer: " + String.valueOf(big);
            PdbLog.message(msg);
            this.appendLogMsg(msg);
            return Integer.MAX_VALUE;
        }
    }

    public DefaultPdbApplicator(AbstractPdb pdb, Program programParam, DataTypeManager dataTypeManagerParam, Address imageBaseParam, PdbApplicatorOptions applicatorOptionsParam, TaskMonitor monitor, MessageLog logParam) throws PdbException {
        Objects.requireNonNull(pdb, "pdb cannot be null");
        this.pdb = pdb;
        this.monitor = TaskMonitor.dummyIfNull((TaskMonitor)monitor);
        this.initialize(programParam, dataTypeManagerParam, imageBaseParam, applicatorOptionsParam, logParam);
    }

    public void applyDataTypesAndMainSymbolsAnalysis() throws PdbException, CancelledException {
        this.pdbAnalysisLookupState = DefaultPdbApplicator.getPdbAnalysisLookupState(this.program, true);
        this.doPdbPreWork();
        this.doPdbTypesAndMainSymbolsWork();
        if (this.program != null) {
            Options options = this.program.getOptions("Program Information");
            options.setBoolean("PDB Loaded", true);
        }
    }

    public void applyFunctionInternalsAnalysis() throws PdbException, CancelledException {
        this.pdbAnalysisLookupState = DefaultPdbApplicator.getPdbAnalysisLookupState(this.program, true);
        this.doPdbPreWork();
        this.doPdbFunctionInternalsWork();
    }

    public static void applyAnalysisReporting(Program program) throws CancelledException {
        PdbUniversalAnalysisState state = DefaultPdbApplicator.getPdbAnalysisLookupState(program, true);
        DefaultPdbApplicator.doReports(state);
    }

    public void applyNoAnalysisState() throws PdbException, CancelledException {
        this.pdbAnalysisLookupState = DefaultPdbApplicator.getPdbAnalysisLookupState(this.program, false);
        this.doPdbPreWork();
        this.doPdbTypesAndMainSymbolsWork();
        this.doDisassemblyWork();
        this.doPdbFunctionInternalsWork();
        DefaultPdbApplicator.doReports(this.pdbAnalysisLookupState);
        if (this.program != null) {
            Options options = this.program.getOptions("Program Information");
            options.setBoolean("PDB Loaded", true);
        }
    }

    void setFunctionLength(Address address, int length) {
        if (this.linesApplicator != null) {
            this.linesApplicator.setFunctionLength(address, length);
        }
    }

    private void doPdbTypesAndMainSymbolsWork() throws PdbException, CancelledException {
        switch (this.applicatorOptions.getProcessingControl()) {
            case DATA_TYPES_ONLY: {
                this.processTypes();
                break;
            }
            case PUBLIC_SYMBOLS_ONLY: {
                this.processPublicSymbols();
                break;
            }
            case ALL: {
                this.processTypes();
                this.processSymbols();
                this.vxtManager.createTables(this.dataTypeManager, DataUtilities.ClearDataMode.CLEAR_ALL_CONFLICT_DATA);
                break;
            }
            default: {
                throw new PdbException("PDB: Invalid Application Control: " + String.valueOf((Object)this.applicatorOptions.getProcessingControl()));
            }
        }
        Msg.info((Object)this, (Object)"PDB Types and Main Symbols Processing Terminated Normally");
    }

    private void doDisassemblyWork() throws PdbException, CancelledException {
        if (this.program != null) {
            this.disassembleFunctions();
        }
        Msg.info((Object)this, (Object)"PDB Disassembly Terminated Normally");
    }

    private void doPdbFunctionInternalsWork() throws PdbException, CancelledException {
        if (this.program != null) {
            this.doDeferredFunctionProcessing();
            if (this.applicatorOptions.applySourceLineNumbers()) {
                this.linesApplicator.process(this.monitor);
            }
        }
        Msg.info((Object)this, (Object)"PDB Function Internals Processing Terminated Normally");
    }

    private static void doReports(PdbUniversalAnalysisState state) throws CancelledException {
        Msg.info(DefaultPdbApplicator.class, (Object)"PDB Applicator Reporting");
        state.getPdbAddressManager().logReport();
        state.getPdbApplicatorMetrics().logReport();
        Msg.info(DefaultPdbApplicator.class, (Object)"PDB Applicator Reporting Terminated Normally");
    }

    private void disassembleFunctions() throws PdbException, CancelledException {
        AddressSet disassembleAddresses = this.gatherAddressesForDisassembly();
        Listing listing = this.program.getListing();
        DisassemblerContextImpl seedContext = new DisassemblerContextImpl(this.program.getProgramContext());
        AddressSet revisedSet = new AddressSet();
        long num = disassembleAddresses.getNumAddresses();
        this.monitor.initialize(num);
        this.monitor.setMessage("PDB: Determining disassembly context for " + num + " addresses...");
        for (Address address : disassembleAddresses.getAddresses(true)) {
            this.monitor.checkCancelled();
            address = PseudoDisassembler.setTargetContextForDisassembly((DisassemblerContext)seedContext, (Address)address);
            Function myFunction = listing.getFunctionAt(address);
            if (myFunction == null || myFunction.getBody().getNumAddresses() <= 1L) {
                revisedSet.add(address);
            }
            this.monitor.incrementProgress(1L);
        }
        num = revisedSet.getNumAddresses();
        this.monitor.setMessage("PDB: Bulk disassembly at " + num + " addresses...");
        DisassembleCommand cmd = new DisassembleCommand((AddressSetView)revisedSet, null, true);
        cmd.setSeedContext(seedContext);
        cmd.applyTo(this.program, this.monitor);
        this.monitor.initialize(num);
        this.monitor.setMessage("PDB: Disassembly fix-up for " + num + " addresses...");
        for (Address address : revisedSet.getAddresses(true)) {
            this.monitor.checkCancelled();
            Function function = listing.getFunctionAt(address);
            if (function != null) {
                CreateFunctionCmd.fixupFunctionBody((Program)this.program, (Function)function, (TaskMonitor)this.cancelOnlyWrappingMonitor);
            }
            this.monitor.incrementProgress(1L);
        }
    }

    private void doDeferredFunctionProcessing() throws CancelledException, PdbException {
        if (this.applicatorOptions.getProcessingControl() == PdbApplicatorControl.DATA_TYPES_ONLY) {
            return;
        }
        this.doDeferredProcessGlobalSymbolsNoTypedefs();
        this.doDeferredProcessModuleSymbols();
    }

    private void processTypes() throws CancelledException, PdbException {
        this.monitor.setMessage("PDB: Applying to DTM " + this.dataTypeManager.getName() + "...");
        PdbResearch.initBreakPointRecordNumbers();
        this.resolveCount = 0;
        this.conflictCount = 0;
        this.complexTypeMapper.mapTypes(this);
        this.processSequentially();
        if (this.program != null) {
            this.defineClasses();
        }
        this.processGlobalTypdefSymbols();
        Msg.info((Object)this, (Object)("resolveCount: " + this.resolveCount));
        Msg.info((Object)this, (Object)("conflictCount: " + this.conflictCount));
    }

    private void processSymbols() throws CancelledException, PdbException {
        if (this.pdb.getTypeProgramInterface().getTypeIndexMaxExclusive() == this.pdb.getTypeProgramInterface().getTypeIndexMin()) {
            this.processPublicSymbols();
            this.processGlobalSymbolsNoTypedefs();
        } else {
            this.processGlobalSymbolsNoTypedefs();
            this.processPublicSymbols();
        }
        this.processModuleSymbols();
        this.processThunkSymbolsFromNonLinkerModules();
    }

    private void initialize(Program programParam, DataTypeManager dataTypeManagerParam, Address imageBaseParam, PdbApplicatorOptions applicatorOptionsParam, MessageLog logParam) throws PdbException {
        this.validateAndSetParameters(programParam, dataTypeManagerParam, imageBaseParam, applicatorOptionsParam, logParam);
        this.cancelOnlyWrappingMonitor = new CancelOnlyWrappingTaskMonitor(this.monitor);
        this.pdbPeHeaderInfoManager = new PdbPeHeaderInfoManager(this);
        this.multiphaseResolver = new MultiphaseDataTypeResolver(this);
        this.filledInStructure = new HashSet<RecordNumber>();
        this.classTypeManager = new ClassTypeManager(this.dataTypeManager);
        this.pdbPrimitiveTypeApplicator = new PdbPrimitiveTypeApplicator(this.dataTypeManager);
        this.typeApplierParser = new TypeApplierFactory(this);
        this.isClassByNamespace = new TreeMap<SymbolPath, Boolean>();
        this.symbolApplierParser = new SymbolApplierFactory(this);
        this.labelsByAddress = new HashMap<Address, Set<String>>();
        this.recordNumbersByFileName = new HashMap<String, Set<RecordNumber>>();
        this.recordNumbersByModuleNumber = new HashMap<Integer, Set<RecordNumber>>();
        if (this.program != null && this.applicatorOptions.applySourceLineNumbers()) {
            this.linesApplicator = new PdbSourceLinesApplicator(this);
        }
    }

    private void doPdbPreWork() throws CancelledException, PdbException {
        if (this.preWorkDone) {
            return;
        }
        this.pdbApplicatorMetrics = this.pdbAnalysisLookupState.getPdbApplicatorMetrics();
        this.pdbAddressManager = this.pdbAnalysisLookupState.getPdbAddressManager();
        this.complexTypeMapper = this.pdbAnalysisLookupState.getComplexTypeMapper();
        this.dataTypeByMsTypeNum = this.pdbAnalysisLookupState.getDataTypeByMsTypeNumMap();
        this.classTypeByMsTypeNum = this.pdbAnalysisLookupState.getClassTypeByMsTypeNumMap();
        if (!this.pdbAddressManager.isInitialized()) {
            this.pdbAddressManager.initialize(this, this.imageBase);
        }
        this.pdbCategories = this.setPdbCatogoryUtils(this.pdb.getFilename());
        this.symbolGroups = this.createSymbolGroups();
        this.linkerModuleNumber = this.findLinkerModuleNumber();
        if (this.program != null) {
            MsVxtManager msftVxtManager = new MsVxtManager(this.getClassTypeManager(), this.program);
            msftVxtManager.createVirtualTables(this.getRootPdbCategory(), this.findVirtualTableSymbols(), this.log, this.monitor);
            this.vxtManager = msftVxtManager;
            this.registerNameToRegisterMapper = new PdbRegisterNameToProgramRegisterMapper(this.program);
        }
        this.preWorkDone = true;
    }

    private void validateAndSetParameters(Program programParam, DataTypeManager dataTypeManagerParam, Address imageBaseParam, PdbApplicatorOptions applicatorOptionsParam, MessageLog logParam) throws PdbException {
        PdbApplicatorOptions pdbApplicatorOptions = this.applicatorOptions = applicatorOptionsParam != null ? applicatorOptionsParam : new PdbApplicatorOptions();
        if (programParam == null) {
            if (dataTypeManagerParam == null) {
                throw new PdbException("PDB: programParam and dataTypeManagerParam may not both be null.");
            }
            if (imageBaseParam == null) {
                throw new PdbException("PDB: programParam and imageBaseParam may not both be null.");
            }
            if (this.applicatorOptions.getProcessingControl() != PdbApplicatorControl.DATA_TYPES_ONLY) {
                throw new PdbException("PDB: programParam may not be null for the chosen Applicator Control: " + String.valueOf((Object)this.applicatorOptions.getProcessingControl()));
            }
        }
        this.log = logParam != null ? logParam : new MessageLog();
        this.program = programParam;
        this.dataTypeManager = dataTypeManagerParam != null ? dataTypeManagerParam : this.program.getDataTypeManager();
        this.imageBase = imageBaseParam != null ? imageBaseParam : this.program.getImageBase();
    }

    private List<SymbolGroup> createSymbolGroups() throws CancelledException {
        ArrayList<SymbolGroup> mySymbolGroups = new ArrayList<SymbolGroup>();
        PdbDebugInfo debugInfo = this.pdb.getDebugInfo();
        if (debugInfo == null) {
            return mySymbolGroups;
        }
        int num = debugInfo.getNumModules();
        for (int moduleNumber = 0; moduleNumber <= num; ++moduleNumber) {
            this.checkCancelled();
            SymbolGroup symbolGroup = new SymbolGroup(this.pdb, moduleNumber);
            mySymbolGroups.add(symbolGroup);
        }
        return mySymbolGroups;
    }

    private Map<String, Address> findVirtualTableSymbols() throws CancelledException, PdbException {
        HashMap<String, Address> myAddressByVxtMangledName = new HashMap<String, Address>();
        PdbDebugInfo debugInfo = this.pdb.getDebugInfo();
        if (debugInfo == null) {
            return myAddressByVxtMangledName;
        }
        SymbolGroup symbolGroup = this.getSymbolGroup();
        if (symbolGroup == null) {
            return myAddressByVxtMangledName;
        }
        PublicSymbolInformation publicSymbolInformation = debugInfo.getPublicSymbolInformation();
        List<Long> offsets = publicSymbolInformation.getModifiedHashRecordSymbolOffsets();
        this.monitor.setMessage("PDB: Searching for VxT symbols...");
        this.monitor.initialize((long)offsets.size());
        MsSymbolIterator iter = symbolGroup.getSymbolIterator();
        for (long offset : offsets) {
            Address address;
            AbstractPublicMsSymbol pubSymbol;
            String name;
            this.monitor.checkCancelled();
            iter.initGetByOffset(offset);
            if (!iter.hasNext()) break;
            AbstractMsSymbol symbol = iter.peek();
            if (symbol instanceof AbstractPublicMsSymbol && ((name = (pubSymbol = (AbstractPublicMsSymbol)symbol).getName()).startsWith("??_7") || name.startsWith("??_8")) && !this.isInvalidAddress(address = this.getAddress(pubSymbol), name)) {
                myAddressByVxtMangledName.put(name, address);
            }
            this.monitor.incrementProgress(1L);
        }
        return myAddressByVxtMangledName;
    }

    PdbApplicatorOptions getPdbApplicatorOptions() {
        return this.applicatorOptions;
    }

    void checkCancelled() throws CancelledException {
        this.monitor.checkCancelled();
    }

    void appendLogMsg(String message) {
        this.log.appendMsg(message);
    }

    MessageLog getMessageLog() {
        return this.log;
    }

    void pdbLogAndInfoMessage(Object originator, String message) {
        PdbLog.message(message);
        Msg.info((Object)originator, (Object)message);
    }

    void pdbLogAndErrorMessage(Object originator, String message, Exception exc) {
        PdbLog.message(message);
        if (exc != null) {
            Msg.error((Object)originator, (Object)message);
        } else {
            Msg.error((Object)originator, (Object)message, (Throwable)exc);
        }
    }

    @Override
    public TaskMonitor getMonitor() {
        return this.monitor;
    }

    TaskMonitor getCancelOnlyWrappingMonitor() {
        return this.cancelOnlyWrappingMonitor;
    }

    PdbApplicatorMetrics getPdbApplicatorMetrics() {
        return this.pdbApplicatorMetrics;
    }

    @Override
    public AbstractPdb getPdb() {
        return this.pdb;
    }

    @Override
    public Program getProgram() {
        return this.program;
    }

    DataTypeManager getDataTypeManager() {
        return this.dataTypeManager;
    }

    ClassTypeManager getClassTypeManager() {
        return this.classTypeManager;
    }

    DataOrganization getDataOrganization() {
        return this.dataTypeManager.getDataOrganization();
    }

    PdbPrimitiveTypeApplicator getPdbPrimitiveTypeApplicator() {
        return this.pdbPrimitiveTypeApplicator;
    }

    CategoryPath getRootPdbCategory() {
        return this.pdbCategories.getRootCategoryPath();
    }

    CategoryPath getCategory(SymbolPath symbolPath) {
        return this.pdbCategories.getCategory(symbolPath);
    }

    CategoryPath getTypedefsCategory(int moduleNumber, SymbolPath symbolPath) {
        return this.pdbCategories.getTypedefsCategory(moduleNumber, symbolPath);
    }

    CategoryPath getAnonymousFunctionsCategory() {
        return this.pdbCategories.getAnonymousFunctionsCategory();
    }

    CategoryPath getAnonymousTypesCategory() {
        return this.pdbCategories.getAnonymousTypesCategory();
    }

    private PdbCategories setPdbCatogoryUtils(String pdbFilename) throws CancelledException, PdbException {
        ArrayList<String> categoryNames = new ArrayList<String>();
        PdbDebugInfo debugInfo = this.pdb.getDebugInfo();
        if (debugInfo != null) {
            int num = debugInfo.getNumModules();
            for (int index = 1; index <= num; ++index) {
                this.checkCancelled();
                String moduleName = debugInfo.getModuleInformation(index).getModuleName();
                categoryNames.add(moduleName);
            }
        }
        return new PdbCategories(FilenameUtils.getName((String)pdbFilename), categoryNames);
    }

    MsTypeApplier getApplierOrNoTypeSpec(RecordNumber recordNumber, Class<? extends MsTypeApplier> expected) throws PdbException {
        return this.typeApplierParser.getApplierOrNoTypeSpec(recordNumber, expected);
    }

    MsTypeApplier getTypeApplier(RecordNumber recordNumber) {
        return this.typeApplierParser.getTypeApplier(recordNumber);
    }

    MsTypeApplier getTypeApplier(AbstractMsType type) {
        return this.typeApplierParser.getTypeApplier(type);
    }

    MsTypeApplier getTypeApplier(int pdbId) {
        return this.typeApplierParser.getTypeApplier(pdbId);
    }

    DataType getCompletedDataType(RecordNumber recordNumber) throws CancelledException, PdbException {
        DataType dataType = this.getDataType(recordNumber);
        if (dataType instanceof DataTypeImpl) {
            if (!(dataType instanceof BuiltInDataType)) {
                dataType = this.resolve(dataType);
                this.putDataType(recordNumber, dataType);
            }
        } else if (dataType == null) {
            AbstractMsType type = this.getTypeRecord(recordNumber);
            if (!(type instanceof PrimitiveMsType)) {
                throw new PdbException("Type not completed for record: " + String.valueOf(recordNumber) + "; " + type.getClass().getSimpleName());
            }
            MsDataTypeApplier dataTypeApplier = (MsDataTypeApplier)this.getTypeApplier(recordNumber);
            if (!dataTypeApplier.apply(type)) {
                throw new PdbException("Problem creating Primitive data type for record: " + String.valueOf(recordNumber));
            }
            dataType = this.getDataType(recordNumber);
            if (dataType == null) {
                throw new PdbException("Problem creating Primitive data type for record: " + String.valueOf(recordNumber));
            }
        }
        return dataType;
    }

    void putDataType(AbstractMsType msType, DataType dataType) {
        RecordNumber recordNumber = msType.getRecordNumber();
        this.putDataType(recordNumber, dataType);
    }

    void putDataType(RecordNumber recordNumber, DataType dataType) {
        RecordNumber mappedNumber = this.getMappedRecordNumber(recordNumber);
        this.dataTypeByMsTypeNum.put(mappedNumber, dataType);
    }

    void markFilledInForBase(RecordNumber recordNumber) {
        RecordNumber mappedNumber = this.getMappedRecordNumber(recordNumber);
        this.filledInStructure.add(mappedNumber);
    }

    DataType getDataType(AbstractMsType msType) {
        RecordNumber recordNumber = msType.getRecordNumber();
        return this.getDataType(recordNumber);
    }

    DataType getDataType(RecordNumber recordNumber) {
        RecordNumber mappedNumber = this.getMappedRecordNumber(recordNumber);
        return this.dataTypeByMsTypeNum.get(mappedNumber);
    }

    DataType getDataTypeOrSchedule(RecordNumber recordNumber) {
        RecordNumber mappedNumber = this.getMappedRecordNumber(recordNumber);
        DataType dt = this.dataTypeByMsTypeNum.get(mappedNumber);
        if (dt != null) {
            return dt;
        }
        this.multiphaseResolver.scheduleTodo(mappedNumber);
        return null;
    }

    DataType getBaseClassDataTypeOrSchedule(RecordNumber recordNumber) {
        RecordNumber mappedNumber = this.getMappedRecordNumber(recordNumber);
        boolean filledIn = this.filledInStructure.contains(mappedNumber);
        DataType dt = this.dataTypeByMsTypeNum.get(mappedNumber);
        if (dt != null && filledIn) {
            return dt;
        }
        this.multiphaseResolver.scheduleTodo(mappedNumber);
        return null;
    }

    void putClassType(AbstractMsType msType, CppCompositeType classType) {
        RecordNumber recordNumber = msType.getRecordNumber();
        CppCompositeType existing = this.getClassType(recordNumber);
        if (existing == classType) {
            return;
        }
        if (existing != null) {
            this.appendLogMsg("Existing class type; not replacing:\n" + String.valueOf(existing) + "\n" + String.valueOf(classType) + "\n");
            return;
        }
        this.putClassType(recordNumber, classType);
    }

    CppCompositeType getClassType(AbstractMsType msType) {
        return this.getClassType(msType.getRecordNumber());
    }

    private CppCompositeType getClassType(RecordNumber recordNumber) {
        return this.classTypeByMsTypeNum.get(this.getMappedRecordNumber(recordNumber));
    }

    private void putClassType(RecordNumber recordNumber, CppCompositeType classType) {
        RecordNumber mappedNumber = this.getMappedRecordNumber(recordNumber);
        this.classTypeByMsTypeNum.put(mappedNumber, classType);
    }

    public AbstractMsType getTypeRecord(RecordNumber recordNumber) {
        return this.pdb.getTypeRecord(recordNumber, AbstractMsType.class);
    }

    public AbstractMsType getMappedTypeRecord(RecordNumber recordNumber) {
        RecordNumber mappedNumber = this.getMappedRecordNumber(recordNumber);
        return this.pdb.getTypeRecord(mappedNumber, AbstractMsType.class);
    }

    public <T extends AbstractMsType> T getTypeRecord(RecordNumber recordNumber, Class<T> typeClass) {
        return this.pdb.getTypeRecord(recordNumber, typeClass);
    }

    public <T extends AbstractMsType> T getMappedTypeRecord(RecordNumber recordNumber, Class<T> typeClass) {
        RecordNumber mappedNumber = this.getMappedRecordNumber(recordNumber);
        return this.pdb.getTypeRecord(mappedNumber, typeClass);
    }

    RecordNumber getMappedRecordNumber(RecordNumber recordNumber) {
        return this.complexTypeMapper.getMapped(recordNumber);
    }

    int findModuleNumberBySectionOffsetContribution(int section, long offset) throws PdbException {
        PdbDebugInfo debugInfo = this.pdb.getDebugInfo();
        if (debugInfo == null) {
            throw new PdbException("PDB: DebugInfo is null");
        }
        for (SectionContribution sectionContribution : debugInfo.getSectionContributionList()) {
            int sectionContributionOffset = sectionContribution.getOffset();
            int maxSectionContributionOffset = sectionContributionOffset + sectionContribution.getLength();
            if (offset < (long)sectionContributionOffset || offset >= (long)maxSectionContributionOffset) continue;
            return sectionContribution.getModule();
        }
        throw new PdbException("PDB: Module not found for section/offset");
    }

    private void processAndResolveDataTypesSequentially() throws CancelledException, PdbException {
        TypeProgramInterface tpi = this.pdb.getTypeProgramInterface();
        if (tpi == null) {
            return;
        }
        int num = tpi.getTypeIndexMaxExclusive() - tpi.getTypeIndexMin();
        this.monitor.initialize((long)(2 * num));
        this.monitor.setMessage("PDB: Processing " + num + " data type components...");
        for (int indexNumber = tpi.getTypeIndexMin(); indexNumber < tpi.getTypeIndexMaxExclusive(); ++indexNumber) {
            this.monitor.checkCancelled();
            RecordNumber recordNumber = RecordNumber.typeRecordNumber(indexNumber);
            RecordNumber mappedNumber = this.getMappedRecordNumber(recordNumber);
            this.multiphaseResolver.process(mappedNumber, this.monitor);
        }
        this.doCheck();
    }

    private void doCheck() throws PdbException {
        for (Map.Entry<RecordNumber, DataType> entry : this.dataTypeByMsTypeNum.entrySet()) {
            DataType dt = entry.getValue();
            if (!(dt instanceof DataTypeImpl) || dt instanceof Pointer || dt instanceof BitFieldDataType || dt instanceof BuiltInDataType) continue;
            throw new PdbException("Type not fully processed: " + String.valueOf(entry.getKey()));
        }
    }

    void putRecordNumberByFileName(RecordNumber recordNumber, String filename) {
        Set<RecordNumber> recordNumbers = this.recordNumbersByFileName.get(filename);
        if (recordNumbers == null) {
            recordNumbers = new HashSet<RecordNumber>();
            this.recordNumbersByFileName.put(filename, recordNumbers);
        }
        recordNumbers.add(recordNumber);
    }

    void putRecordNumberByModuleNumber(RecordNumber recordNumber, int moduleNumber) {
        Set<RecordNumber> recordNumbers = this.recordNumbersByModuleNumber.get(moduleNumber);
        if (recordNumbers == null) {
            recordNumbers = new HashSet<RecordNumber>();
            this.recordNumbersByModuleNumber.put(moduleNumber, recordNumbers);
        }
        recordNumbers.add(recordNumber);
    }

    void dumpSourceFileRecordNumbers() {
        AbstractMsType msType;
        PdbLog.message("RecordNumbersByFileName");
        for (Map.Entry<String, Set<RecordNumber>> entry : this.recordNumbersByFileName.entrySet()) {
            String filename = entry.getKey();
            PdbLog.message("FileName: " + filename);
            for (RecordNumber recordNumber : entry.getValue()) {
                msType = this.getTypeRecord(recordNumber);
                PdbLog.message(recordNumber.toString() + "\n" + String.valueOf(msType));
            }
        }
        PdbLog.message("RecordNumbersByModuleNumber");
        for (Map.Entry<Object, Set<RecordNumber>> entry : this.recordNumbersByModuleNumber.entrySet()) {
            int moduleNumber = (Integer)entry.getKey();
            PdbLog.message("ModuleNumber: " + moduleNumber);
            for (RecordNumber recordNumber : entry.getValue()) {
                msType = this.getTypeRecord(recordNumber);
                PdbLog.message(recordNumber.toString() + "\n" + String.valueOf(msType));
            }
        }
    }

    private void processItemTypesSequentially() throws CancelledException, PdbException {
        TypeProgramInterface ipi = this.pdb.getItemProgramInterface();
        if (ipi == null) {
            return;
        }
        int num = ipi.getTypeIndexMaxExclusive() - ipi.getTypeIndexMin();
        this.monitor.initialize((long)num);
        this.monitor.setMessage("PDB: Processing " + num + " item type components...");
        for (int indexNumber = ipi.getTypeIndexMin(); indexNumber < ipi.getTypeIndexMaxExclusive(); ++indexNumber) {
            this.monitor.checkCancelled();
            RecordNumber recordNumber = RecordNumber.itemRecordNumber(indexNumber);
            AbstractMsType msType = this.getTypeRecord(recordNumber);
            MsTypeApplier applier = this.getTypeApplier(recordNumber);
            this.monitor.incrementProgress(1L);
        }
    }

    private void processSequentially() throws CancelledException, PdbException {
        this.processAndResolveDataTypesSequentially();
        this.processItemTypesSequentially();
    }

    DataType resolve(DataType dataType) {
        if (!(dataType instanceof DataTypeImpl)) {
            return dataType;
        }
        DataType resolved = this.getDataTypeManager().resolve(dataType, null);
        ++this.resolveCount;
        if (DataTypeUtilities.isConflictDataType((DataType)resolved)) {
            ++this.conflictCount;
        }
        return resolved;
    }

    Function getExistingOrCreateOneByteFunction(Address address) {
        if (this.program == null) {
            return null;
        }
        Address normalizedAddress = PseudoDisassembler.getNormalizedDisassemblyAddress((Program)this.program, (Address)address);
        Function myFunction = this.program.getListing().getFunctionAt(normalizedAddress);
        if (myFunction != null) {
            return myFunction;
        }
        CreateFunctionCmd funCmd = new CreateFunctionCmd(null, normalizedAddress, (AddressSetView)new AddressSet(normalizedAddress, normalizedAddress), SourceType.DEFAULT);
        if (!funCmd.applyTo(this.program, (TaskMonitor)this.cancelOnlyWrappingMonitor)) {
            this.appendLogMsg("Failed to apply function at address " + address.toString() + "; attempting to use possible existing function");
            return this.program.getListing().getFunctionAt(normalizedAddress);
        }
        myFunction = funCmd.getFunction();
        return myFunction;
    }

    Function getExistingFunction(Address address) {
        if (this.program == null) {
            return null;
        }
        return this.program.getListing().getFunctionAt(address);
    }

    SymbolGroup getSymbolGroup() {
        return this.getSymbolGroupForModule(0);
    }

    SymbolGroup getSymbolGroupForModule(int moduleNumber) {
        if (moduleNumber < 0 || moduleNumber >= this.symbolGroups.size()) {
            return null;
        }
        return this.symbolGroups.get(moduleNumber);
    }

    boolean isInvalidAddress(Address address, String name) {
        if (address == PdbAddressManager.BAD_ADDRESS) {
            this.appendLogMsg("Invalid address encountered for: " + name);
            return true;
        }
        if (address == PdbAddressManager.ZERO_ADDRESS) {
            return true;
        }
        return address == PdbAddressManager.EXTERNAL_ADDRESS;
    }

    Address getImageBase() {
        return this.imageBase;
    }

    Address getAddress(AddressMsSymbol symbol) {
        return this.pdbAddressManager.getAddress(symbol);
    }

    Address getAddress(int segment, long offset) {
        return this.pdbAddressManager.getAddress(segment, offset);
    }

    Address getRawAddress(AddressMsSymbol symbol) {
        return this.pdbAddressManager.getRawAddress(symbol);
    }

    Address witnessSymbolNameAtAddress(String name, Address address) {
        return this.pdbAddressManager.witnessSymbolNameAtAddress(name, address);
    }

    Address getRemapAddressByAddress(Address address) {
        return this.pdbAddressManager.getRemapAddressByAddress(address);
    }

    void addMemoryGroupRefinement(PeCoffGroupMsSymbol symbol) {
        this.pdbAddressManager.addMemoryGroupRefinement(symbol);
    }

    void addMemorySectionRefinement(PeCoffSectionMsSymbol symbol) {
        this.pdbAddressManager.addMemorySectionRefinement(symbol);
    }

    boolean isDll() {
        return this.pdbPeHeaderInfoManager.isDll();
    }

    boolean isAslr() {
        return this.pdbPeHeaderInfoManager.isAslr();
    }

    @Override
    public long getOriginalImageBase() {
        return this.pdbPeHeaderInfoManager.getOriginalImageBase();
    }

    CliAbstractTableRow getCliTableRow(int tableNum, int rowNum) throws PdbException {
        return this.pdbPeHeaderInfoManager.getCliTableRow(tableNum, rowNum);
    }

    MsVxtManager getVxtManager() {
        return this.vxtManager;
    }

    Register getRegister(String pdbRegisterName) {
        return this.registerNameToRegisterMapper.getRegister(pdbRegisterName);
    }

    private void processAllSymbols() throws CancelledException, PdbException {
        this.processMainSymbols();
        this.processModuleSymbols();
    }

    private void processMainSymbols() throws CancelledException, PdbException {
        SymbolGroup symbolGroup = this.getSymbolGroup();
        if (symbolGroup == null) {
            return;
        }
        int totalCount = symbolGroup.size();
        this.monitor.setMessage("PDB: Applying " + totalCount + " main symbol components...");
        this.monitor.initialize((long)totalCount);
        MsSymbolIterator iter = symbolGroup.getSymbolIterator();
        this.processSymbolGroup(0, iter);
    }

    private AddressSet gatherAddressesForDisassembly() throws CancelledException, PdbException {
        if (this.program == null) {
            return null;
        }
        PdbDebugInfo debugInfo = this.pdb.getDebugInfo();
        int num = debugInfo.getNumModules();
        this.monitor.setMessage("PDB: Deferred-applying module symbol components...");
        this.monitor.initialize((long)(num + 1));
        AddressSet addresses = new AddressSet();
        for (int moduleNumber = 0; moduleNumber <= num; ++moduleNumber) {
            this.monitor.checkCancelled();
            this.setCurrentModuleNumber(moduleNumber);
            SymbolGroup symbolGroup = this.getSymbolGroupForModule(moduleNumber);
            if (symbolGroup != null) {
                MsSymbolIterator iter = symbolGroup.getSymbolIterator();
                addresses.add((AddressSetView)this.getDisassembleAddressForModule(moduleNumber, iter));
            }
            this.monitor.increment();
        }
        return addresses;
    }

    AddressSet getDisassembleAddressForModule(int moduleNumber, MsSymbolIterator iter) throws CancelledException {
        iter.initGet();
        AddressSet addresses = new AddressSet();
        while (iter.hasNext()) {
            this.monitor.checkCancelled();
            MsSymbolApplier applier = this.getSymbolApplier(iter);
            if (applier instanceof DisassembleableAddressSymbolApplier) {
                DisassembleableAddressSymbolApplier disassembleApplier = (DisassembleableAddressSymbolApplier)((Object)applier);
                addresses.add(disassembleApplier.getAddressForDisassembly());
            }
            iter.next();
        }
        return addresses;
    }

    int getCurrentModuleNumber() {
        return this.currentModuleNumber;
    }

    private void setCurrentModuleNumber(int moduleNumber) {
        this.currentModuleNumber = moduleNumber;
    }

    private void doDeferredProcessModuleSymbols() throws CancelledException, PdbException {
        PdbDebugInfo debugInfo = this.pdb.getDebugInfo();
        if (debugInfo == null) {
            return;
        }
        this.monitor.setMessage("PDB: Deferred-applying module symbol components...");
        int num = debugInfo.getNumModules();
        this.monitor.initialize((long)num);
        for (int moduleNumber = 1; moduleNumber <= num; ++moduleNumber) {
            this.monitor.checkCancelled();
            this.setCurrentModuleNumber(moduleNumber);
            SymbolGroup symbolGroup = this.getSymbolGroupForModule(moduleNumber);
            if (symbolGroup != null) {
                MsSymbolIterator iter = symbolGroup.getSymbolIterator();
                this.doDeferredModuleSymbolGroup(moduleNumber, iter);
            }
            this.monitor.increment();
        }
    }

    private void doDeferredModuleSymbolGroup(int moduleNumber, MsSymbolIterator iter) throws CancelledException {
        iter.initGet();
        while (iter.hasNext()) {
            this.monitor.checkCancelled();
            AbstractMsSymbol symbol = iter.peek();
            if (!(symbol instanceof AbstractUserDefinedTypeMsSymbol)) {
                this.procSymDeferred(iter);
                continue;
            }
            iter.next();
        }
    }

    private void processModuleSymbols() throws CancelledException, PdbException {
        PdbDebugInfo debugInfo = this.pdb.getDebugInfo();
        if (debugInfo == null) {
            return;
        }
        int num = debugInfo.getNumModules();
        this.monitor.setMessage("PDB: Applying module symbol components...");
        this.monitor.initialize((long)num);
        for (int moduleNumber = 1; moduleNumber <= num; ++moduleNumber) {
            this.monitor.checkCancelled();
            this.setCurrentModuleNumber(moduleNumber);
            SymbolGroup symbolGroup = this.getSymbolGroupForModule(moduleNumber);
            if (symbolGroup != null) {
                MsSymbolIterator iter = symbolGroup.getSymbolIterator();
                this.processSymbolGroup(moduleNumber, iter);
            }
            this.monitor.increment();
        }
    }

    private void processSymbolGroup(int moduleNumber, MsSymbolIterator iter) throws CancelledException {
        iter.initGet();
        while (iter.hasNext()) {
            this.monitor.checkCancelled();
            this.procSymNew(iter);
        }
    }

    private void processPublicSymbols() throws CancelledException, PdbException {
        PdbDebugInfo debugInfo = this.pdb.getDebugInfo();
        if (debugInfo == null) {
            return;
        }
        SymbolGroup symbolGroup = this.getSymbolGroup();
        if (symbolGroup == null) {
            return;
        }
        PublicSymbolInformation publicSymbolInformation = debugInfo.getPublicSymbolInformation();
        this.monitor.setMessage("PDB: Applying public symbols...");
        MsSymbolIterator iter = symbolGroup.getSymbolIterator();
        List<Long> offsets = publicSymbolInformation.getModifiedHashRecordSymbolOffsets();
        this.monitor.initialize((long)offsets.size());
        for (long offset : offsets) {
            this.monitor.checkCancelled();
            iter.initGetByOffset(offset);
            if (!iter.hasNext()) break;
            this.pdbApplicatorMetrics.witnessPublicSymbolType(iter.peek());
            this.procSymNew(iter);
            this.monitor.incrementProgress(1L);
        }
    }

    private void processGlobalSymbolsNoTypedefs() throws CancelledException, PdbException {
        PdbDebugInfo debugInfo = this.pdb.getDebugInfo();
        if (debugInfo == null) {
            return;
        }
        this.monitor.setMessage("PDB: Applying global symbols...");
        GlobalSymbolInformation globalSymbolInformation = debugInfo.getGlobalSymbolInformation();
        MsSymbolIterator iter = debugInfo.getSymbolIterator();
        List<Long> offsets = globalSymbolInformation.getModifiedHashRecordSymbolOffsets();
        this.monitor.initialize((long)offsets.size());
        for (long offset : offsets) {
            this.monitor.checkCancelled();
            iter.initGetByOffset(offset);
            if (!iter.hasNext()) break;
            AbstractMsSymbol symbol = iter.peek();
            this.pdbApplicatorMetrics.witnessGlobalSymbolType(symbol);
            if (!(symbol instanceof AbstractUserDefinedTypeMsSymbol)) {
                this.procSymNew(iter);
            }
            this.monitor.incrementProgress(1L);
        }
    }

    private void doDeferredProcessGlobalSymbolsNoTypedefs() throws CancelledException, PdbException {
        PdbDebugInfo debugInfo = this.pdb.getDebugInfo();
        if (debugInfo == null) {
            return;
        }
        GlobalSymbolInformation globalSymbolInformation = debugInfo.getGlobalSymbolInformation();
        MsSymbolIterator iter = debugInfo.getSymbolIterator();
        List<Long> offsets = globalSymbolInformation.getModifiedHashRecordSymbolOffsets();
        this.monitor.initialize((long)offsets.size(), "PDB: Performing deferred global symbols processing...");
        for (long offset : offsets) {
            this.monitor.checkCancelled();
            iter.initGetByOffset(offset);
            if (!iter.hasNext()) break;
            AbstractMsSymbol symbol = iter.peek();
            if (!(symbol instanceof AbstractUserDefinedTypeMsSymbol)) {
                this.procSymDeferred(iter);
            }
            this.monitor.incrementProgress(1L);
        }
    }

    private void processGlobalTypdefSymbols() throws CancelledException, PdbException {
        PdbDebugInfo debugInfo = this.pdb.getDebugInfo();
        if (debugInfo == null) {
            return;
        }
        SymbolGroup symbolGroup = this.getSymbolGroup();
        if (symbolGroup == null) {
            return;
        }
        this.monitor.setMessage("PDB: Applying typedefs...");
        GlobalSymbolInformation globalSymbolInformation = debugInfo.getGlobalSymbolInformation();
        MsSymbolIterator iter = symbolGroup.getSymbolIterator();
        List<Long> offsets = globalSymbolInformation.getModifiedHashRecordSymbolOffsets();
        this.monitor.initialize((long)offsets.size());
        for (long offset : offsets) {
            this.monitor.checkCancelled();
            iter.initGetByOffset(offset);
            if (!iter.hasNext()) break;
            AbstractMsSymbol symbol = iter.peek();
            if (symbol instanceof AbstractUserDefinedTypeMsSymbol) {
                this.procSymNew(iter);
            }
            this.monitor.incrementProgress(1L);
        }
    }

    private void processNonPublicOrGlobalSymbols() throws CancelledException, PdbException {
        PdbDebugInfo debugInfo = this.pdb.getDebugInfo();
        if (debugInfo == null) {
            return;
        }
        SymbolGroup symbolGroup = this.getSymbolGroup();
        if (symbolGroup == null) {
            return;
        }
        Set<Long> offsetsRemaining = symbolGroup.getOffsets();
        for (long off : debugInfo.getPublicSymbolInformation().getModifiedHashRecordSymbolOffsets()) {
            this.monitor.checkCancelled();
            offsetsRemaining.remove(off);
        }
        for (long off : debugInfo.getGlobalSymbolInformation().getModifiedHashRecordSymbolOffsets()) {
            this.monitor.checkCancelled();
            offsetsRemaining.remove(off);
        }
        this.monitor.setMessage("PDB: Applying " + offsetsRemaining.size() + " other symbol components...");
        this.monitor.initialize((long)offsetsRemaining.size());
        MsSymbolIterator iter = symbolGroup.getSymbolIterator();
        for (long offset : offsetsRemaining) {
            this.monitor.checkCancelled();
            iter.initGetByOffset(offset);
            AbstractMsSymbol symbol = iter.peek();
            this.procSymNew(iter);
            this.monitor.incrementProgress(1L);
        }
    }

    int getLinkerModuleNumber() {
        return this.linkerModuleNumber;
    }

    private int findLinkerModuleNumber() {
        PdbDebugInfo debugInfo = this.pdb.getDebugInfo();
        if (debugInfo != null) {
            int num = 1;
            for (ModuleInformation module : debugInfo.getModuleInformationList()) {
                if (this.isLinkerModule(module.getModuleName())) {
                    return num;
                }
                ++num;
            }
        }
        this.pdbLogAndInfoMessage(this, "Not processing linker symbols because linker module not found");
        return -1;
    }

    private boolean isLinkerModule(String name) {
        return "* Linker *".equals(name);
    }

    private boolean processLinkerSymbols() throws CancelledException, PdbException {
        SymbolGroup symbolGroup = this.getSymbolGroupForModule(this.linkerModuleNumber);
        if (symbolGroup == null) {
            Msg.info((Object)this, (Object)"No symbols to process from linker module.");
            return false;
        }
        this.monitor.setMessage("PDB: Applying " + symbolGroup.size() + " linker symbol components...");
        this.monitor.initialize((long)symbolGroup.size());
        MsSymbolIterator iter = symbolGroup.getSymbolIterator();
        while (iter.hasNext()) {
            this.monitor.checkCancelled();
            this.pdbApplicatorMetrics.witnessLinkerSymbolType(iter.peek());
            this.procSymNew(iter);
            this.monitor.incrementProgress(1L);
        }
        return true;
    }

    @Override
    public List<PeCoffSectionMsSymbol> getLinkerPeCoffSectionSymbols() throws CancelledException, PdbException {
        this.processLinkerModuleSpecialInformation();
        return this.linkerPeCoffSectionSymbols;
    }

    @Override
    public AbstractMsSymbol getLinkerModuleCompileSymbol() throws CancelledException, PdbException {
        this.processLinkerModuleSpecialInformation();
        return this.compileSymbolForLinkerModule;
    }

    private void processLinkerModuleSpecialInformation() throws CancelledException, PdbException {
        if (this.processedLinkerModule) {
            return;
        }
        ArrayList<PeCoffSectionMsSymbol> symbols = new ArrayList<PeCoffSectionMsSymbol>();
        AbstractMsSymbol compileSymbol = null;
        SymbolGroup symbolGroup = this.getSymbolGroupForModule(this.linkerModuleNumber);
        if (symbolGroup != null) {
            this.monitor.initialize((long)symbolGroup.size());
            MsSymbolIterator iter = symbolGroup.getSymbolIterator();
            int numCompileSymbols = 0;
            int compileSymbolNumForCoffSymbols = -1;
            while (iter.hasNext()) {
                this.monitor.checkCancelled();
                AbstractMsSymbol symbol = iter.next();
                this.getPdbApplicatorMetrics().witnessLinkerSymbolType(symbol);
                if (symbol instanceof PeCoffSectionMsSymbol) {
                    symbols.add((PeCoffSectionMsSymbol)symbol);
                    if (numCompileSymbols == 0) {
                        Msg.info((Object)this, (Object)"PE COFF symbol found before linker compile symbol");
                    }
                    if (compileSymbolNumForCoffSymbols == -1) {
                        compileSymbolNumForCoffSymbols = numCompileSymbols;
                    } else if (compileSymbolNumForCoffSymbols != numCompileSymbols) {
                        Msg.info((Object)this, (Object)"Linker COFF symbols found under multiple compiler symbols");
                    }
                } else if (symbol instanceof Compile3MsSymbol || symbol instanceof AbstractCompile2MsSymbol) {
                    ++numCompileSymbols;
                    if (symbols.isEmpty()) {
                        compileSymbol = symbol;
                    }
                }
                this.monitor.incrementProgress(1L);
            }
        }
        this.linkerPeCoffSectionSymbols = symbols;
        this.compileSymbolForLinkerModule = compileSymbol;
        this.processedLinkerModule = true;
    }

    private void processThunkSymbolsFromNonLinkerModules() throws CancelledException, PdbException {
        PdbDebugInfo debugInfo = this.pdb.getDebugInfo();
        if (debugInfo == null) {
            return;
        }
        int num = debugInfo.getNumModules();
        this.monitor.setMessage("PDB: Processing module thunks...");
        this.monitor.initialize((long)num);
        for (int index = 1; index <= num; ++index) {
            SymbolGroup symbolGroup;
            this.monitor.checkCancelled();
            if (index == this.linkerModuleNumber || (symbolGroup = this.getSymbolGroupForModule(index)) == null) continue;
            MsSymbolIterator iter = symbolGroup.getSymbolIterator();
            while (iter.hasNext()) {
                this.monitor.checkCancelled();
                AbstractMsSymbol symbol = iter.peek();
                if (symbol instanceof AbstractThunkMsSymbol) {
                    this.procSymNew(iter);
                    continue;
                }
                iter.next();
            }
            this.monitor.incrementProgress(1L);
        }
    }

    MsSymbolApplier getSymbolApplier(MsSymbolIterator iter) throws CancelledException {
        return this.symbolApplierParser.getSymbolApplier(iter);
    }

    MsSymbolApplier getSymbolApplier(AbstractMsSymbol symbol, MsSymbolIterator iter) throws CancelledException {
        return this.symbolApplierParser.getSymbolApplier(symbol, iter);
    }

    void procSymNew(MsSymbolIterator iter) throws CancelledException {
        try {
            MsSymbolApplier applier = this.getSymbolApplier(iter);
            if (applier instanceof DirectSymbolApplier) {
                DirectSymbolApplier directApplier = (DirectSymbolApplier)((Object)applier);
                directApplier.apply(iter);
            } else {
                iter.next();
            }
        }
        catch (PdbException e) {
            Msg.info((Object)this, (Object)("Error applying symbol to program: " + e.toString()));
        }
    }

    void procSymDeferred(MsSymbolIterator iter) throws CancelledException {
        try {
            MsSymbolApplier applier = this.getSymbolApplier(iter);
            if (applier instanceof DeferrableFunctionSymbolApplier) {
                DeferrableFunctionSymbolApplier deferrableApplier = (DeferrableFunctionSymbolApplier)((Object)applier);
                deferrableApplier.deferredApply(iter);
            } else {
                iter.next();
            }
        }
        catch (PdbException e) {
            Msg.info((Object)this, (Object)("Error during deferred processing of symbol to program: " + e.toString()));
        }
    }

    boolean isClass(SymbolPath path) {
        return this.isClassByNamespace.get(path);
    }

    void predefineClass(SymbolPath classPath) {
        if (classPath == null) {
            return;
        }
        this.isClassByNamespace.put(classPath, true);
        for (SymbolPath path = classPath.getParent(); path != null; path = path.getParent()) {
            if (this.isClassByNamespace.containsKey(path)) continue;
            this.isClassByNamespace.put(path, false);
        }
    }

    private void defineClasses() throws CancelledException {
        this.monitor.initialize((long)this.isClassByNamespace.size());
        this.monitor.setMessage("PDB: Defining classes...");
        for (Map.Entry<SymbolPath, Boolean> entry : this.isClassByNamespace.entrySet()) {
            this.monitor.checkCancelled();
            SymbolPath path = entry.getKey();
            boolean isClass = entry.getValue();
            Namespace parentNamespace = NamespaceUtils.getNonFunctionNamespace((Program)this.program, (SymbolPath)path.getParent());
            if (parentNamespace == null) {
                String type = isClass ? "class" : "namespace";
                this.log.appendMsg("PDB Warning: Because parent namespace does not exist, failed to define " + type + ": " + String.valueOf(path));
                this.monitor.incrementProgress(1L);
                continue;
            }
            this.defineNamespace(parentNamespace, path.getName(), isClass);
            this.monitor.incrementProgress(1L);
        }
    }

    private void defineNamespace(Namespace parentNamespace, String name, boolean isClass) {
        try {
            SymbolTable symbolTable = this.program.getSymbolTable();
            Namespace namespace = symbolTable.getNamespace(name, parentNamespace);
            if (namespace != null) {
                if (isClass) {
                    if (namespace instanceof GhidraClass) {
                        return;
                    }
                    if (this.isSimpleNamespaceSymbol(namespace)) {
                        NamespaceUtils.convertNamespaceToClass((Namespace)namespace);
                        return;
                    }
                } else if (namespace.getSymbol().getSymbolType() == SymbolType.NAMESPACE) {
                    return;
                }
                this.log.appendMsg("PDB Warning: Unable to create class namespace due to conflicting symbol: " + namespace.getName(true));
            } else if (isClass) {
                symbolTable.createClass(parentNamespace, name, SourceType.IMPORTED);
            } else {
                symbolTable.createNameSpace(parentNamespace, name, SourceType.IMPORTED);
            }
        }
        catch (DuplicateNameException | InvalidInputException e) {
            this.log.appendMsg("PDB Warning: Unable to create class namespace due to exception: " + e.toString() + "; Namespace: " + parentNamespace.getName(true) + "::" + name);
        }
    }

    private boolean isSimpleNamespaceSymbol(Namespace namespace) {
        Symbol s = namespace.getSymbol();
        if (s.getSymbolType() != SymbolType.NAMESPACE) {
            return false;
        }
        for (Namespace n = namespace; n != null; n = n.getParentNamespace()) {
            if (!(n instanceof Function)) continue;
            return false;
        }
        return true;
    }

    private void storeLabelByAddress(Address address, String label) {
        Set<String> labels = this.labelsByAddress.get(address);
        if (labels == null) {
            labels = new TreeSet<String>();
            this.labelsByAddress.put(address, labels);
        }
        if (labels.contains(label)) {
            // empty if block
        }
        labels.add(label);
    }

    private void dumpLabels() {
        for (Map.Entry<Address, Set<String>> entry : this.labelsByAddress.entrySet()) {
            Address address = entry.getKey();
            Set<String> labels = entry.getValue();
            System.out.println("\nAddress: " + String.valueOf(address));
            for (String label : labels) {
                System.out.println(label);
            }
        }
    }

    boolean addToPlateUnique(Address address, String comment) {
        if (StringUtils.isBlank((CharSequence)comment)) {
            return false;
        }
        Object plate = this.program.getListing().getComment(CommentType.PLATE, address);
        if (plate == null) {
            plate = "";
        } else {
            if (((String)plate).contains((CharSequence)comment)) {
                return true;
            }
            if (!((String)comment).endsWith("\n")) {
                comment = (String)comment + "\n";
            }
        }
        plate = (String)comment + (String)plate;
        SetCommentCmd.createComment((Program)this.program, (Address)address, (String)plate, (CommentType)CommentType.PLATE);
        return true;
    }

    Symbol createSymbol(Address address, String symbolPathString, boolean isNewFunctionSignature) {
        return this.createSymbol(address, symbolPathString, isNewFunctionSignature, null);
    }

    Symbol createSymbol(Address address, SymbolPath symbolPath, boolean isNewFunctionSignature) {
        symbolPath = MDMangUtils.standarizeSymbolPathUnderscores((SymbolPath)symbolPath);
        symbolPath = symbolPath.replaceInvalidChars();
        return this.createSymbolInternal(address, symbolPath, isNewFunctionSignature, null);
    }

    Symbol createSymbol(Address address, String symbolPathString, boolean isNewFunctionSignature, String plateAddition) {
        SymbolPath symbolPath = this.getCleanSymbolPath(symbolPathString);
        return this.createSymbolInternal(address, symbolPath, isNewFunctionSignature, plateAddition);
    }

    private Symbol createSymbolInternal(Address address, SymbolPath symbolPath, boolean isNewFunctionSignature, String plateAddition) {
        Symbol existingSymbol = this.program.getSymbolTable().getPrimarySymbol(address);
        if (existingSymbol == null || isNewFunctionSignature) {
            return this.doCreateSymbol(address, symbolPath, true, plateAddition);
        }
        if (existingSymbol.getSymbolType() == SymbolType.FUNCTION && existingSymbol.getSource() == SourceType.DEFAULT) {
            return this.doCreateSymbol(address, symbolPath, true, plateAddition);
        }
        Function existingFunction = this.program.getListing().getFunctionAt(address);
        if (existingFunction != null && existingFunction.getSignatureSource().isHigherOrEqualPriorityThan(SourceType.IMPORTED)) {
            return this.doCreateSymbol(address, symbolPath, false, plateAddition);
        }
        if (!existingSymbol.getParentNamespace().equals((Object)this.program.getGlobalNamespace()) && !this.preferNewSymbolOverExistingNamespacedSymbol(symbolPath)) {
            return this.doCreateSymbol(address, symbolPath, false, plateAddition);
        }
        boolean existingIsMangled = DefaultPdbApplicator.isMangled(existingSymbol.getName());
        if (existingIsMangled && !isNewFunctionSignature) {
            return this.doCreateSymbol(address, symbolPath, false, plateAddition);
        }
        if (symbolPath.getParent() != null) {
            return this.doCreateSymbol(address, symbolPath, true, plateAddition);
        }
        if (DefaultPdbApplicator.isMangled(symbolPath.getName()) && !existingIsMangled) {
            return this.doCreateSymbol(address, symbolPath, true, plateAddition);
        }
        return this.doCreateSymbol(address, symbolPath, false, plateAddition);
    }

    private boolean preferNewSymbolOverExistingNamespacedSymbol(SymbolPath symbolPath) {
        String name = symbolPath.getName();
        return name.startsWith("??_7") || name.startsWith("??_8");
    }

    private Symbol doCreateSymbol(Address address, SymbolPath symbolPath, boolean makePrimary, String plateAddition) {
        Symbol symbol = null;
        try {
            Namespace namespace = this.program.getGlobalNamespace();
            String name = symbolPath.getName();
            String namespacePath = symbolPath.getParentPath();
            if (namespacePath != null) {
                namespace = NamespaceUtils.createNamespaceHierarchy((String)namespacePath, (Namespace)namespace, (Program)this.program, (Address)address, (SourceType)SourceType.IMPORTED);
            }
            symbol = this.program.getSymbolTable().createLabel(address, name, namespace, SourceType.IMPORTED);
            if (makePrimary && !symbol.isPrimary()) {
                SetLabelPrimaryCmd cmd = new SetLabelPrimaryCmd(address, symbol.getName(), symbol.getParentNamespace());
                cmd.applyTo(this.program);
            }
        }
        catch (InvalidInputException e) {
            this.log.appendMsg("PDB Warning: Unable to create symbol at " + String.valueOf(address) + " due to exception: " + e.toString() + "; symbolPathName: " + String.valueOf(symbolPath));
        }
        this.addToPlateUnique(address, plateAddition);
        return symbol;
    }

    private static boolean isMangled(String name) {
        return name.startsWith("?");
    }

    private SymbolPath getCleanSymbolPath(String symbolPathString) {
        if (symbolPathString.startsWith(THUNK_NAME_PREFIX)) {
            symbolPathString = symbolPathString.substring(THUNK_NAME_PREFIX.length(), symbolPathString.length());
        }
        SymbolPath symbolPath = new SymbolPath(symbolPathString);
        symbolPath = symbolPath.replaceInvalidChars();
        return symbolPath;
    }

    static class PdbUniversalAnalysisState {
        private PdbApplicatorMetrics pdbApplicatorMetrics = new PdbApplicatorMetrics();
        private Map<RecordNumber, DataType> dataTypeByMsTypeNum = new HashMap<RecordNumber, DataType>();
        private Map<RecordNumber, CppCompositeType> classTypeByMsTypeNum = new HashMap<RecordNumber, CppCompositeType>();
        private PdbAddressManager pdbAddressManager = new PdbAddressManager();
        private ComplexTypeMapper complexTypeMapper = new ComplexTypeMapper();

        PdbUniversalAnalysisState() {
        }

        PdbApplicatorMetrics getPdbApplicatorMetrics() {
            return this.pdbApplicatorMetrics;
        }

        PdbAddressManager getPdbAddressManager() {
            return this.pdbAddressManager;
        }

        ComplexTypeMapper getComplexTypeMapper() {
            return this.complexTypeMapper;
        }

        Map<RecordNumber, DataType> getDataTypeByMsTypeNumMap() {
            return this.dataTypeByMsTypeNum;
        }

        Map<RecordNumber, CppCompositeType> getClassTypeByMsTypeNumMap() {
            return this.classTypeByMsTypeNum;
        }
    }
}

