/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.space;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSpace;
import ghidra.trace.util.TraceSpaceMixin;

public interface DBTraceSpaceBased
extends TraceSpaceMixin {
    default public boolean isMySpace(AddressSpace space) {
        return space == this.getAddressSpace();
    }

    default public String explainLanguages(AddressSpace space) {
        if (space.getName().equals(this.getAddressSpace().getName())) {
            return ". It's likely they come from different languages. Check the platform.";
        }
        return "";
    }

    default public long assertInSpace(Address addr) {
        if (!this.isMySpace(addr.getAddressSpace())) {
            throw new IllegalArgumentException("Address '" + String.valueOf(addr) + "' is not in this space: '" + String.valueOf(this.getAddressSpace()) + "'" + this.explainLanguages(addr.getAddressSpace()));
        }
        return addr.getOffset();
    }

    default public void assertInSpace(AddressRange range) {
        if (!this.isMySpace(range.getAddressSpace())) {
            throw new IllegalArgumentException("Address Range '" + String.valueOf(range) + "' is not in this space: '" + String.valueOf(this.getAddressSpace()) + "'" + this.explainLanguages(range.getAddressSpace()));
        }
    }

    default public Address toOverlay(Address physical) {
        return this.getAddressSpace().getOverlayAddress(physical);
    }

    default public Address toAddress(long offset) {
        return this.getAddressSpace().getAddress(offset);
    }

    public void invalidateCache();
}

