/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.util;

import ghidra.program.model.address.Address;
import java.util.HashSet;
import java.util.Set;

public class AddressBasedOpenCloseManager {
    private boolean openByDefault = true;
    private Set<Address> addresses = new HashSet<Address>();

    public boolean isOpen(Address address) {
        boolean contains = this.addresses.contains(address);
        return this.openByDefault ? !contains : contains;
    }

    public void open(Address address) {
        if (this.openByDefault) {
            this.addresses.remove(address);
        } else {
            this.addresses.add(address);
        }
    }

    public void close(Address address) {
        if (this.openByDefault) {
            this.addresses.add(address);
        } else {
            this.addresses.remove(address);
        }
    }

    public boolean isOpenByDefault() {
        return this.openByDefault;
    }

    public void openAll() {
        this.openByDefault = true;
        this.addresses.clear();
    }

    public void closeAll() {
        this.openByDefault = false;
        this.addresses.clear();
    }
}

