/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.tree;

import generic.jar.ResourceFile;
import generic.theme.GIcon;
import ghidra.app.plugin.core.datamgr.archive.FileArchive;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.DtBackgroundIcon;
import ghidra.app.plugin.core.datamgr.tree.DtFilterState;
import javax.swing.Icon;
import resources.MultiIcon;
import resources.icons.TranslateIcon;

public class FileArchiveNode
extends ArchiveNode {
    private static Icon CHECKED_OUT_EXCLUSIVE_ICON = new GIcon("icon.plugin.datatypes.tree.node.archive.file.checked.out.exclusive");
    FileArchive fileArchive;

    public FileArchiveNode(FileArchive archive, DtFilterState filterState) {
        super(archive, filterState);
        this.fileArchive = archive;
    }

    @Override
    public Icon getIcon(boolean expanded) {
        DtBackgroundIcon bgIcon = new DtBackgroundIcon();
        MultiIcon multiIcon = new MultiIcon((Icon)bgIcon);
        boolean hasWriteLock = this.fileArchive.hasWriteLock();
        Icon baseIcon = this.fileArchive.getIcon(expanded);
        multiIcon.addIcon(baseIcon);
        if (hasWriteLock) {
            multiIcon.addIcon((Icon)new TranslateIcon(CHECKED_OUT_EXCLUSIVE_ICON, 8, -4));
        }
        return multiIcon;
    }

    @Override
    public String getToolTip() {
        ResourceFile file = this.fileArchive.getFile();
        return this.buildTooltip(file != null ? file.getAbsolutePath() : "[Unsaved New Archive]");
    }

    public boolean hasWriteLock() {
        return this.fileArchive.hasWriteLock();
    }
}

