/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets;

import docking.widgets.SingleRowLayoutManager;
import docking.widgets.VariableHeightLayoutManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JPanel;
import javax.swing.Scrollable;

public class VariableHeightPanel
extends JPanel
implements Scrollable {
    private boolean pack;
    private int hGap;
    private int vGap;

    private static Component getRootComponent(Component component) {
        if (component instanceof Window) {
            return component;
        }
        Container parent = component.getParent();
        if (parent == null) {
            return component;
        }
        return VariableHeightPanel.getRootComponent(parent);
    }

    public VariableHeightPanel(boolean pack, int hgap, int vgap) {
        this.pack = pack;
        this.hGap = hgap;
        this.vGap = vgap;
        this.setLayout(new VariableHeightLayoutManager(this.hGap, this.vGap, pack));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                VariableHeightPanel.this.invalidate();
                VariableHeightPanel.getRootComponent(VariableHeightPanel.this).validate();
            }
        });
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
    }

    @Override
    public void setBounds(Rectangle r) {
        super.setBounds(r);
    }

    public void setUseSingleLineLayout(boolean singleLineLayout) {
        if (this.pack) {
            if (singleLineLayout) {
                this.setLayout(new SingleRowLayoutManager(this.hGap, this.vGap));
            } else {
                this.setLayout(new VariableHeightLayoutManager(this.hGap, this.vGap, this.pack));
            }
        }
    }

    public Dimension getPreferredLayoutSize() {
        return ((VariableHeightLayoutManager)this.getLayout()).getPreferredSize(this);
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return visibleRect.height;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 20;
    }
}

