/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.program.model.data.AbstractColorDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.RGB32EncodingSettingsDefinition;
import ghidra.program.model.data.TypeDefSettingsDefinition;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.data.UnsignedIntegerDataType;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.DataConverter;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class RGB32ColorDataType
extends AbstractColorDataType {
    public static RGB32ColorDataType datatype = new RGB32ColorDataType();
    private static int LENGTH = 4;
    private static TypeDefSettingsDefinition[] RGB32_TYPEDEF_SETTINGS = TypeDefSettingsDefinition.concat(UnsignedIntegerDataType.dataType.getTypeDefSettingsDefinitions(), RGB32EncodingSettingsDefinition.DEF);

    public static TypedefDataType createRGB32Typedef(RGB32EncodingSettingsDefinition.RGB32Encoding rgb32Encoding) {
        Objects.requireNonNull(rgb32Encoding, "RGB32Encoding required");
        TypedefDataType dt = new TypedefDataType(rgb32Encoding.name(), datatype);
        Settings settings = dt.getDefaultSettings();
        RGB32EncodingSettingsDefinition.DEF.setRGBEncoding(settings, rgb32Encoding);
        return dt;
    }

    public RGB32ColorDataType() {
        this(null);
    }

    public RGB32ColorDataType(DataTypeManager dtm) {
        super("RGB32", dtm);
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new RGB32ColorDataType(dtm);
    }

    @Override
    public int getLength() {
        return LENGTH;
    }

    @Override
    public String getDescription() {
        return "An RGB color with 32-bit encoding (default encoding is ARGB_8888, use Typedef for other 32-bit encodings)";
    }

    @Override
    public TypeDefSettingsDefinition[] getTypeDefSettingsDefinitions() {
        return RGB32_TYPEDEF_SETTINGS;
    }

    @Override
    protected Color decodeColor(MemBuffer buf, Settings settings) {
        byte[] bytes = new byte[LENGTH];
        buf.getBytes(bytes, 0);
        int value = DataConverter.getInstance((boolean)ENDIAN.isBigEndian(settings, buf)).getInt(bytes, 0);
        RGB32EncodingSettingsDefinition.RGB32Encoding rgbEncoding = RGB32EncodingSettingsDefinition.DEF.getRGBEncoding(settings);
        switch (rgbEncoding) {
            case ARGB_8888: {
                break;
            }
            case RGBA_8888: {
                int alpha = value & 0xFF;
                int rgb = value >>> 8;
                value = rgb + (alpha << 24);
                break;
            }
            case BGRA_8888: {
                value = Integer.reverseBytes(value);
                break;
            }
            case ABGR_8888: {
                int rgb = Integer.reverseBytes(value) >>> 8;
                value = rgb + (value & 0xFF000000);
                break;
            }
            default: {
                throw new AssertionError((Object)("Missing RGB32 Encoding support: " + String.valueOf((Object)rgbEncoding)));
            }
        }
        return new Color(value, true);
    }

    @Override
    protected String getEncodingName(Settings settings) {
        return RGB32EncodingSettingsDefinition.DEF.getRGBEncoding(settings).name();
    }

    @Override
    protected List<AbstractColorDataType.ComponentValue> getComponentValues(MemBuffer buf, Settings settings) {
        byte[] bytes = new byte[LENGTH];
        buf.getBytes(bytes, 0);
        int value = DataConverter.getInstance((boolean)ENDIAN.isBigEndian(settings, buf)).getInt(bytes, 0);
        ArrayList<AbstractColorDataType.ComponentValue> list = new ArrayList<AbstractColorDataType.ComponentValue>();
        RGB32EncodingSettingsDefinition.RGB32Encoding rgbEncoding = RGB32EncodingSettingsDefinition.DEF.getRGBEncoding(settings);
        switch (rgbEncoding) {
            case ARGB_8888: {
                list.add(new AbstractColorDataType.ComponentValue("A", RGB32ColorDataType.getFieldValue(value, 24, 255), 8));
                list.add(new AbstractColorDataType.ComponentValue("R", RGB32ColorDataType.getFieldValue(value, 16, 255), 8));
                list.add(new AbstractColorDataType.ComponentValue("G", RGB32ColorDataType.getFieldValue(value, 8, 255), 8));
                list.add(new AbstractColorDataType.ComponentValue("B", RGB32ColorDataType.getFieldValue(value, 0, 255), 8));
                break;
            }
            case RGBA_8888: {
                list.add(new AbstractColorDataType.ComponentValue("R", RGB32ColorDataType.getFieldValue(value, 24, 255), 8));
                list.add(new AbstractColorDataType.ComponentValue("G", RGB32ColorDataType.getFieldValue(value, 16, 255), 8));
                list.add(new AbstractColorDataType.ComponentValue("B", RGB32ColorDataType.getFieldValue(value, 8, 255), 8));
                list.add(new AbstractColorDataType.ComponentValue("A", RGB32ColorDataType.getFieldValue(value, 0, 255), 8));
                break;
            }
            case BGRA_8888: {
                list.add(new AbstractColorDataType.ComponentValue("B", RGB32ColorDataType.getFieldValue(value, 24, 255), 8));
                list.add(new AbstractColorDataType.ComponentValue("G", RGB32ColorDataType.getFieldValue(value, 16, 255), 8));
                list.add(new AbstractColorDataType.ComponentValue("R", RGB32ColorDataType.getFieldValue(value, 8, 255), 8));
                list.add(new AbstractColorDataType.ComponentValue("A", RGB32ColorDataType.getFieldValue(value, 0, 255), 8));
                break;
            }
            case ABGR_8888: {
                list.add(new AbstractColorDataType.ComponentValue("A", RGB32ColorDataType.getFieldValue(value, 24, 255), 8));
                list.add(new AbstractColorDataType.ComponentValue("B", RGB32ColorDataType.getFieldValue(value, 16, 255), 8));
                list.add(new AbstractColorDataType.ComponentValue("G", RGB32ColorDataType.getFieldValue(value, 8, 255), 8));
                list.add(new AbstractColorDataType.ComponentValue("R", RGB32ColorDataType.getFieldValue(value, 0, 255), 8));
                break;
            }
            default: {
                throw new AssertionError((Object)("Missing RGB32 Encoding support: " + String.valueOf((Object)rgbEncoding)));
            }
        }
        return list;
    }
}

