/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.RecordIterator;
import db.Table;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.database.data.PointerDBAdapter;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class PointerDBAdapterV2
extends PointerDBAdapter {
    static final int VERSION = 2;
    private Table table;

    PointerDBAdapterV2(DBHandle handle, String tablePrefix, boolean create) throws VersionException, IOException {
        String tableName = tablePrefix + "Pointers";
        if (create) {
            this.table = handle.createTable(tableName, SCHEMA, new int[]{1});
        } else {
            this.table = handle.getTable(tableName);
            if (this.table == null) {
                throw new VersionException("Missing Table: " + tableName);
            }
            int version = this.table.getSchema().getVersion();
            if (version != 2) {
                throw new VersionException(version < 2);
            }
        }
    }

    @Override
    DBRecord createRecord(long dataTypeID, long categoryID, int length) throws IOException {
        long key = DataTypeManagerDB.createKey(4, this.table.getKey());
        DBRecord record = SCHEMA.createRecord(key);
        record.setLongValue(0, dataTypeID);
        record.setLongValue(1, categoryID);
        record.setByteValue(2, (byte)length);
        this.table.putRecord(record);
        return record;
    }

    @Override
    DBRecord getRecord(long pointerID) throws IOException {
        return this.table.getRecord(pointerID);
    }

    @Override
    RecordIterator getRecords() throws IOException {
        return this.table.iterator();
    }

    @Override
    boolean removeRecord(long pointerID) throws IOException {
        return this.table.deleteRecord(pointerID);
    }

    @Override
    void updateRecord(DBRecord record) throws IOException {
        this.table.putRecord(record);
    }

    @Override
    Field[] getRecordIdsInCategory(long categoryID) throws IOException {
        return this.table.findRecords((Field)new LongField(categoryID), 1);
    }

    @Override
    void deleteTable(DBHandle handle) throws IOException {
        handle.deleteTable(this.table.getName());
    }

    public DBRecord translateRecord(DBRecord rec) {
        return rec;
    }

    @Override
    public int getRecordCount() {
        return this.table.getRecordCount();
    }
}

