/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.generic;

import ghidra.util.exception.CryptoException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class iOS_AesCrypto {
    public static final String CRYPTO_ALGORITHM = "AES";
    public static final String CRYPTO_TRANSFORMATION_CBC = "AES/CBC/NoPadding";
    private int keyLength;
    private Key key;
    private IvParameterSpec iv;

    public iOS_AesCrypto(byte[] key, byte[] iv) {
        if (key == null) {
            throw new IllegalArgumentException("KEY is not specified, check the XML file and verify the KEY is correct.");
        }
        if (iv == null) {
            throw new IllegalArgumentException("IV is not specified, check the XML file and verify the IV is correct.");
        }
        this.keyLength = key.length * 8;
        this.key = new SecretKeySpec(key, CRYPTO_ALGORITHM);
        this.iv = new IvParameterSpec(iv);
    }

    public byte[] encrypt(byte[] plainText) throws CryptoException {
        throw new CryptoException("encrypt() not implemented");
    }

    public InputStream decrypt(InputStream is) throws CryptoException {
        try {
            Cipher cipher = Cipher.getInstance(CRYPTO_TRANSFORMATION_CBC);
            int maxAllowedKeyLength = Cipher.getMaxAllowedKeyLength(CRYPTO_TRANSFORMATION_CBC);
            if (maxAllowedKeyLength < this.keyLength) {
                throw new InvalidKeyException("Attempt to decrypt using " + this.keyLength + " bit key size, but the JVM only supports " + maxAllowedKeyLength + " bit keys.  Install the JCE to fix this issue.");
            }
            cipher.init(2, this.key, this.iv);
            CipherInputStream cis = new CipherInputStream(is, cipher);
            return cis;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new CryptoException((Exception)e);
        }
    }

    public byte[] decrypt(byte[] cipherText) throws CryptoException {
        try {
            Cipher cipher = Cipher.getInstance(CRYPTO_TRANSFORMATION_CBC);
            int maxAllowedKeyLength = Cipher.getMaxAllowedKeyLength(CRYPTO_TRANSFORMATION_CBC);
            if (maxAllowedKeyLength < this.keyLength) {
                throw new InvalidKeyException("Attempt to decrypt using " + this.keyLength + " bit key size, but the JVM only supports " + maxAllowedKeyLength + " bit keys.  Install the JCE to fix this issue.");
            }
            cipher.init(2, this.key, this.iv);
            byte[] decrypted = cipher.doFinal(cipherText);
            return decrypted;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new CryptoException((Exception)e);
        }
    }

    public void update(byte[] update) throws CryptoException {
        throw new CryptoException("update() not implemented");
    }
}

