/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import org.jungrapht.visualization.control.CrossoverScalingControl;
import org.jungrapht.visualization.control.DefaultModalGraphMouse;
import org.jungrapht.visualization.control.ModalGraphMouse;
import org.jungrapht.visualization.control.RegionSelectingGraphMousePlugin;
import org.jungrapht.visualization.control.SatelliteRotatingGraphMousePlugin;
import org.jungrapht.visualization.control.SatelliteScalingGraphMousePlugin;
import org.jungrapht.visualization.control.SatelliteShearingGraphMousePlugin;
import org.jungrapht.visualization.control.SatelliteTranslatingGraphMousePlugin;
import org.jungrapht.visualization.control.SelectingGraphMousePlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModalSatelliteGraphMouse<V, E>
extends DefaultModalGraphMouse<V, E>
implements ModalGraphMouse {
    private static final Logger log = LoggerFactory.getLogger(ModalSatelliteGraphMouse.class);
    protected int singleSelectionMask;
    protected int toggleSingleSelectionMask;
    protected int regionSelectionMask;
    protected int toggleRegionSelectionMask;
    protected int regionSelectionCompleteMask;
    protected int toggleRegionSelectionCompleteMask;
    protected int translatingMask;
    protected int scalingMask;
    protected int xAxisScalingMask;
    protected int yAxisScalingMask;

    public static <V, E> Builder<V, E, ?, ?> builder() {
        return new Builder();
    }

    public ModalSatelliteGraphMouse() {
        this(new Builder());
    }

    ModalSatelliteGraphMouse(Builder<V, E, ?, ?> builder) {
        this(builder.in, builder.out, builder.vertexSelectionOnly, builder.singleSelectionMask, builder.toggleSingleSelectionMask, builder.regionSelectionMask, builder.toggleRegionSelectionMask, builder.regionSelectionCompleteMask, builder.toggleRegionSelectionCompleteMask, builder.translatingMask, builder.scalingMask, builder.xAxisScalingMask, builder.yAxisScalingMask);
    }

    ModalSatelliteGraphMouse(float in, float out, boolean vertexSelectionOnly, int singleSelectionMask, int toggleSingleSelectionMask, int regionSelectionMask, int toggleRegionSelectionMask, int regionSelectionCompleteMask, int toggleRegionSelectionCompleteMask, int translatingMask, int scalingMask, int xAxisScalingMask, int yAxisScalingMask) {
        super(in, out, vertexSelectionOnly);
        this.singleSelectionMask = singleSelectionMask;
        this.toggleSingleSelectionMask = toggleSingleSelectionMask;
        this.regionSelectionMask = regionSelectionMask;
        this.toggleRegionSelectionMask = toggleRegionSelectionMask;
        this.regionSelectionCompleteMask = regionSelectionCompleteMask;
        this.toggleRegionSelectionCompleteMask = toggleRegionSelectionCompleteMask;
        this.translatingMask = translatingMask;
        this.scalingMask = scalingMask;
        this.xAxisScalingMask = xAxisScalingMask;
        this.yAxisScalingMask = yAxisScalingMask;
    }

    @Override
    public void loadPlugins() {
        this.selectingPlugin = ((SelectingGraphMousePlugin.Builder)((SelectingGraphMousePlugin.Builder)SelectingGraphMousePlugin.builder().singleSelectionMask(1024)).toggleSingleSelectionMask(1088)).build();
        this.regionSelectingPlugin = ((RegionSelectingGraphMousePlugin.Builder)((RegionSelectingGraphMousePlugin.Builder)((RegionSelectingGraphMousePlugin.Builder)((RegionSelectingGraphMousePlugin.Builder)RegionSelectingGraphMousePlugin.builder().regionSelectionMask(1024)).toggleRegionSelectionMask(0)).regionSelectionCompleteMask(0)).toggleRegionSelectionCompleteMask(64)).build();
        this.translatingPlugin = ((SatelliteTranslatingGraphMousePlugin.Builder)SatelliteTranslatingGraphMousePlugin.builder().translatingMask(this.translatingMask)).build();
        this.scalingPlugin = new SatelliteScalingGraphMousePlugin(new CrossoverScalingControl(), this.scalingMask, this.xAxisScalingMask, this.yAxisScalingMask, this.in, this.out);
        this.rotatingPlugin = new SatelliteRotatingGraphMousePlugin();
        this.shearingPlugin = new SatelliteShearingGraphMousePlugin();
        this.add(this.scalingPlugin);
    }

    public static class Builder<V, E, T extends ModalSatelliteGraphMouse<V, E>, B extends Builder<V, E, T, B>>
    extends DefaultModalGraphMouse.Builder<V, E, T, B> {
        @Override
        public T build() {
            return (T)new ModalSatelliteGraphMouse(this);
        }
    }
}

