/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.reloc;

import db.BinaryCodedField;
import db.BinaryField;
import db.DBHandle;
import db.DBRecord;
import db.RecordIterator;
import ghidra.framework.data.OpenMode;
import ghidra.framework.options.Options;
import ghidra.program.database.ManagerDB;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.mem.AddressSourceInfo;
import ghidra.program.database.reloc.RelocationDBAdapter;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationTable;
import ghidra.program.util.ProgramEvent;
import ghidra.util.Lock;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RelocationManager
implements RelocationTable,
ManagerDB {
    private ProgramDB program;
    private AddressMap addrMap;
    private RelocationDBAdapter adapter;
    private Boolean isRelocatable = null;
    private Lock lock;

    public RelocationManager(DBHandle handle, AddressMap addrMap, OpenMode openMode, Lock lock, TaskMonitor monitor) throws VersionException, IOException {
        this.addrMap = addrMap;
        this.lock = lock;
        this.initializeAdapters(handle, openMode, monitor);
    }

    private void initializeAdapters(DBHandle handle, OpenMode openMode, TaskMonitor monitor) throws VersionException, IOException {
        this.adapter = RelocationDBAdapter.getAdapter(handle, openMode, this.addrMap, monitor);
    }

    @Override
    public void invalidateCache(boolean all) {
    }

    @Override
    public void setProgram(ProgramDB p) {
        this.program = p;
    }

    @Override
    public void programReady(OpenMode openMode, int currentRevision, TaskMonitor monitor) throws IOException, CancelledException {
        if (openMode == OpenMode.UPGRADE && currentRevision < 26) {
            RelocationDBAdapter.preV6DataMigrationUpgrade(this.adapter, this.program, monitor);
        }
    }

    static int getDefaultOriginalByteLength(Program program) {
        return program.getDefaultPointerSize() > 4 ? 8 : 4;
    }

    static byte[] getOriginalBytes(Memory memory, Address addr, int byteCount) throws IOException {
        byte[] originalBytes = new byte[byteCount];
        for (int i = 0; i < byteCount; ++i) {
            if (i != 0) {
                addr = addr.next();
            }
            if (addr == null) break;
            AddressSourceInfo addressSourceInfo = memory.getAddressSourceInfo(addr);
            if (addressSourceInfo == null) {
                return originalBytes;
            }
            originalBytes[i] = addressSourceInfo.getOriginalValue();
        }
        return originalBytes;
    }

    private byte[] getOriginalBytes(Address addr, Relocation.Status status, byte[] bytes, int defaultLength) throws IOException {
        if (bytes != null || !status.hasBytes()) {
            return bytes;
        }
        int byteCount = defaultLength;
        if (defaultLength <= 0) {
            byteCount = RelocationManager.getDefaultOriginalByteLength(this.program);
        }
        return RelocationManager.getOriginalBytes(this.program.getMemory(), addr, byteCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Relocation add(Address addr, Relocation.Status status, int type, long[] values, byte[] bytes, String symbolName) {
        this.lock.acquire();
        try {
            byte flags = RelocationDBAdapter.getFlags(status, 0);
            this.adapter.add(addr, flags, type, values, bytes, symbolName);
            Relocation reloc = new Relocation(addr, status, type, values, this.getOriginalBytes(addr, status, bytes, 0), symbolName);
            this.program.setChanged(ProgramEvent.RELOCATION_ADDED, null, reloc);
            Relocation relocation = reloc;
            return relocation;
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Relocation add(Address addr, Relocation.Status status, int type, long[] values, int byteLength, String symbolName) {
        this.lock.acquire();
        try {
            byte flags = RelocationDBAdapter.getFlags(status, byteLength);
            this.adapter.add(addr, flags, type, values, null, symbolName);
            Relocation reloc = new Relocation(addr, status, type, values, this.getOriginalBytes(addr, status, null, byteLength), symbolName);
            this.program.setChanged(ProgramEvent.RELOCATION_ADDED, null, reloc);
            Relocation relocation = reloc;
            return relocation;
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasRelocation(Address addr) {
        this.lock.acquire();
        try {
            RecordIterator it = this.adapter.iterator(addr);
            if (!it.hasNext()) {
                boolean bl = false;
                return bl;
            }
            DBRecord r = it.next();
            Address a = this.addrMap.decodeAddress(r.getLongValue(0));
            boolean bl = addr.equals(a);
            return bl;
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Relocation> getRelocations(Address addr) {
        this.lock.acquire();
        try {
            DBRecord rec;
            Address a;
            ArrayList<Relocation> list = null;
            RecordIterator it = this.adapter.iterator(addr);
            while (it.hasNext() && addr.equals(a = this.addrMap.decodeAddress((rec = it.next()).getLongValue(0)))) {
                if (list == null) {
                    list = new ArrayList<Relocation>();
                }
                list.add(this.getRelocation(rec));
            }
            List<Relocation> list2 = list == null ? List.of() : list;
            return list2;
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    private Relocation getRelocation(DBRecord rec) throws IOException {
        Address addr = this.addrMap.decodeAddress(rec.getLongValue(0));
        byte flags = rec.getByteValue(1);
        Relocation.Status status = RelocationDBAdapter.getStatus(flags);
        int length = RelocationDBAdapter.getByteLength(flags);
        BinaryCodedField valuesField = new BinaryCodedField((BinaryField)rec.getFieldValue(3));
        byte[] originalBytes = this.getOriginalBytes(addr, status, rec.getBinaryData(4), length);
        return new Relocation(addr, status, rec.getIntValue(2), valuesField.getLongArray(), originalBytes, rec.getString(5));
    }

    @Override
    public Iterator<Relocation> getRelocations() {
        RecordIterator ri = null;
        this.lock.acquire();
        try {
            ri = this.adapter.iterator();
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return new RelocationIterator(ri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Address getRelocationAddressAfter(Address addr) {
        this.lock.acquire();
        try {
            RecordIterator it = this.adapter.iterator(addr);
            while (it.hasNext()) {
                DBRecord rec = it.next();
                Address a = this.addrMap.decodeAddress(rec.getLongValue(0));
                if (addr.equals(a)) continue;
                Address address = a;
                return address;
            }
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Relocation> getRelocations(AddressSetView set) {
        RecordIterator it = null;
        this.lock.acquire();
        try {
            it = this.adapter.iterator(set);
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return new RelocationIterator(it);
    }

    @Override
    public int getSize() {
        return this.adapter.getRecordCount();
    }

    @Override
    public boolean isRelocatable() {
        if (this.isRelocatable == null) {
            Options propList = this.program.getOptions("Program Information");
            this.isRelocatable = propList.contains("Relocatable") ? Boolean.valueOf(propList.getBoolean("Relocatable", false)) : Boolean.valueOf(this.getSize() > 0);
        }
        return this.isRelocatable;
    }

    @Override
    public void deleteAddressRange(Address startAddr, Address endAddr, TaskMonitor monitor) {
    }

    @Override
    public void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) {
    }

    private class RelocationIterator
    implements Iterator<Relocation> {
        private RecordIterator it;

        RelocationIterator(RecordIterator ri) {
            this.it = ri;
        }

        @Override
        public boolean hasNext() {
            if (this.it == null) {
                return false;
            }
            RelocationManager.this.lock.acquire();
            try {
                boolean bl = this.it.hasNext();
                return bl;
            }
            catch (IOException e) {
                RelocationManager.this.program.dbError(e);
            }
            finally {
                RelocationManager.this.lock.release();
            }
            return false;
        }

        @Override
        public Relocation next() {
            if (this.it == null) {
                return null;
            }
            RelocationManager.this.lock.acquire();
            try {
                DBRecord r = this.it.next();
                Relocation relocation = RelocationManager.this.getRelocation(r);
                return relocation;
            }
            catch (IOException e) {
                RelocationManager.this.program.dbError(e);
            }
            finally {
                RelocationManager.this.lock.release();
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove from relocation table inside iterator!");
        }
    }
}

