/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.store.local;

import ghidra.framework.store.local.ItemPropertyFile;
import ghidra.util.exception.DuplicateFileException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class IndexedPropertyFile
extends ItemPropertyFile {
    protected static final String NAME_PROPERTY = "NAME";
    protected static final String PARENT_PATH_PROPERTY = "PARENT";

    public IndexedPropertyFile(File dir, String storageName, String parentPath, String name) throws IOException {
        super(dir, storageName, parentPath, name);
        if (this.contains(NAME_PROPERTY) && this.contains(PARENT_PATH_PROPERTY)) {
            this.name = this.getString(NAME_PROPERTY, name);
            this.parentPath = this.getString(PARENT_PATH_PROPERTY, parentPath);
        } else {
            this.putString(NAME_PROPERTY, name);
            this.putString(PARENT_PATH_PROPERTY, parentPath);
        }
    }

    public IndexedPropertyFile(File dir, String storageName) throws IOException {
        super(dir, storageName, null, null);
        if (!this.exists()) {
            throw new FileNotFoundException(String.valueOf(new File(dir, storageName + ".prp")) + " not found");
        }
        this.name = this.getString(NAME_PROPERTY, null);
        this.parentPath = this.getString(PARENT_PATH_PROPERTY, null);
        if (this.name == null || this.parentPath == null) {
            throw new IOException("Invalid indexed property file: " + String.valueOf(this.propertyFile));
        }
    }

    public IndexedPropertyFile(File file) throws IOException {
        this(file.getParentFile(), IndexedPropertyFile.getStorageName(file.getName()));
    }

    private static String getStorageName(String propertyFileName) {
        if (!propertyFileName.endsWith(".prp")) {
            throw new IllegalArgumentException("property file name must have .prp file extension");
        }
        return propertyFileName.substring(0, propertyFileName.length() - ".prp".length());
    }

    @Override
    public void moveTo(File newParent, String newStorageName, String newParentPath, String newName) throws DuplicateFileException, IOException {
        String oldName = this.name;
        String oldParentPath = this.parentPath;
        super.moveTo(newParent, newStorageName, newParentPath, newName);
        if (!newParentPath.equals(oldParentPath) || !newName.equals(oldName)) {
            this.putString(NAME_PROPERTY, this.name);
            this.putString(PARENT_PATH_PROPERTY, this.parentPath);
            this.writeState();
        }
    }
}

