/*
 * Decompiled with CFR 0.152.
 */
package ghidra.jython;

import ghidra.jython.JythonPlugin;
import ghidra.jython.JythonPluginExecutionThread;
import ghidra.util.Msg;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.atomic.AtomicBoolean;

class JythonPluginInputThread
extends Thread {
    private static int generationCount = 0;
    private final JythonPlugin plugin;
    private final AtomicBoolean moreInputWanted = new AtomicBoolean(false);
    private final AtomicBoolean shutdownRequested = new AtomicBoolean(false);
    private final InputStream consoleStdin;
    private JythonPluginExecutionThread jythonExecutionThread;

    JythonPluginInputThread(JythonPlugin plugin) {
        super("Jython plugin input thread (generation " + ++generationCount + ")");
        this.plugin = plugin;
        this.consoleStdin = plugin.getConsole().getStdin();
    }

    JythonPluginExecutionThread getJythonPluginExecutionThread() {
        return this.jythonExecutionThread;
    }

    @Override
    public void run() {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.consoleStdin));){
            String line;
            while (!this.shutdownRequested.get() && (line = reader.readLine()) != null) {
                this.jythonExecutionThread = new JythonPluginExecutionThread(this.plugin, line, this.moreInputWanted);
                this.jythonExecutionThread.start();
                try {
                    this.jythonExecutionThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.plugin.getConsole().setPrompt(this.moreInputWanted.get() ? this.plugin.getInterpreter().getSecondaryPrompt() : this.plugin.getInterpreter().getPrimaryPrompt());
            }
        }
        catch (IOException e) {
            Msg.error(JythonPluginInputThread.class, (Object)"Internal error reading commands from interpreter console.  Please reset the interpreter.", (Throwable)e);
        }
    }

    void shutdown() {
        try {
            this.shutdownRequested.set(true);
            this.consoleStdin.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

