/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api;

import generic.lsh.LSHMemoryModel;
import ghidra.feature.vt.api.BSimProgramCorrelator;
import ghidra.feature.vt.api.main.VTProgramCorrelator;
import ghidra.feature.vt.api.main.VTProgramCorrelatorAddressRestrictionPreference;
import ghidra.feature.vt.api.util.VTAbstractProgramCorrelatorFactory;
import ghidra.feature.vt.api.util.VTOptions;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;

public class BSimProgramCorrelatorFactory
extends VTAbstractProgramCorrelatorFactory {
    public static final String NAME = "BSim Function Matching";
    public static final String DESC = "Finds function matches by using data flow and call graph similarities between the source and destination programs.";
    public static final String MEMORY_MODEL = "Memory Model";
    public static final LSHMemoryModel MEMORY_MODEL_DEFAULT = LSHMemoryModel.LARGE;
    public static final String MEMORY_MODEL_DESC = "Amount of memory used to compute matches. Smaller models are slightly less accurate.";
    public static final String SEED_CONF_THRESHOLD = "Confidence Threshold for a Seed";
    public static final double SEED_CONF_THRESHOLD_DEFAULT = 10.0;
    public static final String SEED_CONF_THRESHOLD_DESC = "For threshold N, the probability that a seed is incorrect is approximately 1/2^(N/5+9).";
    public static final String IMPLICATION_THRESHOLD = "Confidence Threshold for a Match";
    public static final double IMPLICATION_THRESHOLD_DEFAULT = 0.0;
    public static final String IMPLICATION_THRESHOLD_DESC = "For threshold N, the probability that a match is incorrect is approximately 1/2^(N/5+9).";
    public static final String USE_ACCEPTED_MATCHES_AS_SEEDS = "Use Accepted Matches as Seeds";
    public static final boolean USE_ACCEPTED_MATCHES_AS_SEEDS_DEFAULT = true;
    public static final String USE_ACCEPTED_MATCHES_AS_SEEDS_DESC = "Already accepted matches will also be used as seeds.";

    public int getPriority() {
        return 50;
    }

    protected VTProgramCorrelator doCreateCorrelator(Program sourceProgram, AddressSetView sourceAddressSet, Program destinationProgram, AddressSetView destinationAddressSet, VTOptions options) {
        return new BSimProgramCorrelator(sourceProgram, sourceAddressSet, destinationProgram, destinationAddressSet, (ToolOptions)options);
    }

    public VTProgramCorrelatorAddressRestrictionPreference getAddressRestrictionPreference() {
        return VTProgramCorrelatorAddressRestrictionPreference.RESTRICTION_NOT_ALLOWED;
    }

    public VTOptions createDefaultOptions() {
        VTOptions options = new VTOptions(NAME);
        HelpLocation help = new HelpLocation("BSimCorrelator", "BSim_Correlator");
        options.setEnum(MEMORY_MODEL, (Enum)MEMORY_MODEL_DEFAULT);
        options.registerOption(MEMORY_MODEL, (Object)MEMORY_MODEL_DEFAULT, help, MEMORY_MODEL_DESC);
        options.setDouble(SEED_CONF_THRESHOLD, 10.0);
        options.registerOption(SEED_CONF_THRESHOLD, (Object)10.0, help, SEED_CONF_THRESHOLD_DESC);
        options.setDouble(IMPLICATION_THRESHOLD, 0.0);
        options.registerOption(IMPLICATION_THRESHOLD, (Object)0.0, help, IMPLICATION_THRESHOLD_DESC);
        options.setBoolean(USE_ACCEPTED_MATCHES_AS_SEEDS, true);
        options.registerOption(USE_ACCEPTED_MATCHES_AS_SEEDS, (Object)true, help, USE_ACCEPTED_MATCHES_AS_SEEDS_DESC);
        options.setOptionsHelpLocation(help);
        return options;
    }

    public String getDescription() {
        return DESC;
    }

    public String getName() {
        return NAME;
    }
}

