/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.MemoryBlockUtils;
import ghidra.app.util.Option;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.AbstractProgramLoader;
import ghidra.app.util.opinion.BoundedBufferedReader;
import ghidra.app.util.opinion.LoadException;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loaded;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.LoaderTier;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.CompilerSpecDescription;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageDescription;
import ghidra.program.model.listing.Program;
import ghidra.util.NumericUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MotorolaHexLoader
extends AbstractProgramLoader {
    public static final String MOTOROLA_HEX_NAME = "Motorola Hex";
    private static final String OPTION_NAME_BASE_ADDRESS = "Base Address";
    private static final String OPTION_NAME_BLOCK_NAME = "Block Name";
    private static final String OPTION_NAME_IS_OVERLAY = "Overlay";
    private static final int BUFSIZE = 65536;

    @Override
    public LoaderTier getTier() {
        return LoaderTier.UNTARGETED_LOADER;
    }

    @Override
    public int getTierPriority() {
        return 50;
    }

    @Override
    public boolean supportsLoadIntoProgram() {
        return true;
    }

    @Override
    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider provider) throws IOException {
        ArrayList<LoadSpec> loadSpecs = new ArrayList<LoadSpec>();
        if (MotorolaHexLoader.isPossibleHexFile(provider)) {
            List languageDescriptions = this.getLanguageService().getLanguageDescriptions(false);
            for (LanguageDescription languageDescription : languageDescriptions) {
                Collection compilerSpecDescriptions = languageDescription.getCompatibleCompilerSpecDescriptions();
                for (CompilerSpecDescription compilerSpecDescription : compilerSpecDescriptions) {
                    LanguageCompilerSpecPair lcs = new LanguageCompilerSpecPair(languageDescription.getLanguageID(), compilerSpecDescription.getCompilerSpecID());
                    loadSpecs.add(new LoadSpec(this, 0L, lcs, false));
                }
            }
        }
        return loadSpecs;
    }

    static boolean isPossibleHexFile(ByteProvider provider) {
        boolean bl;
        BoundedBufferedReader reader = new BoundedBufferedReader(new InputStreamReader(provider.getInputStream(0L)));
        try {
            String line = reader.readLine();
            while (line.matches("^\\s*$")) {
                line = reader.readLine();
            }
            bl = line.matches("^[S:][0-9a-fA-F]+$");
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return false;
            }
        }
        reader.close();
        return bl;
    }

    @Override
    public String validateOptions(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program) {
        Address baseAddr = null;
        for (Option option : options) {
            String optName = option.getName();
            try {
                if (optName.equals(OPTION_NAME_BASE_ADDRESS)) {
                    baseAddr = (Address)option.getValue();
                    if (baseAddr != null) continue;
                    return "Invalid base address";
                }
                if (optName.equals(OPTION_NAME_BLOCK_NAME)) {
                    if (String.class.isAssignableFrom(option.getValueClass())) continue;
                    return "Block Name must be a String";
                }
                if (optName.equals(OPTION_NAME_IS_OVERLAY)) {
                    if (Boolean.class.isAssignableFrom(option.getValueClass())) continue;
                    return "Overlay must be a boolean";
                }
                return "Unknown option: " + optName;
            }
            catch (ClassCastException e) {
                return "Invalid type for option: " + optName + " - " + e.getMessage();
            }
        }
        return null;
    }

    private Address getBaseAddr(List<Option> options) {
        Address baseAddr = null;
        for (Option option : options) {
            String optName = option.getName();
            if (!optName.equals(OPTION_NAME_BASE_ADDRESS)) continue;
            baseAddr = (Address)option.getValue();
        }
        return baseAddr;
    }

    private String getBlockName(List<Option> options) {
        String blockName = "";
        for (Option option : options) {
            String optName = option.getName();
            if (!optName.equals(OPTION_NAME_BLOCK_NAME)) continue;
            blockName = (String)option.getValue();
        }
        return blockName;
    }

    private boolean isOverlay(List<Option> options) {
        boolean isOverlay = false;
        for (Option option : options) {
            String optName = option.getName();
            if (!optName.equals(OPTION_NAME_IS_OVERLAY)) continue;
            isOverlay = (Boolean)option.getValue();
        }
        return isOverlay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<Loaded<Program>> loadProgram(Loader.ImporterSettings settings) throws IOException, LoadException, CancelledException {
        Program prog = this.createProgram(null, settings);
        List<Loaded<Program>> loadedList = List.of(new Loaded<Program>(prog, settings));
        boolean success = false;
        try {
            this.loadInto(prog, settings);
            this.createDefaultMemoryBlocks(prog, settings);
            success = true;
            List<Loaded<Program>> list = loadedList;
            return list;
        }
        finally {
            if (!success) {
                loadedList.forEach(Loaded::close);
            }
        }
    }

    @Override
    protected void loadProgramInto(Program prog, Loader.ImporterSettings settings) throws IOException, LoadException, CancelledException {
        Address baseAddr = this.getBaseAddr(settings.options());
        if (baseAddr == null) {
            baseAddr = prog.getAddressFactory().getDefaultAddressSpace().getAddress(0L);
        }
        try {
            this.processMotorolaHex(settings.provider(), settings.options(), prog, baseAddr, settings.monitor());
        }
        catch (AddressOverflowException e) {
            throw new LoadException("Hex file specifies range greater than allowed address space - " + e.getMessage());
        }
    }

    private void processMotorolaHex(ByteProvider provider, List<Option> options, Program program, Address baseAddr, TaskMonitor monitor) throws IOException, AddressOverflowException, CancelledException {
        block33: {
            String blockName = this.getBlockName(options);
            boolean isOverlay = this.isOverlay(options);
            if (blockName == null || blockName.length() == 0) {
                blockName = this.generateBlockName(program, isOverlay, baseAddr.getAddressSpace());
            }
            long startAddress = 0L;
            long endAddress = 0L;
            int offset = 0;
            int lineNum = 0;
            byte[] dataBuffer = new byte[65536];
            int counter = 0;
            MessageLog log = new MessageLog();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(provider.getInputStream(0L)));){
                String line;
                while ((line = in.readLine()) != null) {
                    monitor.checkCancelled();
                    int index = 0;
                    int checkSum = 0;
                    int addrLen = 0;
                    ++lineNum;
                    line = line.trim();
                    if (line.length() < 10) {
                        String msg = provider.getName() + ", line: " + lineNum + " is too short";
                        continue;
                    }
                    if (line.charAt(index++) != 'S' && line.charAt(index++) != 's') {
                        String msg = "Line #" + (lineNum - 1) + " is not valid\n";
                        continue;
                    }
                    boolean finished = false;
                    boolean skipline = false;
                    char record_type = line.charAt(index++);
                    int temp = this.getByte(line, index);
                    index += 2;
                    checkSum += temp;
                    int numBytes = temp;
                    switch (record_type) {
                        case '7': 
                        case '8': 
                        case '9': {
                            finished = true;
                            break;
                        }
                        case '1': {
                            addrLen = 2;
                            break;
                        }
                        case '2': {
                            addrLen = 3;
                            break;
                        }
                        case '3': {
                            addrLen = 4;
                            break;
                        }
                        case '0': {
                            skipline = true;
                            break;
                        }
                        default: {
                            String msg = "Line #" + (lineNum - 1) + " is not valid\n";
                            skipline = true;
                        }
                    }
                    if (finished) break;
                    if (skipline) continue;
                    try {
                        for (int i = 0; i < addrLen; ++i) {
                            checkSum += this.getByte(line, index + i * 2);
                        }
                    }
                    catch (IndexOutOfBoundsException exc) {
                        String msg = provider.getName() + ", line: " + lineNum + " line length problem";
                        skipline = true;
                    }
                    if (skipline) continue;
                    String addrStr = line.substring(4, 4 + 2 * addrLen);
                    if (++counter % 1000 == 0) {
                        monitor.setMessage("Reading in ... " + addrStr);
                    }
                    long addr = NumericUtilities.parseHexLong((String)addrStr);
                    index += 2 * addrLen;
                    if (lineNum == 1) {
                        startAddress = addr;
                    }
                    if (addr != endAddress || offset + numBytes > 65536) {
                        if (offset != 0) {
                            byte[] data = new byte[offset];
                            System.arraycopy(dataBuffer, 0, data, 0, offset);
                            Address start = baseAddr.add(startAddress);
                            String name = blockName == null ? baseAddr.getAddressSpace().getName() : blockName;
                            MemoryBlockUtils.createInitializedBlock(program, isOverlay, name, start, new ByteArrayInputStream(data), (long)data.length, "", provider.getName(), true, isOverlay, isOverlay, log, monitor);
                        }
                        offset = 0;
                        startAddress = addr;
                        endAddress = addr;
                    }
                    endAddress += (long)(numBytes - addrLen - 1);
                    for (int i = 0; i < numBytes - addrLen - 1; ++i) {
                        String msg;
                        try {
                            temp = this.getByte(line, index);
                            index += 2;
                            checkSum += temp;
                        }
                        catch (NumberFormatException exc) {
                            msg = provider.getName() + ", line: " + lineNum + " number format at byte #" + i;
                            skipline = true;
                        }
                        catch (IndexOutOfBoundsException exc) {
                            msg = provider.getName() + ", line: " + lineNum + " line length problem";
                            skipline = true;
                        }
                        if (skipline) continue;
                        dataBuffer[i + offset] = (byte)temp;
                    }
                    if (skipline) continue;
                    offset += numBytes - addrLen - 1;
                    try {
                        temp = this.getByte(line, index);
                        index += 2;
                    }
                    catch (IndexOutOfBoundsException exc) {
                        String msg = provider.getName() + ", line: " + lineNum + " line length problem";
                        skipline = true;
                    }
                    if (!skipline) continue;
                }
                if (offset == 0) break block33;
                byte[] data = new byte[offset];
                System.arraycopy(dataBuffer, 0, data, 0, offset);
                Object name = baseAddr.getAddressSpace().getName();
                Address start = baseAddr.add(startAddress);
                name = blockName;
                int count = 0;
                while (true) {
                    try {
                        MemoryBlockUtils.createInitializedBlock(program, isOverlay, blockName, start, new ByteArrayInputStream(data), (long)data.length, "", provider.getName(), true, true, true, log, monitor);
                    }
                    catch (RuntimeException e) {
                        Throwable cause = e.getCause();
                        if (!(cause instanceof DuplicateNameException)) {
                            throw e;
                        }
                        name = blockName + "_" + ++count;
                        continue;
                    }
                    break;
                }
            }
        }
    }

    private int getByte(String line, int index) {
        String byteString = line.substring(index, index + 2);
        int value = Integer.parseInt(byteString, 16);
        return value;
    }

    @Override
    public List<Option> getDefaultOptions(ByteProvider provider, LoadSpec loadSpec, DomainObject domainObject, boolean loadIntoProgram, boolean mirrorFsLayout) {
        AddressSpace defaultAddressSpace;
        Program program;
        AddressFactory addressFactory;
        String blockName = "";
        boolean isOverlay = false;
        Address baseAddr = null;
        if (domainObject instanceof Program && (addressFactory = (program = (Program)domainObject).getAddressFactory()) != null && (defaultAddressSpace = addressFactory.getDefaultAddressSpace()) != null) {
            baseAddr = defaultAddressSpace.getAddress(0L);
        }
        ArrayList<Option> list = new ArrayList<Option>();
        if (loadIntoProgram) {
            list.add(new Option(OPTION_NAME_IS_OVERLAY, isOverlay));
            list.add(new Option(OPTION_NAME_BLOCK_NAME, blockName));
        } else {
            isOverlay = false;
        }
        if (baseAddr == null) {
            list.add(new Option(OPTION_NAME_BASE_ADDRESS, Address.class));
        } else {
            list.add(new Option(OPTION_NAME_BASE_ADDRESS, baseAddr));
        }
        return list;
    }

    @Override
    public String getName() {
        return MOTOROLA_HEX_NAME;
    }
}

