/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.dyld;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class DyldCacheMappingInfo
implements StructConverter {
    private long address;
    private long size;
    private long fileOffset;
    private int maxProt;
    private int initProt;

    public DyldCacheMappingInfo(BinaryReader reader) throws IOException {
        this.address = reader.readNextLong();
        this.size = reader.readNextLong();
        this.fileOffset = reader.readNextLong();
        this.maxProt = reader.readNextInt();
        this.initProt = reader.readNextInt();
    }

    public long getAddress() {
        return this.address;
    }

    public long getSize() {
        return this.size;
    }

    public long getFileOffset() {
        return this.fileOffset;
    }

    public boolean isRead() {
        return (this.initProt & 1) != 0;
    }

    public boolean isWrite() {
        return (this.initProt & 2) != 0;
    }

    public boolean isExecute() {
        return (this.initProt & 4) != 0;
    }

    public int getMaxProtection() {
        return this.maxProt;
    }

    public int getInitialProtection() {
        return this.initProt;
    }

    public boolean contains(long addr, boolean isAddr) {
        return isAddr ? Long.compareUnsigned(addr, this.address) >= 0 && Long.compareUnsigned(addr, this.address + this.size) < 0 : Long.compareUnsigned(addr, this.fileOffset) >= 0 && Long.compareUnsigned(addr, this.fileOffset + this.size) < 0;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("dyld_cache_mapping_info", 0);
        struct.add(QWORD, "address", "");
        struct.add(QWORD, "size", "");
        struct.add(QWORD, "fileOffset", "");
        struct.add(DWORD, "maxProt", "");
        struct.add(DWORD, "initProt", "");
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }
}

