/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.table;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.ComponentProviderActivationListener;
import docking.DefaultActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.widgets.table.AbstractSortedTableModel;
import docking.widgets.table.GTable;
import generic.theme.GIcon;
import ghidra.app.nav.Navigatable;
import ghidra.app.nav.NavigatableRemovalListener;
import ghidra.app.plugin.core.table.TableServicePlugin;
import ghidra.app.services.GoToService;
import ghidra.app.services.MarkerDescriptor;
import ghidra.app.services.MarkerService;
import ghidra.app.services.MarkerSet;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.BytesFieldLocation;
import ghidra.program.util.MarkerLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.table.GhidraProgramTableModel;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import ghidra.util.table.GhidraThreadedTablePanel;
import ghidra.util.table.SelectionNavigationAction;
import ghidra.util.table.actions.DeleteTableRowAction;
import ghidra.util.table.actions.MakeProgramSelectionAction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import utility.function.Callback;
import utility.function.Dummy;

public class TableComponentProvider<T>
extends ComponentProviderAdapter
implements TableModelListener,
NavigatableRemovalListener {
    private JPanel componentPanel;
    private GhidraThreadedTablePanel<T> threadedPanel;
    private GhidraTableFilterPanel<T> tableFilterPanel;
    private TableServicePlugin tableServicePlugin;
    private Program program;
    private GhidraProgramTableModel<T> model;
    private MarkerSet markerSet;
    private MarkerService markerService;
    private String programName;
    private String windowSubMenu;
    private List<ComponentProviderActivationListener> activationListenerList = new ArrayList<ComponentProviderActivationListener>();
    private Callback closedCallback = Dummy.callback();
    private DomainObjectListener programListener;
    private Navigatable navigatable;
    private SelectionNavigationAction selectionNavigationAction;
    private DockingAction selectAction;
    private DockingAction removeItemsAction;
    private DockingAction externalGotoAction;
    private Function<MouseEvent, ActionContext> contextProvider = null;
    private HelpLocation helpLoc = new HelpLocation("Search", "Query_Results");

    TableComponentProvider(TableServicePlugin plugin, String title, String name, GhidraProgramTableModel<T> model, Program program, GoToService gotoService, String windowSubMenu, Navigatable navigatable) {
        this(plugin, title, name, model, program, gotoService, null, null, null, windowSubMenu, navigatable);
    }

    TableComponentProvider(TableServicePlugin plugin, String title, String name, GhidraProgramTableModel<T> model, final Program program, GoToService gotoService, MarkerService markerService, Color markerColor, Icon markerIcon, String windowSubMenu, Navigatable navigatable) {
        super(plugin.getTool(), name, plugin.getName());
        this.tableServicePlugin = plugin;
        this.navigatable = navigatable;
        this.program = program;
        this.model = model;
        this.programName = program.getDomainFile().getName();
        this.markerService = markerService;
        this.windowSubMenu = windowSubMenu;
        this.setIcon((Icon)new GIcon("icon.plugin.table.service"));
        this.setTransient();
        this.setTitle(title);
        this.setHelpLocation(this.helpLoc);
        this.componentPanel = this.buildMainPanel(model, gotoService);
        this.addToTool();
        this.setVisible(true);
        this.updateTitle();
        this.createActions(plugin);
        if (markerService != null) {
            this.markerSet = markerService.createPointMarker(name, title, program, 75, true, true, false, markerColor, markerIcon);
            this.markerSet.setMarkerDescriptor(new MarkerDescriptor(this){

                @Override
                public ProgramLocation getProgramLocation(MarkerLocation loc) {
                    return new BytesFieldLocation(program, loc.getAddr());
                }
            });
            markerService.removeMarker(this.markerSet, program);
            this.loadMarkers();
        }
        model.addTableModelListener(this);
    }

    private JPanel buildMainPanel(GhidraProgramTableModel<T> tableModel, GoToService gotoService) {
        JPanel panel = new JPanel(new BorderLayout());
        this.threadedPanel = new GhidraThreadedTablePanel(tableModel);
        GhidraTable table = this.threadedPanel.getTable();
        table.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.tool.contextChanged((ComponentProvider)this);
        });
        if (this.navigatable != null) {
            table.setActionsEnabled(this.navigatable.isConnected());
            this.navigatable.addNavigatableListener(this);
            table.installNavigation((ServiceProvider)this.tool, this.navigatable);
        } else {
            table.setActionsEnabled(true);
            table.installNavigation((ServiceProvider)this.tool);
        }
        panel.add((Component)((Object)this.threadedPanel), "Center");
        panel.add((Component)this.createFilterFieldPanel((JTable)((Object)table), (AbstractSortedTableModel<T>)tableModel), "South");
        return panel;
    }

    private void createActions(Plugin plugin) {
        final GhidraTable table = this.threadedPanel.getTable();
        table.setAccessibleNamePrefix(this.getName());
        table.getAccessibleContext().setAccessibleDescription("Provider title: " + this.getTitle());
        this.selectAction = this.navigatable != null ? new MakeProgramSelectionAction(this.navigatable, this.tableServicePlugin.getName(), table) : new MakeProgramSelectionAction(this.tableServicePlugin, table);
        this.selectAction.setHelpLocation(new HelpLocation("Search", "Make_Selection"));
        this.selectionNavigationAction = new SelectionNavigationAction(plugin, table);
        this.selectionNavigationAction.setHelpLocation(new HelpLocation("Search", "Selection_Navigation"));
        this.externalGotoAction = new DockingAction("Go to External Location", this.getOwner()){

            public void actionPerformed(ActionContext context) {
                TableComponentProvider.this.gotoExternalAddress(this.getSelectedExternalAddress());
            }

            public boolean isEnabledForContext(ActionContext context) {
                return this.getSelectedExternalAddress() != null && TableComponentProvider.this.tool.getService(GoToService.class) != null;
            }

            private Address getSelectedExternalAddress() {
                if (table.getSelectedRowCount() != 1) {
                    return null;
                }
                ProgramSelection selection = table.getProgramSelection();
                Program modelProgram = TableComponentProvider.this.model.getProgram();
                if (modelProgram == null || selection.getNumAddresses() != 1L) {
                    return null;
                }
                Address addr = selection.getMinAddress();
                return addr.isExternalAddress() ? addr : null;
            }
        };
        this.externalGotoAction.setDescription("Go to an external location");
        this.externalGotoAction.setEnabled(false);
        GIcon icon = new GIcon("icon.plugin.table.service.marker");
        this.externalGotoAction.setPopupMenuData(new MenuData(new String[]{"GoTo External Location"}, (Icon)icon, null));
        this.externalGotoAction.setHelpLocation(new HelpLocation("Search", "Navigation"));
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.selectAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.selectionNavigationAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.externalGotoAction);
    }

    public void removeAllActions() {
        this.tool.removeLocalAction((ComponentProvider)this, (DockingActionIf)this.externalGotoAction);
        this.tool.removeLocalAction((ComponentProvider)this, (DockingActionIf)this.selectAction);
        this.tool.removeLocalAction((ComponentProvider)this, (DockingActionIf)this.selectionNavigationAction);
        if (this.removeItemsAction != null) {
            this.tool.removeAction((DockingActionIf)this.removeItemsAction);
            this.removeItemsAction = null;
        }
    }

    public void installRemoveItemsAction() {
        if (this.removeItemsAction != null) {
            return;
        }
        GhidraTable table = this.threadedPanel.getTable();
        this.removeItemsAction = new DeleteTableRowAction(table, this.tableServicePlugin.getName());
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.removeItemsAction);
    }

    public String getActionOwner() {
        return this.tableServicePlugin.getName();
    }

    private JPanel createFilterFieldPanel(JTable table, AbstractSortedTableModel<T> sortedModel) {
        this.tableFilterPanel = new GhidraTableFilterPanel<T>(table, sortedModel);
        this.tableFilterPanel.setToolTipText("Filter search results");
        return this.tableFilterPanel;
    }

    private String generateSubTitle() {
        int n;
        StringBuilder buffer = new StringBuilder();
        buffer.append("(");
        buffer.append(this.programName);
        buffer.append(") ");
        Object filteredText = "";
        if (this.tableFilterPanel.isFiltered()) {
            filteredText = " of " + this.tableFilterPanel.getUnfilteredRowCount();
        }
        if ((n = this.model.getRowCount()) == 1) {
            buffer.append("    (1 entry").append((String)filteredText).append(")");
        } else if (n > 1) {
            buffer.append("    (").append(n).append(" entries").append((String)filteredText).append(")");
        }
        return buffer.toString();
    }

    private void reloadMarkers() {
        if (this.markerSet == null) {
            return;
        }
        if (!this.markerService.isActiveMarkerForGroup("HIGHLIGHT_GROUP", this.markerSet, this.program)) {
            return;
        }
        this.markerService.removeMarkerForGroup("HIGHLIGHT_GROUP", this.markerSet, this.program);
        this.loadMarkers();
    }

    private void loadMarkers() {
        if (this.markerSet == null) {
            return;
        }
        if (this.markerService.isActiveMarkerForGroup("HIGHLIGHT_GROUP", this.markerSet, this.program)) {
            return;
        }
        this.markerSet.clearAll();
        int n = this.model.getRowCount();
        for (int i = 0; i < n; ++i) {
            Address a = this.model.getAddress(i);
            if (a == null) continue;
            this.markerSet.add(a);
        }
        this.markerService.setMarkerForGroup("HIGHLIGHT_GROUP", this.markerSet, this.program);
    }

    private void gotoExternalAddress(Address extAddr) {
        GoToService gotoSvc = (GoToService)this.tool.getService(GoToService.class);
        if (gotoSvc != null) {
            gotoSvc.goTo(extAddr, this.model.getProgram());
        }
    }

    public void closeComponent() {
        this.closedCallback.call();
        if (this.navigatable != null) {
            this.navigatable.removeNavigatableListener(this);
        }
        super.closeComponent();
        this.tableServicePlugin.remove(this);
        if (this.markerSet != null) {
            this.markerSet.clearAll();
            this.markerService.removeMarker(this.markerSet, this.program);
        }
        this.tableFilterPanel.dispose();
    }

    public GhidraThreadedTablePanel<T> getThreadedTablePanel() {
        return this.threadedPanel;
    }

    public JComponent getComponent() {
        return this.componentPanel;
    }

    public void refresh() {
        GhidraTable threadedTable = this.threadedPanel.getTable();
        int rowCount = threadedTable.getRowCount();
        if (rowCount == 0) {
            return;
        }
        boolean wasEnabled = this.selectionNavigationAction.isEnabled();
        this.selectionNavigationAction.setEnabled(false);
        int[] selectedRows = threadedTable.getSelectedRows();
        this.model.refresh();
        this.restoreSelection(threadedTable, selectedRows);
        this.selectionNavigationAction.setEnabled(wasEnabled);
    }

    private void restoreSelection(GTable threadedTable, int[] selectedRows) {
        if (selectedRows.length == 0) {
            return;
        }
        int start = selectedRows[0];
        int end = selectedRows[0];
        for (int row : selectedRows) {
            if (row > end + 1) {
                threadedTable.addRowSelectionInterval(start, end);
                start = row;
            }
            end = row;
        }
        threadedTable.addRowSelectionInterval(start, end);
    }

    @Override
    public void tableChanged(TableModelEvent ev) {
        this.updateTitle();
        this.reloadMarkers();
    }

    public GhidraProgramTableModel<T> getModel() {
        return this.model;
    }

    public GhidraTable getTable() {
        return this.threadedPanel.getTable();
    }

    private void updateTitle() {
        this.setSubTitle(this.generateSubTitle());
    }

    public void addActivationListener(ComponentProviderActivationListener listener) {
        this.activationListenerList.add(listener);
    }

    public void removeActivationListener(ComponentProviderActivationListener listener) {
        this.activationListenerList.remove(listener);
    }

    public void componentActivated() {
        this.loadMarkers();
        for (ComponentProviderActivationListener listener : this.activationListenerList) {
            listener.componentProviderActivated((ComponentProvider)this);
        }
    }

    public void componentDeactived() {
        for (ComponentProviderActivationListener listener : this.activationListenerList) {
            listener.componentProviderDeactivated((ComponentProvider)this);
        }
    }

    public void componentHidden() {
        if (this.programListener != null) {
            this.program.removeListener(this.programListener);
        }
    }

    public String getWindowSubMenuName() {
        return this.windowSubMenu;
    }

    @Override
    public void navigatableRemoved(Navigatable removedNavigatable) {
        removedNavigatable.removeNavigatableListener(this);
        this.closeComponent();
    }

    public ActionContext getActionContext(MouseEvent event) {
        if (this.contextProvider != null) {
            return this.contextProvider.apply(event);
        }
        return new DefaultActionContext((ComponentProvider)this, (Component)((Object)this.threadedPanel.getTable()));
    }

    public void setActionContextProvider(Function<MouseEvent, ActionContext> contextProvider) {
        this.contextProvider = contextProvider;
    }

    public void setClosedCallback(Callback c) {
        this.closedCallback = Dummy.ifNull((Callback)c);
    }

    public void setProgramListener(DomainObjectListener programListener) {
        if (this.programListener != null) {
            this.program.removeListener(programListener);
        }
        this.programListener = programListener;
        if (programListener != null) {
            this.program.addListener(programListener);
        }
    }
}

