/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.reachability;

import ghidra.program.model.address.Address;
import ghidra.program.model.block.CodeBlockReference;
import ghidra.util.SystemUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.Factory;
import org.apache.commons.collections4.map.LazyMap;

class FRVertex {
    private Factory<List<CodeBlockReference>> factory = new Factory<List<CodeBlockReference>>(this){

        public List<CodeBlockReference> create() {
            return new ArrayList<CodeBlockReference>();
        }
    };
    private Map<FRVertex, List<CodeBlockReference>> incomingReferences = LazyMap.lazyMap(new HashMap(), this.factory);
    private Address address;

    FRVertex(Address address) {
        this.address = address;
    }

    void addReference(FRVertex referent, CodeBlockReference reference) {
        List<CodeBlockReference> refs = this.incomingReferences.get(referent);
        refs.add(reference);
    }

    CodeBlockReference getReference(FRVertex referent) {
        List<CodeBlockReference> refs = this.incomingReferences.get(referent);
        for (CodeBlockReference ref : refs) {
            Address destination = ref.getDestinationAddress();
            if (!this.address.equals((Object)destination)) continue;
            return ref;
        }
        return null;
    }

    public String toString() {
        return this.address.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FRVertex other = (FRVertex)obj;
        return SystemUtilities.isEqual((Object)this.address, (Object)other.address);
    }

    Address getAddress() {
        return this.address;
    }
}

