/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.osgi;

import generic.jar.ResourceFile;
import ghidra.app.plugin.core.osgi.GhidraBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.stream.Collectors;

public class BundleMap {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();
    private final Map<ResourceFile, GhidraBundle> bundlesByFile = new HashMap<ResourceFile, GhidraBundle>();
    private final Map<String, GhidraBundle> bundlesByLocation = new HashMap<String, GhidraBundle>();

    public void add(GhidraBundle bundle) {
        this.writeLock.lock();
        try {
            this.bundlesByFile.put(bundle.getFile(), bundle);
            this.bundlesByLocation.put(bundle.getLocationIdentifier(), bundle);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Collection<GhidraBundle> bundles) {
        this.writeLock.lock();
        try {
            for (GhidraBundle bundle : bundles) {
                this.bundlesByFile.put(bundle.getFile(), bundle);
                this.bundlesByLocation.put(bundle.getLocationIdentifier(), bundle);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void remove(GhidraBundle bundle) {
        this.writeLock.lock();
        try {
            this.bundlesByFile.remove(bundle.getFile());
            this.bundlesByLocation.remove(bundle.getLocationIdentifier());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(Collection<GhidraBundle> bundles) {
        this.writeLock.lock();
        try {
            for (GhidraBundle bundle : bundles) {
                this.bundlesByFile.remove(bundle.getFile());
                this.bundlesByLocation.remove(bundle.getLocationIdentifier());
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GhidraBundle remove(String bundleLocation) {
        this.writeLock.lock();
        try {
            GhidraBundle bundle = this.bundlesByLocation.remove(bundleLocation);
            this.bundlesByFile.remove(bundle.getFile());
            GhidraBundle ghidraBundle = bundle;
            return ghidraBundle;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GhidraBundle remove(ResourceFile bundleFile) {
        this.writeLock.lock();
        try {
            GhidraBundle bundle = this.bundlesByFile.remove(bundleFile);
            this.bundlesByLocation.remove(bundle.getLocationIdentifier());
            GhidraBundle ghidraBundle = bundle;
            return ghidraBundle;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<GhidraBundle> computeAllIfAbsent(Collection<ResourceFile> bundleFiles, Function<ResourceFile, GhidraBundle> ctor) {
        this.writeLock.lock();
        try {
            HashSet<ResourceFile> newBundleFiles = new HashSet<ResourceFile>(bundleFiles);
            newBundleFiles.removeAll(this.bundlesByFile.keySet());
            List<GhidraBundle> newBundles = newBundleFiles.stream().map(ctor).collect(Collectors.toList());
            this.addAll(newBundles);
            List<GhidraBundle> list = newBundles;
            return list;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public GhidraBundle getBundleAtLocation(String location) {
        this.readLock.lock();
        try {
            GhidraBundle ghidraBundle = this.bundlesByLocation.get(location);
            return ghidraBundle;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public GhidraBundle get(ResourceFile bundleFile) {
        this.readLock.lock();
        try {
            GhidraBundle ghidraBundle = this.bundlesByFile.get(bundleFile);
            return ghidraBundle;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Collection<GhidraBundle> getGhidraBundles() {
        this.readLock.lock();
        try {
            ArrayList<GhidraBundle> arrayList = new ArrayList<GhidraBundle>(this.bundlesByFile.values());
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Collection<ResourceFile> getBundleFiles() {
        this.readLock.lock();
        try {
            ArrayList<ResourceFile> arrayList = new ArrayList<ResourceFile>(this.bundlesByFile.keySet());
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

