/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.archive;

import ghidra.app.plugin.core.archive.ArchivePlugin;
import ghidra.formats.gfilesystem.AbstractFileExtractorTask;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.framework.main.FrontEndTool;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.model.ProjectManager;
import ghidra.util.Msg;
import ghidra.util.NotOwnerException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FilenameUtils;

class RestoreTask
extends AbstractFileExtractorTask {
    private static final Set<String> FILES_TO_SKIP = Set.of("/" + "JAR_FORMAT".toLowerCase(), "/" + "project.prp".toLowerCase(), "/" + "projectState".toLowerCase(), "/" + "save".toLowerCase(), "/" + "groups".toLowerCase());
    private File projectArchiveFile;
    private ProjectLocator projectLocator;
    private ArchivePlugin plugin;
    private File projectFile;
    private File projectDir;

    RestoreTask(ProjectLocator projectLocator, File projectArchiveFile, ArchivePlugin plugin) {
        super("Restoring Project: " + projectLocator.getName(), true, false, true, projectLocator.getProjectDir());
        this.projectLocator = projectLocator;
        this.projectArchiveFile = projectArchiveFile;
        this.plugin = plugin;
        this.projectFile = projectLocator.getMarkerFile();
        this.projectDir = projectLocator.getProjectDir();
    }

    public void run(TaskMonitor monitor) throws CancelledException {
        FileSystemService fsService = FileSystemService.getInstance();
        String locInfo = "\"" + this.projectLocator.toString() + "\" from \"" + this.projectArchiveFile.getAbsolutePath() + "\"";
        if (this.projectFile.exists() || this.projectDir.exists()) {
            Msg.showError((Object)((Object)this), null, (String)"Restore Archive Error", (Object)("Project already exists at: " + String.valueOf(this.projectDir)));
            return;
        }
        FSRL archiveFSRL = fsService.getLocalFSRL(this.projectArchiveFile);
        try (GFileSystem fs = fsService.openFileSystemContainer(archiveFSRL, monitor);){
            this.verifyArchive(fs, monitor);
            this.startExtract(fs, null, monitor);
            this.createProjectMarkerFile();
            this.openRestoredProject();
            Msg.info((Object)((Object)this), (Object)("Restore Archive: " + locInfo + " succeeded."));
        }
        catch (CancelledException ce) {
            this.plugin.cleanupRestoredProject(this.projectLocator);
            Msg.info((Object)((Object)this), (Object)("Restore Archive: " + locInfo + " was cancelled by user."));
        }
        catch (Throwable e) {
            this.plugin.cleanupRestoredProject(this.projectLocator);
            String eMsg = e.getMessage() != null ? ":\n\n" + e.getMessage() : "";
            Msg.showError((Object)((Object)this), null, (String)"Restore Archive Failed", (Object)("An error occurred when restoring the project archive\n " + String.valueOf(this.projectArchiveFile) + " to \n " + String.valueOf(this.projectDir) + eMsg), (Throwable)e);
            Msg.info((Object)((Object)this), (Object)("Restore Archive: " + locInfo + " failed."));
        }
    }

    private void createProjectMarkerFile() throws IOException {
        if (!this.projectFile.createNewFile()) {
            throw new IOException("Couldn't create file " + this.projectFile.getAbsolutePath());
        }
    }

    private void verifyArchive(GFileSystem fs, TaskMonitor monitor) throws IOException {
        if (!fs.getFSRL().getProtocol().equals("zip")) {
            throw new IOException("Not a zip file: " + String.valueOf(fs.getFSRL()));
        }
        GFile magicFile = fs.lookup("/JAR_FORMAT");
        if (magicFile == null) {
            throw new IOException("Missing Ghidra Project Archive (.gar) marker file");
        }
    }

    @Override
    protected void processFile(GFile file, File destFSFile, TaskMonitor monitor) throws IOException, CancelledException {
        if (!this.shouldSkip(file)) {
            super.processFile(file, destFSFile, monitor);
        }
    }

    @Override
    protected void processDirectory(GFile srcGFileDirectory, File destDirectory, TaskMonitor monitor) throws IOException, CancelledException {
        if (!this.shouldSkip(srcGFileDirectory)) {
            super.processDirectory(srcGFileDirectory, destDirectory, monitor);
        }
    }

    @Override
    protected String mapSourceFilenameToDest(GFile srcFile) throws IOException {
        String filename = srcFile.getName();
        if (!FSUtilities.getSafeFilename(filename).equals(filename)) {
            throw new IOException("Bad filename in archive: \"" + filename + "\"");
        }
        return filename;
    }

    private boolean shouldSkip(GFile file) {
        String path = file.getPath().toLowerCase();
        if (FILES_TO_SKIP.contains(path)) {
            return true;
        }
        if (".properties".equalsIgnoreCase(file.getName())) {
            return true;
        }
        String ext = "." + FilenameUtils.getExtension((String)file.getName());
        return ".gpr".equalsIgnoreCase(ext);
    }

    private void openRestoredProject() {
        try {
            SwingUtilities.invokeAndWait(() -> {
                ProjectManager pm = this.plugin.getTool().getProjectManager();
                try {
                    Project project = pm.openProject(this.projectLocator, true, true);
                    pm.rememberProject(this.projectLocator);
                    FrontEndTool tool = (FrontEndTool)this.plugin.getTool();
                    tool.setActiveProject(project);
                }
                catch (NotOwnerException project) {
                }
                catch (Exception e) {
                    Msg.info((Object)((Object)this), (Object)("Restore Archive: Error opening project: " + this.projectLocator.getName()));
                    Msg.showError((Object)((Object)this), null, (String)"Restore Archive Error", (Object)"Failed to open newly restored project", (Throwable)e);
                }
            });
        }
        catch (InterruptedException | InvocationTargetException exception) {
            // empty catch block
        }
    }
}

