/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { BaseToolInvocation, type ToolResult, type ToolCallConfirmationDetails } from '../tools/tools.js';
import type { AgentInputs, RemoteAgentDefinition } from './types.js';
import type { MessageBus } from '../confirmation-bus/message-bus.js';
/**
 * A tool invocation that proxies to a remote A2A agent.
 *
 * This implementation bypasses the local `LocalAgentExecutor` loop and directly
 * invokes the configured A2A tool.
 */
export declare class RemoteAgentInvocation extends BaseToolInvocation<AgentInputs, ToolResult> {
    private readonly definition;
    constructor(definition: RemoteAgentDefinition, params: AgentInputs, messageBus?: MessageBus);
    getDescription(): string;
    protected getConfirmationDetails(_abortSignal: AbortSignal): Promise<ToolCallConfirmationDetails | false>;
    execute(_signal: AbortSignal): Promise<ToolResult>;
}
