/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.codec;

import com.singlestore.jdbc.client.context.Context;
import com.singlestore.jdbc.client.socket.PacketWriter;
import com.singlestore.jdbc.codec.Codec;
import com.singlestore.jdbc.codec.DataType;
import java.io.IOException;
import java.sql.SQLException;

public class Parameter<T> {
    public static final Parameter<?> NULL_PARAMETER = new Parameter(null, (Object)null){

        @Override
        public int getBinaryEncodeType() {
            return DataType.VARCHAR.get();
        }

        @Override
        public boolean isNull() {
            return true;
        }
    };
    protected final Codec<T> codec;
    protected final T value;
    protected final Long length;

    public Parameter(Codec<T> codec, T value) {
        this.codec = codec;
        this.value = value;
        this.length = null;
    }

    public Parameter(Codec<T> codec, T value, Long length) {
        this.codec = codec;
        this.value = value;
        this.length = length;
    }

    public void encodeText(PacketWriter encoder, Context context) throws IOException, SQLException {
        this.codec.encodeText(encoder, context, this.value, null, this.length);
    }

    public void encodeBinary(PacketWriter encoder) throws IOException, SQLException {
        this.codec.encodeBinary(encoder, this.value, null, this.length);
    }

    public void encodeLongData(PacketWriter encoder) throws IOException, SQLException {
        this.codec.encodeLongData(encoder, this.value, this.length);
    }

    public byte[] encodeData() throws IOException, SQLException {
        return this.codec.encodeData(this.value, this.length);
    }

    public boolean canEncodeLongData() {
        return this.codec.canEncodeLongData();
    }

    public int getBinaryEncodeType() {
        return this.codec.getBinaryEncodeType();
    }

    public boolean isNull() {
        return this.value == null;
    }
}

