/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.InstanceAdminClient;
import com.google.cloud.spanner.InstanceConfigId;
import com.google.cloud.spanner.InstanceConfigInfo;
import com.google.cloud.spanner.ReplicaInfo;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class InstanceConfig
extends InstanceConfigInfo {
    private final InstanceAdminClient client;

    public static Builder newBuilder(InstanceConfig instanceConfig) {
        return new Builder(instanceConfig);
    }

    public static Builder newBuilder(InstanceAdminClient client, InstanceConfigId instanceConfigId) {
        return new Builder(client, instanceConfigId);
    }

    @Deprecated
    public InstanceConfig(InstanceConfigId id, String displayName, InstanceAdminClient client) {
        this(id, displayName, Collections.emptyList(), Collections.emptyList(), client);
    }

    @Deprecated
    public InstanceConfig(InstanceConfigId id, String displayName, List<ReplicaInfo> replicas, List<String> leaderOptions, InstanceAdminClient client) {
        super(id, displayName, replicas, leaderOptions);
        this.client = client;
    }

    InstanceConfig(Builder builder) {
        super(builder);
        this.client = builder.client;
    }

    public InstanceConfig reload() {
        return this.client.getInstanceConfig(this.getId().getInstanceConfig());
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends InstanceConfigInfo.BuilderImpl {
        private final InstanceAdminClient client;

        Builder(InstanceConfig instanceConfig) {
            super(instanceConfig);
            this.client = instanceConfig.client;
        }

        Builder(InstanceAdminClient client, InstanceConfigId id) {
            super(id);
            this.client = client;
        }

        @Override
        public Builder setDisplayName(String displayName) {
            super.setDisplayName(displayName);
            return this;
        }

        @Override
        protected Builder setReplicas(List<ReplicaInfo> replicas) {
            super.setReplicas(replicas);
            return this;
        }

        @Override
        public Builder setLeaderOptions(List<String> leaderOptions) {
            super.setLeaderOptions(leaderOptions);
            return this;
        }

        @Override
        protected Builder setOptionalReplicas(List<ReplicaInfo> optionalReplicas) {
            super.setOptionalReplicas(optionalReplicas);
            return this;
        }

        @Override
        protected Builder setBaseConfig(InstanceConfigInfo baseConfig) {
            super.setBaseConfig(baseConfig);
            return this;
        }

        @Override
        protected Builder setConfigType(InstanceConfigInfo.Type configType) {
            super.setConfigType(configType);
            return this;
        }

        @Override
        protected Builder setState(InstanceConfigInfo.State state) {
            super.setState(state);
            return this;
        }

        @Override
        public Builder setEtag(String etag) {
            super.setEtag(etag);
            return this;
        }

        @Override
        protected Builder setReconciling(boolean reconciling) {
            super.setReconciling(reconciling);
            return this;
        }

        @Override
        public Builder addLabel(String key, String value) {
            super.addLabel(key, value);
            return this;
        }

        @Override
        public Builder putAllLabels(Map<String, String> labels) {
            super.putAllLabels(labels);
            return this;
        }

        @Override
        public Builder addReadOnlyReplicas(List<ReplicaInfo> readOnlyReplicas) {
            super.addReadOnlyReplicas(readOnlyReplicas);
            return this;
        }

        @Override
        public InstanceConfig build() {
            return new InstanceConfig(this);
        }
    }
}

