// Copyright 2021 The Emscripten Authors.  All rights reserved.
// Emscripten is available under two separate licenses, the MIT license and the
// University of Illinois/NCSA Open Source License.  Both these licenses can be
// found in the LICENSE file.

// Based on a snapshot of Emdawnwebgpu's upstream autogenerated link test.
// Though it's a snapshot, everything it tests should be stable. It should be
// occasionally updated to include new entry points after they're added.

#include <cstdio>
#include <webgpu/webgpu.h>

// Also make sure the C++ header compiles, even though we don't use it.
#include <webgpu/webgpu_cpp.h>

int main() {
  printf("%p\n", wgpuAdapterInfoFreeMembers);
  printf("%p\n", wgpuCreateInstance);
  printf("%p\n", wgpuGetInstanceFeatures);
  printf("%p\n", wgpuGetInstanceLimits);
  printf("%p\n", wgpuGetProcAddress);
  printf("%p\n", wgpuHasInstanceFeature);
  printf("%p\n", wgpuSupportedWGSLLanguageFeaturesFreeMembers);
  printf("%p\n", wgpuSupportedFeaturesFreeMembers);
  printf("%p\n", wgpuSurfaceCapabilitiesFreeMembers);

  printf("%p\n", wgpuAdapterGetFeatures);
  printf("%p\n", wgpuAdapterGetInfo);
  printf("%p\n", wgpuAdapterGetLimits);
  printf("%p\n", wgpuAdapterHasFeature);
  printf("%p\n", wgpuAdapterRequestDevice);
  printf("%p\n", wgpuAdapterAddRef);
  printf("%p\n", wgpuAdapterRelease);

  printf("%p\n", wgpuBindGroupSetLabel);
  printf("%p\n", wgpuBindGroupAddRef);
  printf("%p\n", wgpuBindGroupRelease);

  printf("%p\n", wgpuBindGroupLayoutSetLabel);
  printf("%p\n", wgpuBindGroupLayoutAddRef);
  printf("%p\n", wgpuBindGroupLayoutRelease);

  printf("%p\n", wgpuBufferDestroy);
  printf("%p\n", wgpuBufferGetConstMappedRange);
  printf("%p\n", wgpuBufferGetMapState);
  printf("%p\n", wgpuBufferGetMappedRange);
  printf("%p\n", wgpuBufferGetSize);
  printf("%p\n", wgpuBufferGetUsage);
  printf("%p\n", wgpuBufferMapAsync);
  printf("%p\n", wgpuBufferReadMappedRange);
  printf("%p\n", wgpuBufferSetLabel);
  printf("%p\n", wgpuBufferUnmap);
  printf("%p\n", wgpuBufferWriteMappedRange);
  printf("%p\n", wgpuBufferAddRef);
  printf("%p\n", wgpuBufferRelease);

  printf("%p\n", wgpuCommandBufferSetLabel);
  printf("%p\n", wgpuCommandBufferAddRef);
  printf("%p\n", wgpuCommandBufferRelease);

  printf("%p\n", wgpuCommandEncoderBeginComputePass);
  printf("%p\n", wgpuCommandEncoderBeginRenderPass);
  printf("%p\n", wgpuCommandEncoderClearBuffer);
  printf("%p\n", wgpuCommandEncoderCopyBufferToBuffer);
  printf("%p\n", wgpuCommandEncoderCopyBufferToTexture);
  printf("%p\n", wgpuCommandEncoderCopyTextureToBuffer);
  printf("%p\n", wgpuCommandEncoderCopyTextureToTexture);
  printf("%p\n", wgpuCommandEncoderFinish);
  printf("%p\n", wgpuCommandEncoderInsertDebugMarker);
  printf("%p\n", wgpuCommandEncoderPopDebugGroup);
  printf("%p\n", wgpuCommandEncoderPushDebugGroup);
  printf("%p\n", wgpuCommandEncoderResolveQuerySet);
  printf("%p\n", wgpuCommandEncoderSetLabel);
  printf("%p\n", wgpuCommandEncoderWriteTimestamp);
  printf("%p\n", wgpuCommandEncoderAddRef);
  printf("%p\n", wgpuCommandEncoderRelease);

  printf("%p\n", wgpuComputePassEncoderDispatchWorkgroups);
  printf("%p\n", wgpuComputePassEncoderDispatchWorkgroupsIndirect);
  printf("%p\n", wgpuComputePassEncoderEnd);
  printf("%p\n", wgpuComputePassEncoderInsertDebugMarker);
  printf("%p\n", wgpuComputePassEncoderPopDebugGroup);
  printf("%p\n", wgpuComputePassEncoderPushDebugGroup);
  printf("%p\n", wgpuComputePassEncoderSetBindGroup);
  printf("%p\n", wgpuComputePassEncoderSetLabel);
  printf("%p\n", wgpuComputePassEncoderSetPipeline);
  printf("%p\n", wgpuComputePassEncoderWriteTimestamp);
  printf("%p\n", wgpuComputePassEncoderAddRef);
  printf("%p\n", wgpuComputePassEncoderRelease);

  printf("%p\n", wgpuComputePipelineGetBindGroupLayout);
  printf("%p\n", wgpuComputePipelineSetLabel);
  printf("%p\n", wgpuComputePipelineAddRef);
  printf("%p\n", wgpuComputePipelineRelease);

  printf("%p\n", wgpuDeviceCreateBindGroup);
  printf("%p\n", wgpuDeviceCreateBindGroupLayout);
  printf("%p\n", wgpuDeviceCreateBuffer);
  printf("%p\n", wgpuDeviceCreateCommandEncoder);
  printf("%p\n", wgpuDeviceCreateComputePipeline);
  printf("%p\n", wgpuDeviceCreateComputePipelineAsync);
  printf("%p\n", wgpuDeviceCreatePipelineLayout);
  printf("%p\n", wgpuDeviceCreateQuerySet);
  printf("%p\n", wgpuDeviceCreateRenderBundleEncoder);
  printf("%p\n", wgpuDeviceCreateRenderPipeline);
  printf("%p\n", wgpuDeviceCreateRenderPipelineAsync);
  printf("%p\n", wgpuDeviceCreateSampler);
  printf("%p\n", wgpuDeviceCreateShaderModule);
  printf("%p\n", wgpuDeviceCreateTexture);
  printf("%p\n", wgpuDeviceDestroy);
  printf("%p\n", wgpuDeviceGetAdapterInfo);
  printf("%p\n", wgpuDeviceGetFeatures);
  printf("%p\n", wgpuDeviceGetLimits);
  printf("%p\n", wgpuDeviceGetLostFuture);
  printf("%p\n", wgpuDeviceGetQueue);
  printf("%p\n", wgpuDeviceHasFeature);
  printf("%p\n", wgpuDevicePopErrorScope);
  printf("%p\n", wgpuDevicePushErrorScope);
  printf("%p\n", wgpuDeviceSetLabel);
  printf("%p\n", wgpuDeviceAddRef);
  printf("%p\n", wgpuDeviceRelease);

  printf("%p\n", wgpuInstanceCreateSurface);
  printf("%p\n", wgpuInstanceGetWGSLLanguageFeatures);
  printf("%p\n", wgpuInstanceHasWGSLLanguageFeature);
  printf("%p\n", wgpuInstanceProcessEvents);
  printf("%p\n", wgpuInstanceRequestAdapter);
  printf("%p\n", wgpuInstanceWaitAny);
  printf("%p\n", wgpuInstanceAddRef);
  printf("%p\n", wgpuInstanceRelease);

  printf("%p\n", wgpuPipelineLayoutSetLabel);
  printf("%p\n", wgpuPipelineLayoutAddRef);
  printf("%p\n", wgpuPipelineLayoutRelease);

  printf("%p\n", wgpuQuerySetDestroy);
  printf("%p\n", wgpuQuerySetGetCount);
  printf("%p\n", wgpuQuerySetGetType);
  printf("%p\n", wgpuQuerySetSetLabel);
  printf("%p\n", wgpuQuerySetAddRef);
  printf("%p\n", wgpuQuerySetRelease);

  printf("%p\n", wgpuQueueOnSubmittedWorkDone);
  printf("%p\n", wgpuQueueSetLabel);
  printf("%p\n", wgpuQueueSubmit);
  printf("%p\n", wgpuQueueWriteBuffer);
  printf("%p\n", wgpuQueueWriteTexture);
  printf("%p\n", wgpuQueueAddRef);
  printf("%p\n", wgpuQueueRelease);

  printf("%p\n", wgpuRenderBundleSetLabel);
  printf("%p\n", wgpuRenderBundleAddRef);
  printf("%p\n", wgpuRenderBundleRelease);

  printf("%p\n", wgpuRenderBundleEncoderDraw);
  printf("%p\n", wgpuRenderBundleEncoderDrawIndexed);
  printf("%p\n", wgpuRenderBundleEncoderDrawIndexedIndirect);
  printf("%p\n", wgpuRenderBundleEncoderDrawIndirect);
  printf("%p\n", wgpuRenderBundleEncoderFinish);
  printf("%p\n", wgpuRenderBundleEncoderInsertDebugMarker);
  printf("%p\n", wgpuRenderBundleEncoderPopDebugGroup);
  printf("%p\n", wgpuRenderBundleEncoderPushDebugGroup);
  printf("%p\n", wgpuRenderBundleEncoderSetBindGroup);
  printf("%p\n", wgpuRenderBundleEncoderSetIndexBuffer);
  printf("%p\n", wgpuRenderBundleEncoderSetLabel);
  printf("%p\n", wgpuRenderBundleEncoderSetPipeline);
  printf("%p\n", wgpuRenderBundleEncoderSetVertexBuffer);
  printf("%p\n", wgpuRenderBundleEncoderAddRef);
  printf("%p\n", wgpuRenderBundleEncoderRelease);

  printf("%p\n", wgpuRenderPassEncoderBeginOcclusionQuery);
  printf("%p\n", wgpuRenderPassEncoderDraw);
  printf("%p\n", wgpuRenderPassEncoderDrawIndexed);
  printf("%p\n", wgpuRenderPassEncoderDrawIndexedIndirect);
  printf("%p\n", wgpuRenderPassEncoderDrawIndirect);
  printf("%p\n", wgpuRenderPassEncoderEnd);
  printf("%p\n", wgpuRenderPassEncoderEndOcclusionQuery);
  printf("%p\n", wgpuRenderPassEncoderExecuteBundles);
  printf("%p\n", wgpuRenderPassEncoderInsertDebugMarker);
  printf("%p\n", wgpuRenderPassEncoderMultiDrawIndexedIndirect);
  printf("%p\n", wgpuRenderPassEncoderMultiDrawIndirect);
  printf("%p\n", wgpuRenderPassEncoderPopDebugGroup);
  printf("%p\n", wgpuRenderPassEncoderPushDebugGroup);
  printf("%p\n", wgpuRenderPassEncoderSetBindGroup);
  printf("%p\n", wgpuRenderPassEncoderSetBlendConstant);
  printf("%p\n", wgpuRenderPassEncoderSetIndexBuffer);
  printf("%p\n", wgpuRenderPassEncoderSetLabel);
  printf("%p\n", wgpuRenderPassEncoderSetPipeline);
  printf("%p\n", wgpuRenderPassEncoderSetScissorRect);
  printf("%p\n", wgpuRenderPassEncoderSetStencilReference);
  printf("%p\n", wgpuRenderPassEncoderSetVertexBuffer);
  printf("%p\n", wgpuRenderPassEncoderSetViewport);
  printf("%p\n", wgpuRenderPassEncoderWriteTimestamp);
  printf("%p\n", wgpuRenderPassEncoderAddRef);
  printf("%p\n", wgpuRenderPassEncoderRelease);

  printf("%p\n", wgpuRenderPipelineGetBindGroupLayout);
  printf("%p\n", wgpuRenderPipelineSetLabel);
  printf("%p\n", wgpuRenderPipelineAddRef);
  printf("%p\n", wgpuRenderPipelineRelease);

  printf("%p\n", wgpuSamplerSetLabel);
  printf("%p\n", wgpuSamplerAddRef);
  printf("%p\n", wgpuSamplerRelease);

  printf("%p\n", wgpuShaderModuleGetCompilationInfo);
  printf("%p\n", wgpuShaderModuleSetLabel);
  printf("%p\n", wgpuShaderModuleAddRef);
  printf("%p\n", wgpuShaderModuleRelease);

  printf("%p\n", wgpuSurfaceConfigure);
  printf("%p\n", wgpuSurfaceGetCapabilities);
  printf("%p\n", wgpuSurfaceGetCurrentTexture);
  printf("%p\n", wgpuSurfacePresent);
  printf("%p\n", wgpuSurfaceSetLabel);
  printf("%p\n", wgpuSurfaceUnconfigure);
  printf("%p\n", wgpuSurfaceAddRef);
  printf("%p\n", wgpuSurfaceRelease);

  printf("%p\n", wgpuTextureCreateView);
  printf("%p\n", wgpuTextureDestroy);
  printf("%p\n", wgpuTextureGetDepthOrArrayLayers);
  printf("%p\n", wgpuTextureGetDimension);
  printf("%p\n", wgpuTextureGetFormat);
  printf("%p\n", wgpuTextureGetHeight);
  printf("%p\n", wgpuTextureGetMipLevelCount);
  printf("%p\n", wgpuTextureGetSampleCount);
  printf("%p\n", wgpuTextureGetUsage);
  printf("%p\n", wgpuTextureGetWidth);
  printf("%p\n", wgpuTextureSetLabel);
  printf("%p\n", wgpuTextureAddRef);
  printf("%p\n", wgpuTextureRelease);

  printf("%p\n", wgpuTextureViewSetLabel);
  printf("%p\n", wgpuTextureViewAddRef);
  printf("%p\n", wgpuTextureViewRelease);
}
