/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleGrantee;
import org.jkiss.dbeaver.ext.oracle.model.OracleObject;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectType;
import org.jkiss.dbeaver.model.access.DBAPrivilege;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class OraclePrivObject
extends OracleObject<OracleGrantee>
implements DBAPrivilege {
    private String objectOwner;
    private String objectType;
    private String privilege;
    private String grantor;
    private boolean grantable;
    private boolean hierarchy;

    public OraclePrivObject(OracleGrantee grantee, ResultSet resultSet) {
        super(grantee, JDBCUtils.safeGetString((ResultSet)resultSet, (String)"TABLE_NAME"), true);
        this.objectOwner = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"OWNER");
        if (this.objectOwner == null) {
            this.objectOwner = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"TABLE_SCHEMA");
        }
        this.objectType = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"OBJECT_TYPE");
        this.privilege = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"PRIVILEGE");
        this.grantor = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"GRANTOR");
        this.grantable = JDBCUtils.safeGetBoolean((ResultSet)resultSet, (String)"GRANTABLE", (String)"Y");
        this.hierarchy = JDBCUtils.safeGetBoolean((ResultSet)resultSet, (String)"HIERARCHY", (String)"Y");
    }

    @Override
    @NotNull
    public String getName() {
        return super.getName();
    }

    @Property(order=4, viewable=true)
    public String getObjectType() {
        return this.objectType;
    }

    @Property(order=5, viewable=true, supportsPreview=true)
    public Object getObject(DBRProgressMonitor monitor) throws DBException {
        if (monitor == null || CommonUtils.isEmpty((String)this.objectOwner)) {
            return this.name;
        }
        return OracleObjectType.resolveObject(monitor, this.getDataSource(), null, this.objectType, this.objectOwner, this.name);
    }

    @Property(viewable=true, order=10)
    public String getPrivilege() {
        return this.privilege;
    }

    @Property(order=11)
    public String getGrantor() {
        return this.grantor;
    }

    @Property(viewable=true, order=12)
    public boolean isGrantable() {
        return this.grantable;
    }

    @Property(viewable=true, order=13)
    public boolean isHierarchy() {
        return this.hierarchy;
    }
}

