/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.task;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskExecutionListener;
import org.jkiss.dbeaver.model.task.DBTTaskHandler;
import org.jkiss.dbeaver.model.task.DBTTaskRunStatus;
import org.jkiss.dbeaver.model.task.DBTaskUtils;
import org.jkiss.dbeaver.registry.task.TaskImpl;
import org.jkiss.dbeaver.registry.task.TaskLoggingProgressMonitor;
import org.jkiss.dbeaver.registry.task.TaskRunImpl;
import org.jkiss.dbeaver.registry.timezone.TimezoneRegistry;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class TaskRunJob
extends AbstractJob
implements DBRRunnableContext {
    private static final Log log = Log.getLog(TaskRunJob.class);
    private static final AtomicInteger taskNumber = new AtomicInteger(0);
    private final TaskImpl task;
    private final Locale locale;
    private final DBTTaskExecutionListener executionListener;
    private Log taskLog = log;
    private DBRProgressMonitor activeMonitor;
    private DBTTaskRunStatus taskRunStatus = new DBTTaskRunStatus();
    private Instant taskStartTime = Instant.now();
    private Duration elapsedTime = Duration.ZERO;
    private Throwable taskError;
    private boolean canceledByTimeOut = false;

    public TaskRunJob(TaskImpl task, Locale locale, DBTTaskExecutionListener executionListener) {
        super("Task [" + task.getType().getName() + "] runner - " + task.getName());
        this.setUser(true);
        this.setSystem(false);
        this.task = task;
        this.locale = locale;
        this.executionListener = new LoggingExecutionListener(executionListener);
    }

    protected IStatus run(DBRProgressMonitor monitor) {
        block31: {
            Date startTime = new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmm", Locale.getDefault());
            dateFormat.setTimeZone(TimeZone.getTimeZone(TimezoneRegistry.getUserDefaultTimezone()));
            String taskId = dateFormat.format(startTime) + "_" + taskNumber.incrementAndGet();
            TaskRunImpl taskRun = new TaskRunImpl(taskId, new Date(), System.getProperty("user.name"), GeneralUtils.getProductTitle(), null, null);
            this.task.getTaskStatsFolder(true);
            Path logFile = Objects.requireNonNull(this.task.getRunLog(taskRun));
            this.task.addNewRun(taskRun);
            try {
                Throwable throwable = null;
                Object var8_10 = null;
                try (PrintStream logStream = new PrintStream(Files.newOutputStream(logFile, new OpenOption[0]), true, StandardCharsets.UTF_8);){
                    this.taskLog = Log.getLog(TaskRunJob.class);
                    PrintStream oldLogWriter = Log.getLogWriter();
                    Log.setLogWriter((OutputStream)logStream);
                    this.taskLog.info((Object)String.format("Task '%s' (%s) started", this.task.getName(), this.task.getId()));
                    monitor.beginTask("Run task '" + this.task.getName() + " (" + this.task.getType().getName() + ")", 1);
                    try {
                        try {
                            this.taskRunStatus = this.executeTask((DBRProgressMonitor)new TaskLoggingProgressMonitor(monitor, this.task), logStream);
                            taskRun.setExtraMessage(this.taskRunStatus.getResultMessage());
                        }
                        catch (Throwable e) {
                            this.taskError = e;
                            this.taskLog.error((Object)"Task fatal error", e);
                            monitor.done();
                            taskRun.setRunDuration(this.elapsedTime.toMillis());
                            if (this.activeMonitor.isCanceled() || monitor.isCanceled()) {
                                taskRun.setErrorMessage("Canceled");
                                this.taskLog.info((Object)String.format("Task '%s' (%s) cancelled after %s ms", this.task.getName(), this.task.getId(), this.elapsedTime));
                            } else if (this.taskError != null) {
                                String errorMessage = this.taskError.getMessage();
                                if (CommonUtils.isEmpty((String)errorMessage)) {
                                    errorMessage = this.taskError.getClass().getName();
                                }
                                taskRun.setErrorMessage(errorMessage);
                                StringWriter buf = new StringWriter();
                                this.taskError.printStackTrace(new PrintWriter((Writer)buf, true));
                                taskRun.setErrorStackTrace(buf.toString());
                                this.taskLog.info((Object)String.format("Task '%s' (%s) finished with errors in %s ms", this.task.getName(), this.task.getId(), this.elapsedTime));
                            } else {
                                this.taskLog.info((Object)String.format("Task '%s' (%s) finished successfully in %s ms", this.task.getName(), this.task.getId(), this.elapsedTime));
                            }
                            this.task.updateRun(taskRun);
                            this.taskLog.flush();
                            Log.setLogWriter((OutputStream)oldLogWriter);
                            break block31;
                        }
                    }
                    catch (Throwable throwable2) {
                        monitor.done();
                        taskRun.setRunDuration(this.elapsedTime.toMillis());
                        if (this.activeMonitor.isCanceled() || monitor.isCanceled()) {
                            taskRun.setErrorMessage("Canceled");
                            this.taskLog.info((Object)String.format("Task '%s' (%s) cancelled after %s ms", this.task.getName(), this.task.getId(), this.elapsedTime));
                        } else if (this.taskError != null) {
                            String errorMessage = this.taskError.getMessage();
                            if (CommonUtils.isEmpty((String)errorMessage)) {
                                errorMessage = this.taskError.getClass().getName();
                            }
                            taskRun.setErrorMessage(errorMessage);
                            StringWriter buf = new StringWriter();
                            this.taskError.printStackTrace(new PrintWriter((Writer)buf, true));
                            taskRun.setErrorStackTrace(buf.toString());
                            this.taskLog.info((Object)String.format("Task '%s' (%s) finished with errors in %s ms", this.task.getName(), this.task.getId(), this.elapsedTime));
                        } else {
                            this.taskLog.info((Object)String.format("Task '%s' (%s) finished successfully in %s ms", this.task.getName(), this.task.getId(), this.elapsedTime));
                        }
                        this.task.updateRun(taskRun);
                        this.taskLog.flush();
                        Log.setLogWriter((OutputStream)oldLogWriter);
                        throw throwable2;
                    }
                    monitor.done();
                    taskRun.setRunDuration(this.elapsedTime.toMillis());
                    if (this.activeMonitor.isCanceled() || monitor.isCanceled()) {
                        taskRun.setErrorMessage("Canceled");
                        this.taskLog.info((Object)String.format("Task '%s' (%s) cancelled after %s ms", this.task.getName(), this.task.getId(), this.elapsedTime));
                    } else if (this.taskError != null) {
                        String errorMessage = this.taskError.getMessage();
                        if (CommonUtils.isEmpty((String)errorMessage)) {
                            errorMessage = this.taskError.getClass().getName();
                        }
                        taskRun.setErrorMessage(errorMessage);
                        StringWriter buf = new StringWriter();
                        this.taskError.printStackTrace(new PrintWriter((Writer)buf, true));
                        taskRun.setErrorStackTrace(buf.toString());
                        this.taskLog.info((Object)String.format("Task '%s' (%s) finished with errors in %s ms", this.task.getName(), this.task.getId(), this.elapsedTime));
                    } else {
                        this.taskLog.info((Object)String.format("Task '%s' (%s) finished successfully in %s ms", this.task.getName(), this.task.getId(), this.elapsedTime));
                    }
                    this.task.updateRun(taskRun);
                    this.taskLog.flush();
                    Log.setLogWriter((OutputStream)oldLogWriter);
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                log.error((Object)"Error opening task run log file", (Throwable)e);
            }
        }
        return Status.OK_STATUS;
    }

    private DBTTaskRunStatus executeTask(@NotNull DBRProgressMonitor monitor, @NotNull PrintStream logWriter) throws DBException, InterruptedException {
        this.activeMonitor = monitor;
        DBTaskUtils.confirmTaskOrThrow((DBTTask)this.task, (Log)this.taskLog, (PrintStream)logWriter);
        DBTTaskHandler taskHandler = this.task.getType().createHandler();
        DBTTaskRunStatus taskStatus = taskHandler.executeTask((DBRRunnableContext)this, (DBTTask)this.task, this.locale, this.taskLog, logWriter, this.executionListener);
        if (monitor.isCanceled()) {
            if (this.canceledByTimeOut) {
                taskStatus.setResultMessage("by timeout reached");
            }
            if (taskStatus.getResultMessage() == null) {
                taskStatus.setResultMessage("by user");
            }
        }
        return taskStatus;
    }

    public void run(boolean fork, boolean cancelable, DBRRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        runnable.run(this.activeMonitor);
    }

    @NotNull
    public DBTTaskRunStatus getTaskRunStatus() {
        return this.taskRunStatus;
    }

    @Nullable
    public Throwable getTaskError() {
        return this.taskError;
    }

    public void cancelByTimeout() {
        this.canceledByTimeOut = true;
        this.cancel();
        this.activeMonitor.getNestedMonitor().setCanceled(true);
        if (this.isRunDirectly()) {
            this.canceling();
        }
    }

    @NotNull
    public Duration getElapsedTime() {
        return Duration.between(this.taskStartTime, Instant.now());
    }

    @NotNull
    public TaskImpl getTask() {
        return this.task;
    }

    private class LoggingExecutionListener
    implements DBTTaskExecutionListener {
        DBTTaskExecutionListener parent;

        public LoggingExecutionListener(DBTTaskExecutionListener src) {
            this.parent = src;
        }

        public void taskStarted(@Nullable DBTTask task) {
            TaskRunJob.this.taskStartTime = Instant.now();
            this.parent.taskStarted(task);
        }

        public void taskFinished(@Nullable DBTTask task, @Nullable Object result, @Nullable Throwable error, @Nullable Object settings) {
            this.parent.taskFinished(task, result, error, settings);
            TaskRunJob.this.elapsedTime = TaskRunJob.this.getElapsedTime();
            TaskRunJob.this.taskError = error;
        }

        public void subTaskFinished(@Nullable DBTTask task, @Nullable Throwable error, @Nullable Object settings) {
            this.parent.subTaskFinished(task, error, settings);
        }
    }
}

