/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.utils;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.ai.AIContextSettings;
import org.jkiss.dbeaver.model.ai.AIDatabaseScope;
import org.jkiss.dbeaver.model.ai.AIQueryConfirmationRule;
import org.jkiss.dbeaver.model.ai.AISettings;
import org.jkiss.dbeaver.model.ai.internal.AIMessages;
import org.jkiss.dbeaver.model.ai.registry.AIEngineDescriptor;
import org.jkiss.dbeaver.model.ai.registry.AIEngineRegistry;
import org.jkiss.dbeaver.model.ai.registry.AISettingsManager;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.impl.DataSourceContextProvider;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLQueryCategory;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableColumn;
import org.jkiss.dbeaver.model.struct.rdb.DBSTablePartition;
import org.jkiss.dbeaver.model.struct.rdb.DBSTrigger;
import org.jkiss.dbeaver.model.struct.rdb.DBSView;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.UIServiceSQL;
import org.jkiss.utils.CommonUtils;

public final class AIUtils {
    private static final Log log = Log.getLog(AIUtils.class);

    @Nullable
    public static AIEngineDescriptor getActiveEngineDescriptor() {
        return AIEngineRegistry.getInstance().getEngineDescriptor(AISettingsManager.getInstance().getSettings().activeEngine());
    }

    public static boolean hasValidConfiguration() throws DBException {
        AISettings aiSettings = AISettingsManager.getInstance().getSettings();
        Object configuration = aiSettings.getEngineConfiguration(aiSettings.activeEngine());
        return configuration.isValidConfiguration();
    }

    public static String getSecretValueOrDefault(@NotNull String secretId, @Nullable String defaultValue) throws DBException {
        String secretValue = DBSSecretController.getGlobalSecretController().getPrivateSecretValue(secretId);
        if (CommonUtils.isEmpty((String)secretValue)) {
            return defaultValue;
        }
        return secretValue;
    }

    public static boolean isEligible(@Nullable DBPObject dbpObject) {
        if (dbpObject instanceof DataSourceDescriptor) {
            DataSourceDescriptor descriptor = (DataSourceDescriptor)dbpObject;
            return descriptor.getDriver().isEmbedded();
        }
        return dbpObject instanceof DBSEntity || dbpObject instanceof DBSSchema || dbpObject instanceof DBSTableColumn || dbpObject instanceof DBSProcedure || dbpObject instanceof DBSTrigger || dbpObject instanceof DBSEntityConstraint;
    }

    public static String getObjectDDL(@Nullable DBSObject object, @NotNull DBRProgressMonitor monitor) {
        if ((object instanceof DBSProcedure || object instanceof DBSTrigger || object instanceof DBSEntityConstraint || object instanceof DBSView) && object instanceof DBPScriptObject) {
            DBPScriptObject scriptObject = (DBPScriptObject)object;
            try {
                return scriptObject.getObjectDefinitionText(monitor, Map.of("ddl.includeComments", false, "ddl.includeNestedObjects", false, "ddl.skipIndexes", true, "ddl.skipDrops", true));
            }
            catch (DBException e) {
                log.debug((Object)e);
            }
        }
        return null;
    }

    public static boolean confirmExecutionIfNeeded(@NotNull DBPDataSource dataSource, @NotNull List<SQLScriptElement> scriptElements, boolean isCommand) {
        if (DBWorkbench.getPlatform().getApplication().isMultiuser()) {
            return true;
        }
        Set queryCategories = SQLQueryCategory.categorizeScript(scriptElements);
        if (queryCategories.contains(SQLQueryCategory.UNKNOWN) && AIUtils.isConfirmationNeeded("ai.confirmation.other")) {
            String message = isCommand ? AIMessages.ai_execute_command_confirm_other_message : AIMessages.ai_execute_query_confirm_other_message;
            return AIUtils.confirmExecute(AIMessages.ai_execute_query_title, message, dataSource, scriptElements);
        }
        if (queryCategories.contains(SQLQueryCategory.DDL) && AIUtils.isConfirmationNeeded("ai.confirmation.ddl")) {
            String message = isCommand ? AIMessages.ai_execute_command_confirm_ddl_message : AIMessages.ai_execute_query_confirm_ddl_message;
            return AIUtils.confirmExecute(AIMessages.ai_execute_query_title, message, dataSource, scriptElements);
        }
        if (queryCategories.contains(SQLQueryCategory.DML) && AIUtils.isConfirmationNeeded("ai.confirmation.dml")) {
            String message = isCommand ? AIMessages.ai_execute_command_confirm_dml_message : AIMessages.ai_execute_query_confirm_dml_message;
            return AIUtils.confirmExecute(AIMessages.ai_execute_query_title, message, dataSource, scriptElements);
        }
        if (queryCategories.contains(SQLQueryCategory.SQL) && AIUtils.isConfirmationNeeded("ai.confirmation.sql")) {
            String message = isCommand ? AIMessages.ai_execute_command_confirm_sql_message : AIMessages.ai_execute_query_confirm_sql_message;
            return AIUtils.confirmExecute(AIMessages.ai_execute_query_title, message, dataSource, scriptElements);
        }
        return true;
    }

    public static void disableAutoCommitIfNeeded(@NotNull DBRProgressMonitor monitor, @NotNull List<SQLScriptElement> scriptElements, @Nullable DBCExecutionContext context) throws DBException {
        DBCTransactionManager txnManager;
        if (!SQLQueryCategory.categorizeScript(scriptElements).contains(SQLQueryCategory.DML)) {
            return;
        }
        AIQueryConfirmationRule dmlRule = (AIQueryConfirmationRule)CommonUtils.valueOf(AIQueryConfirmationRule.class, (String)DBWorkbench.getPlatform().getPreferenceStore().getString("ai.confirmation.dml"), (Enum)AIQueryConfirmationRule.CONFIRM);
        if (dmlRule == AIQueryConfirmationRule.DISABLE_AUTOCOMMIT && (txnManager = DBUtils.getTransactionManager((DBCExecutionContext)context)) != null && txnManager.isAutoCommit()) {
            txnManager.setAutoCommit(monitor, false);
            AIUtils.showAutoCommitDisabledNotification();
        }
    }

    private static void showAutoCommitDisabledNotification() {
        DBWorkbench.getPlatformUI().showWarningNotification(AIMessages.ai_execute_query_auto_commit_disabled_title, AIMessages.ai_execute_query_auto_commit_disabled_message);
    }

    private static boolean isConfirmationNeeded(@NotNull String actionName) {
        return CommonUtils.valueOf(AIQueryConfirmationRule.class, (String)DBWorkbench.getPlatform().getPreferenceStore().getString(actionName), (Enum)AIQueryConfirmationRule.CONFIRM) == AIQueryConfirmationRule.CONFIRM;
    }

    private static boolean confirmExecute(@NotNull String title, @NotNull String message, @NotNull DBPDataSource dataSource, @NotNull List<SQLScriptElement> scriptElements) {
        String delimiter = SQLUtils.getDefaultScriptDelimiter((SQLDialect)dataSource.getSQLDialect());
        String scriptText = scriptElements.stream().map(Object::toString).collect(Collectors.joining(delimiter + "\n"));
        UIServiceSQL serviceSQL = (UIServiceSQL)DBWorkbench.getService(UIServiceSQL.class);
        return serviceSQL != null ? serviceSQL.confirmQueryExecution(title, message, scriptText, AIUtils.getContextProvider(scriptElements), true) : DBWorkbench.getPlatformUI().confirmAction(title, message, true);
    }

    @NotNull
    private static DBPContextProvider getContextProvider(@NotNull List<SQLScriptElement> script) {
        DBPDataSource dataSource = script.stream().findFirst().map(SQLScriptElement::getDataSource).orElse(null);
        return new DataSourceContextProvider((DBSObject)dataSource);
    }

    public static void updateScopeSettingsIfNeeded(@NotNull AIContextSettings settings, @NotNull DBPDataSourceContainer container, @Nullable DBCExecutionContext executionContext) {
        if (settings.getScope() != null || !container.isConnected()) {
            return;
        }
        if (executionContext == null || executionContext.getContextDefaults() == null) {
            settings.setScope(AIDatabaseScope.CURRENT_DATABASE);
            return;
        }
        DBCExecutionContextDefaults contextDefaults = executionContext.getContextDefaults();
        if (contextDefaults.getDefaultSchema() != null || contextDefaults.supportsSchemaChange()) {
            settings.setScope(AIDatabaseScope.CURRENT_SCHEMA);
        } else if (contextDefaults.getDefaultCatalog() != null || contextDefaults.supportsCatalogChange()) {
            settings.setScope(AIDatabaseScope.CURRENT_DATABASE);
        } else {
            settings.setScope(AIDatabaseScope.CURRENT_DATASOURCE);
        }
    }

    public static boolean isExcludableObject(@NotNull DBRProgressMonitor monitor, @NotNull DBSObject obj) {
        return DBUtils.isSystemObject((Object)obj) || DBUtils.isHiddenObject((Object)obj) || obj instanceof DBSTablePartition || DBNUtils.getNodeByObject((DBRProgressMonitor)monitor, (DBSObject)obj, (boolean)false) == null;
    }
}

