/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.dialogs.LinkedResourceEditor;
import org.eclipse.ui.internal.ide.dialogs.PathVariablesGroup;

public class ProjectLinkedResourcePage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private Label topLabel;
    private final PathVariablesGroup pathVariablesGroup = new PathVariablesGroup(true, 3);
    private final LinkedResourceEditor linkedResourceEditor = new LinkedResourceEditor();

    public ProjectLinkedResourcePage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.ui.ide.linked_resource_page_context");
        IAdaptable adaptable = this.getElement();
        IProject project = (IProject)Adapters.adapt((Object)adaptable, IProject.class);
        if (project != null) {
            this.pathVariablesGroup.setResource((IResource)project);
            this.linkedResourceEditor.setProject(project);
        }
        Font font = parent.getFont();
        Composite pageComponent = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        pageComponent.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        pageComponent.setLayoutData((Object)data);
        pageComponent.setFont(font);
        CTabFolder tabFolder = new CTabFolder(pageComponent, 128);
        tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CTabFolder source = (CTabFolder)e.getSource();
                if (source.getSelectionIndex() == 1) {
                    ProjectLinkedResourcePage.this.switchToLinkedResources();
                } else {
                    ProjectLinkedResourcePage.this.switchToPathVariables();
                }
            }
        });
        pageComponent.setLayout((Layout)layout);
        data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        tabFolder.setLayoutData((Object)data);
        tabFolder.setFont(font);
        CTabItem variableItem = new CTabItem(tabFolder, 2048);
        tabFolder.setSelection(0);
        Composite variableComposite = new Composite((Composite)tabFolder, 0);
        variableComposite.setLayout((Layout)new GridLayout());
        variableComposite.setFont(font);
        this.topLabel = new Label(variableComposite, 0);
        this.topLabel.setText(IDEWorkbenchMessages.ProjectLinkedResourcePage_description);
        data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        this.topLabel.setLayoutData((Object)data);
        this.topLabel.setFont(font);
        this.pathVariablesGroup.createContents(variableComposite);
        variableItem.setControl((Control)variableComposite);
        variableItem.setText(IDEWorkbenchMessages.ProjectLinkedResourcePage_pathVariableTabTitle);
        CTabItem linkedResourceItem = new CTabItem(tabFolder, 2048);
        Composite linkedResourceComposite = new Composite((Composite)tabFolder, 0);
        linkedResourceComposite.setLayout((Layout)new GridLayout());
        linkedResourceComposite.setFont(font);
        this.linkedResourceEditor.createContents(linkedResourceComposite);
        linkedResourceItem.setControl((Control)linkedResourceComposite);
        linkedResourceItem.setText(IDEWorkbenchMessages.ProjectLinkedResourcePage_linkedResourcesTabTitle);
        this.updateWidgetState(true);
        return pageComponent;
    }

    private void switchToPathVariables() {
        this.pathVariablesGroup.reloadContent();
    }

    private void switchToLinkedResources() {
        this.pathVariablesGroup.performOk();
        this.linkedResourceEditor.reloadContent();
    }

    protected static void createSpace(Composite parent) {
        Label vfiller = new Label(parent, 16384);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.grabExcessHorizontalSpace = false;
        gridData.verticalAlignment = 2;
        gridData.grabExcessVerticalSpace = false;
        vfiller.setLayoutData((Object)gridData);
    }

    public void dispose() {
        this.pathVariablesGroup.dispose();
        this.linkedResourceEditor.dispose();
        super.dispose();
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        return this.pathVariablesGroup.performOk() && this.linkedResourceEditor.performOk();
    }

    protected void updateWidgetState(boolean enableLinking) {
        this.topLabel.setEnabled(enableLinking);
        this.pathVariablesGroup.setEnabled(enableLinking);
    }
}

