/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.ui.internal.util.Util;

public final class ActivityPatternBindingDefinition {
    private static final int HASH_FACTOR = 89;
    private static final int HASH_INITIAL = ActivityPatternBindingDefinition.class.getName().hashCode();
    private final String activityId;
    private transient int hashCode = HASH_INITIAL;
    private final String pattern;
    private final String sourceId;
    private transient String string;
    private final boolean isEqualityPattern;

    static Map<String, Collection<ActivityPatternBindingDefinition>> activityPatternBindingDefinitionsByActivityId(Collection<ActivityPatternBindingDefinition> activityPatternBindingDefinitions) {
        if (activityPatternBindingDefinitions == null) {
            throw new NullPointerException();
        }
        HashMap<String, Collection<ActivityPatternBindingDefinition>> map = new HashMap<String, Collection<ActivityPatternBindingDefinition>>();
        for (ActivityPatternBindingDefinition activityPatternBindingDefinition : activityPatternBindingDefinitions) {
            String activityId = activityPatternBindingDefinition.getActivityId();
            if (activityId == null) continue;
            ArrayList<ActivityPatternBindingDefinition> activityPatternBindingDefinitions2 = (ArrayList<ActivityPatternBindingDefinition>)map.get(activityId);
            if (activityPatternBindingDefinitions2 == null) {
                activityPatternBindingDefinitions2 = new ArrayList<ActivityPatternBindingDefinition>();
                map.put(activityId, activityPatternBindingDefinitions2);
            }
            activityPatternBindingDefinitions2.add(activityPatternBindingDefinition);
        }
        return map;
    }

    public ActivityPatternBindingDefinition(String activityId, String pattern, String sourceId) {
        this(activityId, pattern, sourceId, false);
    }

    public ActivityPatternBindingDefinition(String activityId, String pattern, String sourceId, boolean isEqualityPattern) {
        this.activityId = activityId;
        this.pattern = pattern;
        this.sourceId = sourceId;
        this.isEqualityPattern = isEqualityPattern;
    }

    public int compareTo(Object object) {
        ActivityPatternBindingDefinition castedObject = (ActivityPatternBindingDefinition)object;
        int compareTo = Util.compare((Comparable)((Object)this.activityId), (Comparable)((Object)castedObject.activityId));
        if (compareTo == 0 && (compareTo = Util.compare((Comparable)((Object)this.pattern), (Comparable)((Object)castedObject.pattern))) == 0 && (compareTo = Util.compare(this.isEqualityPattern, castedObject.isEqualityPattern)) == 0) {
            compareTo = Util.compare((Comparable)((Object)this.sourceId), (Comparable)((Object)castedObject.sourceId));
        }
        return compareTo;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object object) {
        void castedObject;
        if (!(object instanceof ActivityPatternBindingDefinition)) {
            return false;
        }
        ActivityPatternBindingDefinition activityPatternBindingDefinition = (ActivityPatternBindingDefinition)object;
        return Objects.equals(this.activityId, castedObject.activityId) && Objects.equals(this.pattern, castedObject.pattern) && this.isEqualityPattern == castedObject.isEqualityPattern && Objects.equals(this.sourceId, castedObject.sourceId);
    }

    public String getActivityId() {
        return this.activityId;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public boolean isEqualityPattern() {
        return this.isEqualityPattern;
    }

    public int hashCode() {
        if (this.hashCode == HASH_INITIAL) {
            this.hashCode = this.hashCode * 89 + Objects.hashCode(this.activityId);
            this.hashCode = this.hashCode * 89 + Objects.hashCode(this.pattern);
            this.hashCode = this.hashCode * 89 + Objects.hashCode(this.sourceId);
            if (this.hashCode == HASH_INITIAL) {
                ++this.hashCode;
            }
        }
        return this.hashCode;
    }

    public String toString() {
        if (this.string == null) {
            StringBuilder stringBuffer = new StringBuilder();
            stringBuffer.append('[');
            stringBuffer.append(this.activityId);
            stringBuffer.append(',');
            stringBuffer.append(this.isEqualityPattern);
            stringBuffer.append(',');
            stringBuffer.append(this.pattern);
            stringBuffer.append(',');
            stringBuffer.append(this.sourceId);
            stringBuffer.append(']');
            this.string = stringBuffer.toString();
        }
        return this.string;
    }
}

