/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.text;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.runtime.IPersistentStorage;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.ProjectFileEditorInput;
import org.jkiss.dbeaver.ui.editors.text.BaseTextDocumentProvider;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.IOUtils;

public class FileRefDocumentProvider
extends BaseTextDocumentProvider {
    private static final Log log = Log.getLog(FileRefDocumentProvider.class);
    private static final int DEFAULT_BUFFER_SIZE = 10000;

    protected IEditorInput createNewEditorInput(IFile newFile) {
        return new ProjectFileEditorInput(newFile);
    }

    protected Document createDocument(Object element) throws CoreException {
        Document document = this.createEmptyDocument();
        IStorage storage = EditorUtils.getStorageFromInput(element);
        if (storage != null && this.setDocumentContent((IDocument)document, storage)) {
            this.setupDocument((IDocument)document);
            return document;
        }
        File file = EditorUtils.getLocalFileFromInput(element);
        if (file != null) {
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (FileInputStream stream = new FileInputStream(file);){
                    this.setDocumentContent((IDocument)document, stream, null);
                    this.setupDocument((IDocument)document);
                    return document;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new CoreException(GeneralUtils.makeExceptionStatus((Throwable)e));
            }
        }
        throw new IllegalArgumentException("Project document provider supports only editor inputs which provides IStorage facility");
    }

    protected void setupDocument(IDocument document) {
    }

    public boolean isReadOnly(Object element) {
        IStorage storage = EditorUtils.getStorageFromInput(element);
        if (storage != null) {
            return storage.isReadOnly();
        }
        File file = EditorUtils.getLocalFileFromInput(element);
        if (file != null) {
            return !file.isFile();
        }
        return super.isReadOnly(element);
    }

    public boolean isModifiable(Object element) {
        return !this.isReadOnly(element);
    }

    public boolean isDeleted(Object element) {
        IStorage storage = EditorUtils.getStorageFromInput(element);
        if (storage instanceof IResource) {
            return !((IResource)storage).exists();
        }
        File file = EditorUtils.getLocalFileFromInput(element);
        if (file != null) {
            return !file.exists();
        }
        return super.isDeleted(element);
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        block25: {
            try {
                byte[] bytes;
                IStorage storage = EditorUtils.getStorageFromInput(element);
                File localFile = null;
                if (storage == null && (localFile = EditorUtils.getLocalFileFromInput(element)) == null) {
                    throw new DBException("Can't obtain file from editor input");
                }
                String encoding = storage instanceof IEncodedStorage ? ((IEncodedStorage)storage).getCharset() : GeneralUtils.UTF8_ENCODING;
                Charset charset = Charset.forName(encoding);
                CharsetEncoder encoder = charset.newEncoder();
                encoder.onMalformedInput(CodingErrorAction.REPLACE);
                encoder.onUnmappableCharacter(CodingErrorAction.REPORT);
                ByteBuffer byteBuffer = encoder.encode(CharBuffer.wrap(document.get()));
                if (byteBuffer.hasArray()) {
                    bytes = byteBuffer.array();
                } else {
                    bytes = new byte[byteBuffer.limit()];
                    byteBuffer.get(bytes);
                }
                ByteArrayInputStream stream = new ByteArrayInputStream(bytes, 0, byteBuffer.limit());
                if (storage instanceof IFile) {
                    IFile file = (IFile)storage;
                    if (file.exists()) {
                        this.fireElementStateChanging(element);
                        try {
                            file.setContents((InputStream)stream, true, true, monitor);
                            break block25;
                        }
                        catch (CoreException x) {
                            this.fireElementStateChangeFailed(element);
                            throw x;
                        }
                        catch (RuntimeException x) {
                            this.fireElementStateChangeFailed(element);
                            throw x;
                        }
                    }
                    try {
                        monitor.beginTask("Save file '" + file.getName() + "'", 2000);
                        file.create((InputStream)stream, false, monitor);
                        break block25;
                    }
                    finally {
                        monitor.done();
                    }
                }
                if (storage instanceof IPersistentStorage) {
                    monitor.beginTask("Save document", 1);
                    ((IPersistentStorage)storage).setContents(monitor, (InputStream)stream);
                    break block25;
                }
                if (localFile != null) {
                    Throwable throwable = null;
                    Object var14_20 = null;
                    try (FileOutputStream os = new FileOutputStream(localFile);){
                        IOUtils.copyStream((InputStream)stream, (OutputStream)os);
                        break block25;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                throw new DBException("Storage [" + String.valueOf(storage) + "] doesn't support save");
            }
            catch (Exception e) {
                if (e instanceof CoreException) {
                    throw (CoreException)((Object)e);
                }
                throw new CoreException(GeneralUtils.makeExceptionStatus((Throwable)e));
            }
        }
    }

    protected boolean setDocumentContent(IDocument document, IStorage storage) throws CoreException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream contentStream = storage.getContents();){
                String encoding = storage instanceof IEncodedStorage ? ((IEncodedStorage)storage).getCharset() : GeneralUtils.getDefaultFileEncoding();
                this.setDocumentContent(document, contentStream, encoding);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException(GeneralUtils.makeExceptionStatus((Throwable)e));
        }
        return true;
    }

    protected void setDocumentContent(IDocument document, InputStream contentStream, String encoding) throws IOException {
        BufferedReader in = null;
        try {
            if (encoding == null) {
                encoding = GeneralUtils.UTF8_ENCODING;
            }
            in = new BufferedReader(new InputStreamReader(contentStream, encoding), 10000);
            StringBuilder buffer = new StringBuilder(10000);
            char[] readBuffer = new char[2048];
            int n = in.read(readBuffer);
            while (n > 0) {
                buffer.append(readBuffer, 0, n);
                n = in.read(readBuffer);
            }
            document.set(buffer.toString());
        }
        catch (Throwable throwable) {
            if (in != null) {
                ContentUtils.close(in);
            } else {
                ContentUtils.close((Closeable)contentStream);
            }
            throw throwable;
        }
        if (in != null) {
            ContentUtils.close((Closeable)in);
        } else {
            ContentUtils.close((Closeable)contentStream);
        }
    }

    protected long computeModificationStamp(IResource resource) {
        long modificationStamp = resource.getModificationStamp();
        IPath path = resource.getLocation();
        if (path == null) {
            return modificationStamp;
        }
        modificationStamp = path.toFile().lastModified();
        return modificationStamp;
    }

    protected void refreshFile(IFile file) throws CoreException {
        this.refreshFile(file, this.getProgressMonitor());
    }

    protected AbstractDocumentProvider.ElementInfo createElementInfo(Object element) throws CoreException {
        IEditorInput input;
        IStorage storage;
        if (element instanceof IEditorInput && (storage = EditorUtils.getStorageFromInput(input = (IEditorInput)element)) instanceof IFile) {
            Document d;
            IFile file = (IFile)storage;
            try {
                this.refreshFile(file);
            }
            catch (CoreException x) {
                log.warn((Object)"Can't refresh file", (Throwable)x);
            }
            IStatus s = null;
            try {
                d = this.createDocument(element);
            }
            catch (CoreException x) {
                log.warn((Object)"Can't create document", (Throwable)x);
                s = x.getStatus();
                d = this.createEmptyDocument();
            }
            String initialLineDelimiter = GeneralUtils.getDefaultLineSeparator();
            if (initialLineDelimiter != null) {
                ((IDocumentExtension4)d).setInitialLineDelimiter(initialLineDelimiter);
            }
            IAnnotationModel m = this.createAnnotationModel(element);
            FileSynchronizer f = new FileSynchronizer(input);
            f.install();
            FileInfo info = new FileInfo((IDocument)d, m, f);
            info.modificationStamp = this.computeModificationStamp((IResource)file);
            info.fStatus = s;
            return info;
        }
        return super.createElementInfo(element);
    }

    protected void disposeElementInfo(Object element, AbstractDocumentProvider.ElementInfo info) {
        if (info instanceof FileInfo) {
            FileInfo fileInfo = (FileInfo)info;
            if (fileInfo.fileSynchronizer != null) {
                fileInfo.fileSynchronizer.uninstall();
            }
        }
        super.disposeElementInfo(element, info);
    }

    protected void refreshFile(IFile file, IProgressMonitor monitor) throws CoreException {
        if (file != null) {
            try {
                file.refreshLocal(2, monitor);
            }
            catch (OperationCanceledException operationCanceledException) {}
        }
    }

    protected void handleElementContentChanged(IEditorInput fileEditorInput) {
        FileInfo info = (FileInfo)this.getElementInfo(fileEditorInput);
        if (info == null) {
            return;
        }
        IStorage storage = EditorUtils.getStorageFromInput(fileEditorInput);
        if (storage instanceof IFile) {
            IFile file = (IFile)storage;
            Document document = this.createEmptyDocument();
            IStatus status = null;
            try {
                try {
                    this.refreshFile(file);
                }
                catch (CoreException x) {
                    log.error((Object)"handleElementContentChanged", (Throwable)x);
                }
                this.setDocumentContent((IDocument)document, (IStorage)file);
            }
            catch (CoreException x) {
                status = x.getStatus();
            }
            String newContent = document.get();
            if (!newContent.equals(info.fDocument.get())) {
                this.fireElementContentAboutToBeReplaced(fileEditorInput);
                this.removeUnchangedElementListeners(fileEditorInput, info);
                info.fDocument.removeDocumentListener((IDocumentListener)info);
                info.fDocument.set(newContent);
                info.fCanBeSaved = false;
                info.modificationStamp = this.computeModificationStamp((IResource)file);
                info.fStatus = status;
                this.addUnchangedElementListeners(fileEditorInput, info);
                this.fireElementContentReplaced(fileEditorInput);
            } else {
                this.removeUnchangedElementListeners(fileEditorInput, info);
                info.fCanBeSaved = false;
                info.modificationStamp = this.computeModificationStamp((IResource)file);
                info.fStatus = status;
                this.addUnchangedElementListeners(fileEditorInput, info);
                this.fireElementDirtyStateChanged(fileEditorInput, false);
            }
        }
    }

    protected void handleElementMoved(IEditorInput fileEditorInput, IPath path) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFile newFile = workspace.getRoot().getFile(path);
        this.fireElementMoved(fileEditorInput, this.createNewEditorInput(newFile));
    }

    protected void handleElementDeleted(IEditorInput fileEditorInput) {
        this.fireElementDeleted(fileEditorInput);
    }

    protected class FileInfo
    extends AbstractDocumentProvider.ElementInfo {
        public FileSynchronizer fileSynchronizer;
        public long modificationStamp;

        public FileInfo(IDocument document, IAnnotationModel model, FileSynchronizer fileSynchronizer) {
            super((AbstractDocumentProvider)FileRefDocumentProvider.this, document, model);
            this.modificationStamp = -1L;
            this.fileSynchronizer = fileSynchronizer;
        }
    }

    protected class FileSynchronizer
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        protected IEditorInput fileEditorInput;
        protected boolean isInstalled = false;

        public FileSynchronizer(IEditorInput fileEditorInput) {
            this.fileEditorInput = fileEditorInput;
        }

        protected IFile getFile() {
            IStorage storage = EditorUtils.getStorageFromInput(this.fileEditorInput);
            return storage instanceof IFile ? (IFile)storage : null;
        }

        public void install() {
            this.getFile().getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
            this.isInstalled = true;
        }

        public void uninstall() {
            this.getFile().getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            this.isInstalled = false;
        }

        public void resourceChanged(IResourceChangeEvent e) {
            IResourceDelta delta = e.getDelta();
            try {
                if (delta != null && this.isInstalled) {
                    delta.accept((IResourceDeltaVisitor)this);
                }
            }
            catch (CoreException x) {
                log.warn((Object)"Error handling resourceChanged", (Throwable)x);
            }
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (delta == null) {
                return false;
            }
            IFile file = this.getFile();
            if (file == null) {
                return false;
            }
            if ((delta = delta.findMember(file.getFullPath())) == null) {
                return false;
            }
            SafeChange runnable = null;
            switch (delta.getKind()) {
                case 4: {
                    boolean isSynchronized;
                    FileInfo info = (FileInfo)FileRefDocumentProvider.this.getElementInfo(this.fileEditorInput);
                    if (info == null || !this.canRefreshFromFile(info)) break;
                    boolean bl = isSynchronized = FileRefDocumentProvider.this.computeModificationStamp((IResource)file) == info.modificationStamp;
                    if ((0x100000 & delta.getFlags()) != 0 && isSynchronized) {
                        runnable = new SafeChange(FileRefDocumentProvider.this, this.fileEditorInput){

                            @Override
                            protected void execute(IEditorInput input) throws Exception {
                                FileRefDocumentProvider.this.handleElementContentChanged(input);
                            }
                        };
                    }
                    if (runnable != null || (0x100 & delta.getFlags()) == 0 || isSynchronized) break;
                    runnable = new SafeChange(FileRefDocumentProvider.this, this.fileEditorInput){

                        @Override
                        protected void execute(IEditorInput input) throws Exception {
                            FileRefDocumentProvider.this.handleElementContentChanged(input);
                        }
                    };
                    break;
                }
                case 2: {
                    if ((0x2000 & delta.getFlags()) != 0) {
                        final IPath path = delta.getMovedToPath();
                        runnable = new SafeChange(FileRefDocumentProvider.this, this.fileEditorInput){

                            @Override
                            protected void execute(IEditorInput input) throws Exception {
                                FileRefDocumentProvider.this.handleElementMoved(input, path);
                            }
                        };
                        break;
                    }
                    FileInfo info = (FileInfo)FileRefDocumentProvider.this.getElementInfo(this.fileEditorInput);
                    if (info == null || !this.canRefreshFromFile(info)) break;
                    runnable = new SafeChange(FileRefDocumentProvider.this, this.fileEditorInput){

                        @Override
                        protected void execute(IEditorInput input) throws Exception {
                            FileRefDocumentProvider.this.handleElementDeleted(input);
                        }
                    };
                }
            }
            if (runnable != null) {
                this.update(runnable);
            }
            return false;
        }

        private boolean canRefreshFromFile(FileInfo info) {
            return true;
        }

        protected void update(Runnable runnable) {
            IWorkbench workbench;
            IWorkbenchWindow[] windows;
            if (runnable instanceof SafeChange) {
                FileRefDocumentProvider.this.fireElementStateChanging(this.fileEditorInput);
            }
            if ((windows = (workbench = PlatformUI.getWorkbench()).getWorkbenchWindows()) != null && windows.length > 0) {
                UIUtils.asyncExec((Runnable)runnable);
            } else {
                runnable.run();
            }
        }
    }

    protected abstract class SafeChange
    implements Runnable {
        private IEditorInput editorInput;

        public SafeChange(IEditorInput input) {
            this.editorInput = input;
        }

        protected abstract void execute(IEditorInput var1) throws Exception;

        @Override
        public void run() {
            if (FileRefDocumentProvider.this.getElementInfo(this.editorInput) == null) {
                FileRefDocumentProvider.this.fireElementStateChangeFailed(this.editorInput);
                return;
            }
            try {
                this.execute(this.editorInput);
            }
            catch (Exception exception) {
                FileRefDocumentProvider.this.fireElementStateChangeFailed(this.editorInput);
            }
        }
    }
}

