/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.exec;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSetMetaData;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCColumnMetaData;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCTableMetaData;
import org.jkiss.utils.CommonUtils;

public class JDBCResultSetMetaDataImpl
implements JDBCResultSetMetaData {
    protected JDBCResultSet resultSet;
    protected ResultSetMetaData original;
    protected List<DBCAttributeMetaData> columns = new ArrayList<DBCAttributeMetaData>();
    protected Map<String, JDBCTableMetaData> tables = new HashMap<String, JDBCTableMetaData>();

    public JDBCResultSetMetaDataImpl(JDBCResultSet resultSet) throws SQLException {
        this.resultSet = resultSet;
        this.original = resultSet.getOriginal().getMetaData();
        int count = this.original.getColumnCount();
        int i = 0;
        while (i < count) {
            this.columns.add(this.createColumnMetaDataImpl(i));
            ++i;
        }
    }

    protected JDBCColumnMetaData createColumnMetaDataImpl(int index) throws SQLException {
        return new JDBCColumnMetaData(this, index);
    }

    public JDBCResultSet getResultSet() {
        return this.resultSet;
    }

    public ResultSetMetaData getOriginal() {
        return this.original;
    }

    public List<? extends DBCAttributeMetaData> getAttributes() {
        return this.columns;
    }

    @Nullable
    public JDBCTableMetaData getTableMetaData(String catalogName, String schemaName, String tableName) {
        if (CommonUtils.isEmpty((String)tableName)) {
            return null;
        }
        String fullQualifiedName = DBUtils.getSimpleQualifiedName((Object[])new Object[]{catalogName, schemaName, tableName});
        JDBCTableMetaData tableMetaData = this.tables.get(fullQualifiedName);
        if (tableMetaData == null) {
            tableMetaData = new JDBCTableMetaData(this, catalogName, schemaName, tableName);
            this.tables.put(fullQualifiedName, tableMetaData);
        }
        return tableMetaData;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.original.getColumnCount();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return this.original.isAutoIncrement(column);
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return this.original.isCaseSensitive(column);
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return this.original.isSearchable(column);
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return this.original.isCurrency(column);
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return this.original.isNullable(column);
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return this.original.isSigned(column);
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return this.original.getColumnDisplaySize(column);
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return JDBCUtils.normalizeIdentifier(this.original.getColumnLabel(column));
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return JDBCUtils.normalizeIdentifier(this.original.getColumnName(column));
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return JDBCUtils.normalizeIdentifier(this.original.getSchemaName(column));
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return this.original.getPrecision(column);
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.original.getScale(column);
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return JDBCUtils.normalizeIdentifier(this.original.getTableName(column));
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return JDBCUtils.normalizeIdentifier(this.original.getCatalogName(column));
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return this.original.getColumnType(column);
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return JDBCUtils.normalizeIdentifier(this.original.getColumnTypeName(column));
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return this.original.isReadOnly(column);
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return this.original.isWritable(column);
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return this.original.isDefinitelyWritable(column);
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return JDBCUtils.normalizeIdentifier(this.original.getColumnClassName(column));
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.original.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.original.isWrapperFor(iface);
    }
}

