/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.config.migration.wizards.datagrip;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.config.migration.ImportConfigMessages;
import org.jkiss.dbeaver.ui.config.migration.datagrip.api.DataGripDataSourceConfigXmlService;
import org.jkiss.dbeaver.ui.config.migration.datagrip.impl.DataGripDataSourceConfigXmlServiceImpl;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;

public class ConfigImportWizardPageDataGripSettings
extends WizardPage {
    private Combo filePathText;
    private Path inputFile;
    DataGripDataSourceConfigXmlService dataGripDataSourceConfigXmlService = DataGripDataSourceConfigXmlServiceImpl.INSTANCE;

    public ConfigImportWizardPageDataGripSettings() {
        super(ImportConfigMessages.config_import_wizard_custom_driver_settings);
        this.setTitle(ImportConfigMessages.config_import_wizard_custom_driver_import_settings_name);
        this.setDescription(ImportConfigMessages.config_import_wizard_jetbrains_description);
    }

    public void createControl(Composite parent) {
        Composite placeholder = UIUtils.createComposite((Composite)parent, (int)3);
        this.filePathText = UIUtils.createLabelCombo((Composite)placeholder, (String)ImportConfigMessages.config_import_wizard_custom_input_file_configuration, (int)2052);
        this.filePathText.setLayoutData((Object)new GridData(768));
        List<Path> configPaths = this.dataGripDataSourceConfigXmlService.tryExtractRecentProjectPath();
        for (Path path : configPaths) {
            this.filePathText.add(path.toString());
        }
        if (!configPaths.isEmpty()) {
            this.filePathText.select(0);
        }
        this.setInputFileAndUpdateButtons();
        this.filePathText.addModifyListener(e -> this.setInputFileAndUpdateButtons());
        UIUtils.createPushButton((Composite)placeholder, (String)"Project folder", (String)ImportConfigMessages.config_import_wizard_custom_input_file_configuration, (DBPImage)UIIcon.OPEN, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String file = DialogUtils.openDirectoryDialog((Shell)ConfigImportWizardPageDataGripSettings.this.getShell(), (String)"JetBrains project directory", null);
                if (file != null) {
                    ConfigImportWizardPageDataGripSettings.this.filePathText.setText(file);
                }
            }
        });
        this.setControl((Control)placeholder);
    }

    private void setInputFileAndUpdateButtons() {
        this.inputFile = Path.of(this.filePathText.getText(), new String[0]);
        if (!Files.exists(this.inputFile, new LinkOption[0])) {
            this.setErrorMessage(NLS.bind((String)ImportConfigMessages.config_import_wizard_file_doesnt_exist_error, (Object)this.inputFile.toAbsolutePath().toString()));
        } else {
            this.setErrorMessage(null);
        }
        this.getWizard().getContainer().updateButtons();
    }

    public boolean isPageComplete() {
        return this.inputFile != null && Files.exists(this.inputFile, new LinkOption[0]);
    }

    public Path getInputFile() {
        return this.inputFile;
    }
}

