/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.model;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.altibase.AltibaseUtils;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericView;
import org.jkiss.dbeaver.model.DBPStatefulObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectState;

public abstract class AltibaseViewAbs
extends GenericView
implements DBPStatefulObject {
    private static final Log log = Log.getLog(AltibaseViewAbs.class);
    protected String schemaName = null;
    protected boolean isValid = false;

    public AltibaseViewAbs(JDBCSession session, GenericStructContainer container, String tableName, String tableType, JDBCResultSet dbResult) {
        super(container, tableName, tableType, dbResult);
        this.schemaName = container.getName();
        if (session == null) {
            this.isValid = true;
        } else {
            try {
                this.isValid = AltibaseUtils.getViewStatus(session, tableType, this.getSchemaName(), this.getName());
            }
            catch (DBCException e) {
                log.warn((Object)"Can't update view status.", (Throwable)e);
            }
        }
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void refreshObjectState(@NotNull DBRProgressMonitor monitor) throws DBCException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)("Refresh state of view '" + this.getName() + "'"));){
            this.isValid = AltibaseUtils.getViewStatus(session, this.getTableType(), this.getSchemaName(), this.getName());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @NotNull
    public DBSObjectState getObjectState() {
        return this.isValid ? DBSObjectState.NORMAL : DBSObjectState.INVALID;
    }
}

