/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataType;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataTypeModifier;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableBase;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPHiddenObject;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPObjectWithLazyDescription;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableColumn;
import org.jkiss.dbeaver.model.meta.IPropertyCacheValidator;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.LazyProperty;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectEx;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectExt3;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectExt4;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableColumn;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class OracleTableColumn
extends JDBCTableColumn<OracleTableBase>
implements DBSTableColumn,
DBSTypedObjectEx,
DBSTypedObjectExt3,
DBPHiddenObject,
DBPNamedObject2,
DBSTypedObjectExt4<OracleDataType>,
DBPObjectWithLazyDescription {
    private OracleDataType type;
    private OracleDataTypeModifier typeMod;
    private String comment;
    private boolean hidden;

    public OracleTableColumn(OracleTableBase table) {
        super((DBSEntity)table, false);
    }

    public OracleTableColumn(DBRProgressMonitor monitor, OracleTableBase table, @NotNull ResultSet dbResult) throws DBException {
        super((DBSEntity)table, true);
        String charUsed;
        this.setDefaultValue(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DATA_DEFAULT"));
        this.setName(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLUMN_NAME"));
        this.setOrdinalPosition(JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"COLUMN_ID"));
        this.typeName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DATA_TYPE");
        this.type = OracleDataType.resolveDataType(monitor, this.getDataSource(), JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DATA_TYPE_OWNER"), this.typeName);
        this.typeMod = OracleDataTypeModifier.resolveTypeModifier(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DATA_TYPE_MOD"));
        if (this.type != null) {
            this.typeName = this.type.getFullyQualifiedName(DBPEvaluationContext.DDL);
            this.valueType = this.type.getTypeID();
        }
        if (this.typeMod == OracleDataTypeModifier.REF) {
            this.valueType = 2006;
        }
        this.setMaxLength(JDBCUtils.safeGetLong((ResultSet)dbResult, (String)("C".equals(charUsed = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CHAR_USED")) ? "CHAR_LENGTH" : "DATA_LENGTH")));
        this.setRequired(!"Y".equals(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"NULLABLE")));
        Integer scale = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"DATA_SCALE");
        if (scale == null && this.type != null && this.type.getScale() != null) {
            scale = this.type.getScale();
        }
        this.setScale(scale);
        this.setPrecision(JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"DATA_PRECISION"));
        this.hidden = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"HIDDEN_COLUMN", (String)"YES");
    }

    @NotNull
    public OracleDataSource getDataSource() {
        return (OracleDataSource)((OracleTableBase)this.getTable()).getDataSource();
    }

    @Property(viewable=true, editable=true, updatable=true, order=20, listProvider=JDBCTableColumn.ColumnTypeNameListProvider.class)
    @NotNull
    public String getFullTypeName() {
        return DBUtils.getFullTypeName((DBSTypedObject)this);
    }

    protected void validateTypeName(String typeName) throws DBException {
        if (this.getDataSource().resolveDataType((DBRProgressMonitor)new VoidProgressMonitor(), typeName) == null) {
            throw new DBException("Bad data type name " + typeName);
        }
    }

    @Nullable
    public OracleDataType getDataType() {
        return this.type;
    }

    public void setDataType(@NotNull OracleDataType type) {
        this.type = type;
        this.typeName = type == null ? "" : type.getFullyQualifiedName(DBPEvaluationContext.DDL);
    }

    @Property(viewable=true, order=30)
    public OracleDataTypeModifier getTypeMod() {
        return this.typeMod;
    }

    @NotNull
    public String getTypeName() {
        return super.getTypeName();
    }

    @Property(viewable=false, editableExpr="!object.table.view", updatableExpr="!object.table.view", order=40)
    public long getMaxLength() {
        return super.getMaxLength();
    }

    @Property(viewable=false, editableExpr="!object.table.view", updatableExpr="!object.table.view", order=41)
    public Integer getPrecision() {
        return super.getPrecision();
    }

    @Property(viewable=false, editableExpr="!object.table.view", updatableExpr="!object.table.view", order=42)
    @Nullable
    public Integer getScale() {
        return super.getScale();
    }

    @Property(viewable=true, editableExpr="!object.table.view", updatableExpr="!object.table.view", order=50)
    public boolean isRequired() {
        return super.isRequired();
    }

    @Property(viewable=true, editableExpr="!object.table.view", updatableExpr="!object.table.view", order=70)
    public String getDefaultValue() {
        return super.getDefaultValue();
    }

    public boolean isAutoGenerated() {
        return false;
    }

    @Nullable
    public String getDescription(@NotNull DBRProgressMonitor monitor) {
        return this.getComment(monitor);
    }

    @Property(viewable=true, editable=true, updatable=true, length=PropertyLength.MULTILINE, order=100)
    @LazyProperty(cacheValidator=CommentLoadValidator.class)
    public String getComment(DBRProgressMonitor monitor) {
        if (this.isPersisted() && this.comment == null && !DBWorkbench.getPlatform().isUnitTestMode()) {
            ((OracleTableBase)this.getTable()).loadColumnComments(monitor);
        }
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    void cacheComment() {
        if (this.comment == null) {
            this.comment = "";
        }
    }

    @Nullable
    public String getDescription() {
        return this.comment;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public static class ColumnDataTypeListProvider
    implements IPropertyValueListProvider<OracleTableColumn> {
        public boolean allowCustomValue() {
            return false;
        }

        @Nullable
        public Object[] getPossibleValues(OracleTableColumn column) {
            ArrayList<? extends DBSDataType> dataTypes = new ArrayList<DBSDataType>(((OracleDataSource)((OracleTableBase)column.getTable()).getDataSource()).getLocalDataTypes());
            if (!dataTypes.contains(column.getDataType())) {
                dataTypes.add(column.getDataType());
            }
            dataTypes.sort(DBUtils.nameComparator());
            return dataTypes.toArray(new DBSDataType[0]);
        }
    }

    public static class CommentLoadValidator
    implements IPropertyCacheValidator<OracleTableColumn> {
        public boolean isPropertyCached(@NotNull OracleTableColumn object, @NotNull Object propertyId) {
            return object.comment != null;
        }
    }
}

