/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport.kex;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import java.security.spec.X509EncodedKeySpec;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.SecurityUtils;
import net.schmizz.sshj.transport.kex.DHBase;
import net.schmizz.sshj.transport.random.Random;

public class Curve25519DH
extends DHBase {
    private static final String ALGORITHM = "X25519";
    private static final int KEY_LENGTH = 32;
    private int encodedKeyLength;
    private int algorithmIdLength;
    private byte[] algorithmId = new byte[32];

    public Curve25519DH() {
        super(ALGORITHM, ALGORITHM);
    }

    @Override
    void computeK(byte[] peerPublicKey) throws GeneralSecurityException {
        KeyFactory keyFactory = SecurityUtils.getKeyFactory(ALGORITHM);
        KeySpec peerPublicKeySpec = this.getPeerPublicKeySpec(peerPublicKey);
        PublicKey generatedPeerPublicKey = keyFactory.generatePublic(peerPublicKeySpec);
        this.agreement.doPhase(generatedPeerPublicKey, true);
        byte[] sharedSecretKey = this.agreement.generateSecret();
        BigInteger sharedSecretNumber = new BigInteger(BigInteger.ONE.signum(), sharedSecretKey);
        this.setK(sharedSecretNumber);
    }

    @Override
    public void init(AlgorithmParameterSpec params, Factory<Random> randomFactory) throws GeneralSecurityException {
        KeyPair keyPair = this.generator.generateKeyPair();
        this.agreement.init(keyPair.getPrivate());
        this.setPublicKey(keyPair.getPublic());
    }

    private void setPublicKey(PublicKey publicKey) {
        byte[] encoded = publicKey.getEncoded();
        this.encodedKeyLength = encoded.length;
        this.algorithmIdLength = this.encodedKeyLength - 32;
        this.algorithmId = new byte[this.algorithmIdLength];
        byte[] publicKeyEncoded = new byte[32];
        System.arraycopy(encoded, this.algorithmIdLength, publicKeyEncoded, 0, 32);
        this.setE(publicKeyEncoded);
        System.arraycopy(encoded, 0, this.algorithmId, 0, this.algorithmIdLength);
    }

    private KeySpec getPeerPublicKeySpec(byte[] peerPublicKey) {
        byte[] encodedKeySpec = new byte[this.encodedKeyLength];
        System.arraycopy(this.algorithmId, 0, encodedKeySpec, 0, this.algorithmIdLength);
        System.arraycopy(peerPublicKey, 0, encodedKeySpec, this.algorithmIdLength, 32);
        return new X509EncodedKeySpec(encodedKeySpec);
    }
}

