/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.parser;

import java.util.ArrayList;
import java.util.Collections;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.parser.rules.LineCommentRule;
import org.jkiss.dbeaver.model.sql.parser.rules.NestedMultiLineRule;
import org.jkiss.dbeaver.model.sql.parser.rules.SQLCommandRule;
import org.jkiss.dbeaver.model.sql.parser.rules.SQLDelimiterRule;
import org.jkiss.dbeaver.model.sql.parser.rules.SQLDelimiterSetRule;
import org.jkiss.dbeaver.model.sql.parser.rules.SQLMultilineCommandRule;
import org.jkiss.dbeaver.model.sql.parser.rules.SQLWordRule;
import org.jkiss.dbeaver.model.sql.parser.rules.ScriptParameterRule;
import org.jkiss.dbeaver.model.sql.parser.rules.ScriptVariableRule;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLBlockBeginToken;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLBlockEndToken;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLBlockHeaderToken;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLCommentToken;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLControlToken;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLDelimiterToken;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLMultilineCommentToken;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLParameterToken;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLSetDelimiterToken;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLTokenType;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLVariableToken;
import org.jkiss.dbeaver.model.sql.registry.SQLCommandHandlerDescriptor;
import org.jkiss.dbeaver.model.sql.registry.SQLCommandsRegistry;
import org.jkiss.dbeaver.model.text.parser.TPPredicateRule;
import org.jkiss.dbeaver.model.text.parser.TPRule;
import org.jkiss.dbeaver.model.text.parser.TPRuleProvider;
import org.jkiss.dbeaver.model.text.parser.TPTokenAbstract;
import org.jkiss.dbeaver.model.text.parser.TPTokenDefault;
import org.jkiss.dbeaver.model.text.parser.TPTokenType;
import org.jkiss.dbeaver.model.text.parser.rules.EndOfLineRule;
import org.jkiss.dbeaver.model.text.parser.rules.MultiLineRule;
import org.jkiss.dbeaver.model.text.parser.rules.NumberRule;
import org.jkiss.dbeaver.model.text.parser.rules.WhitespaceRule;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;

public class SQLRuleManager {
    private static final Log log = Log.getLog(SQLRuleManager.class);
    @NotNull
    private TPRule[] allRules = new TPRule[0];
    @NotNull
    private SQLSyntaxManager syntaxManager;
    @Nullable
    private TPRuleProvider ruleProvider;

    public SQLRuleManager(@NotNull SQLSyntaxManager syntaxManager) {
        this.syntaxManager = syntaxManager;
        this.ruleProvider = (TPRuleProvider)GeneralUtils.adapt((Object)syntaxManager.getDialect(), TPRuleProvider.class);
    }

    @NotNull
    public TPRule[] getAllRules() {
        return this.allRules;
    }

    @NotNull
    public TPRule[] getRulesByType(@NotNull SQLTokenType requiredType) {
        ArrayList<TPRule> rules = new ArrayList<TPRule>();
        TPRule[] tPRuleArray = this.allRules;
        int n = this.allRules.length;
        int n2 = 0;
        while (n2 < n) {
            TPTokenAbstract token;
            Object tokenData;
            TPPredicateRule predicateRule;
            TPRule rule = tPRuleArray[n2];
            if (rule instanceof TPPredicateRule && (predicateRule = (TPPredicateRule)rule).getSuccessToken() instanceof TPTokenAbstract && (tokenData = (token = (TPTokenAbstract)predicateRule.getSuccessToken()).getData()) instanceof TPTokenType && ((TPTokenType)tokenData).getTokenType() == requiredType.getTokenType()) {
                rules.add(rule);
            }
            ++n2;
        }
        return rules.toArray(new TPRule[0]);
    }

    public void loadRules() {
        this.loadRules((DBPDataSourceContainer)null, false);
    }

    public void loadRules(@Nullable DBPDataSource dataSource, boolean minimalRules) {
        if (dataSource == null) {
            this.loadRules((DBPDataSourceContainer)null, minimalRules);
        } else {
            this.loadRules(dataSource.getContainer(), minimalRules);
        }
    }

    public void loadRules(@Nullable DBPDataSourceContainer dataSourceContainer, boolean minimalRules) {
        boolean bl;
        Object quotes;
        int n;
        int n2;
        String[][] stringArray;
        SQLDialect dialect = this.syntaxManager.getDialect();
        TPTokenDefault keywordToken = new TPTokenDefault(SQLTokenType.T_KEYWORD);
        TPTokenDefault typeToken = new TPTokenDefault(SQLTokenType.T_TYPE);
        TPTokenDefault functionToken = new TPTokenDefault(SQLTokenType.T_FUNCTION);
        TPTokenDefault stringToken = new TPTokenDefault(SQLTokenType.T_STRING);
        TPTokenDefault quotedToken = new TPTokenDefault(SQLTokenType.T_QUOTED);
        TPTokenDefault numberToken = new TPTokenDefault(SQLTokenType.T_NUMBER);
        SQLCommentToken commentToken = new SQLCommentToken();
        SQLMultilineCommentToken multilineCommentToken = new SQLMultilineCommentToken();
        SQLDelimiterToken delimiterToken = new SQLDelimiterToken();
        SQLParameterToken parameterToken = new SQLParameterToken();
        new SQLVariableToken();
        TPTokenDefault otherToken = new TPTokenDefault(SQLTokenType.T_OTHER);
        SQLBlockHeaderToken blockHeaderToken = new SQLBlockHeaderToken();
        SQLBlockBeginToken blockBeginToken = new SQLBlockBeginToken();
        SQLBlockEndToken blockEndToken = new SQLBlockEndToken();
        ArrayList<TPRule> rules = new ArrayList<TPRule>();
        if (this.ruleProvider != null) {
            Collections.addAll(rules, this.ruleProvider.extendRules(dataSourceContainer, TPRuleProvider.RulePosition.INITIAL));
        }
        if (this.ruleProvider != null) {
            Collections.addAll(rules, this.ruleProvider.extendRules(dataSourceContainer, TPRuleProvider.RulePosition.CONTROL));
        }
        if (!minimalRules) {
            SQLControlToken controlToken = new SQLControlToken();
            try {
                String commandPrefix = this.syntaxManager.getControlCommandPrefix();
                String doubleCommandPrefix = commandPrefix + commandPrefix;
                for (SQLCommandHandlerDescriptor sQLCommandHandlerDescriptor : SQLCommandsRegistry.getInstance().getCommandHandlers()) {
                    rules.add(new SQLCommandRule(commandPrefix, sQLCommandHandlerDescriptor, controlToken));
                    rules.add(new SQLMultilineCommandRule(doubleCommandPrefix, sQLCommandHandlerDescriptor, controlToken));
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        if (!minimalRules) {
            if (this.syntaxManager.isVariablesEnabled()) {
                rules.add(new ScriptVariableRule(parameterToken));
            }
            String[] stringArray2 = this.syntaxManager.getNamedParameterPrefixes();
            int doubleCommandPrefix = stringArray2.length;
            int e = 0;
            while (e < doubleCommandPrefix) {
                String npPrefix = stringArray2[e];
                rules.add(new ScriptParameterRule(this.syntaxManager, parameterToken, npPrefix));
                ++e;
            }
        }
        char escapeChar = this.syntaxManager.getEscapeChar();
        String[][] identifierQuoteStrings232 = this.syntaxManager.getIdentifierQuoteStrings();
        String[][] stringQuoteStrings232 = this.syntaxManager.getStringQuoteStrings();
        boolean bl2 = false;
        if (!ArrayUtils.isEmpty((Object[])identifierQuoteStrings232)) {
            stringArray = identifierQuoteStrings232;
            n2 = identifierQuoteStrings232.length;
            n = 0;
            while (n < n2) {
                quotes = stringArray[n];
                rules.add(new MultiLineRule(quotes[0], quotes[1], quotedToken, escapeChar, true));
                if (quotes[1].equals("\"") && quotes[0].equals(quotes[1])) {
                    bl = true;
                }
                ++n;
            }
        }
        if (!ArrayUtils.isEmpty((Object[])stringQuoteStrings232)) {
            stringArray = stringQuoteStrings232;
            n2 = stringQuoteStrings232.length;
            n = 0;
            while (n < n2) {
                quotes = stringArray[n];
                rules.add(new MultiLineRule(quotes[0], quotes[1], stringToken, escapeChar, true));
                ++n;
            }
        }
        if (!bl) {
            rules.add(new MultiLineRule("\"", "\"", quotedToken, escapeChar, true));
        }
        if (this.ruleProvider != null) {
            Collections.addAll(rules, this.ruleProvider.extendRules(dataSourceContainer, TPRuleProvider.RulePosition.QUOTES));
        }
        String[] stringArray3 = dialect.getSingleLineComments();
        int stringQuoteStrings232 = stringArray3.length;
        int identifierQuoteStrings232 = 0;
        while (identifierQuoteStrings232 < stringQuoteStrings232) {
            String lineComment = stringArray3[identifierQuoteStrings232];
            if (lineComment.startsWith("^")) {
                rules.add(new LineCommentRule(lineComment, commentToken, '\u0000', false, true));
            } else {
                rules.add(new EndOfLineRule(lineComment, commentToken, '\u0000', false, true));
            }
            ++identifierQuoteStrings232;
        }
        Pair multiLineComments = dialect.getMultiLineComments();
        if (multiLineComments != null) {
            rules.add(dialect.supportsNestedComments() ? new NestedMultiLineRule((String)multiLineComments.getFirst(), (String)multiLineComments.getSecond(), multilineCommentToken, '\u0000', true) : new MultiLineRule((String)multiLineComments.getFirst(), (String)multiLineComments.getSecond(), multilineCommentToken, '\u0000', true));
        }
        if (!minimalRules) {
            rules.add(new WhitespaceRule(TPTokenAbstract.WHITESPACE));
            rules.add(new NumberRule(numberToken));
        }
        SQLDelimiterRule delimRule = new SQLDelimiterRule(this.syntaxManager.getStatementDelimiters(), delimiterToken);
        rules.add(delimRule);
        String delimRedefine = dialect.getScriptDelimiterRedefiner();
        if (ArrayUtils.contains((Object[])this.syntaxManager.getStatementDelimiters(), (Object)delimRedefine)) {
            delimRedefine = null;
        }
        if (!CommonUtils.isEmpty((String)delimRedefine)) {
            SQLSetDelimiterToken sQLSetDelimiterToken = new SQLSetDelimiterToken();
            rules.add(0, new SQLDelimiterSetRule(delimRedefine, sQLSetDelimiterToken, delimRule));
        }
        if (this.ruleProvider != null) {
            Collections.addAll(rules, this.ruleProvider.extendRules(dataSourceContainer, TPRuleProvider.RulePosition.KEYWORDS));
        }
        if (!minimalRules) {
            String[][] blockBounds;
            Object[] blockHeaderStrings;
            DBPDataSource dBPDataSource;
            SQLWordRule wordRule = new SQLWordRule(delimRule, functionToken, otherToken, dialect);
            for (String string : dialect.getReservedWords()) {
                DBPKeywordType keywordType = dialect.getKeywordType(string);
                if (keywordType == DBPKeywordType.FUNCTION || keywordType == DBPKeywordType.OTHER) {
                    wordRule.addFunction(string);
                    continue;
                }
                wordRule.addWord(string, keywordToken);
            }
            DBPDataSource dBPDataSource2 = dBPDataSource = dataSourceContainer != null ? dataSourceContainer.getDataSource() : null;
            if (dBPDataSource != null) {
                for (String type : dialect.getDataTypes(dBPDataSource)) {
                    wordRule.addWord(type, typeToken);
                }
                for (String function : dialect.getFunctions()) {
                    wordRule.addFunction(function);
                }
            }
            if (!ArrayUtils.isEmpty((Object[])(blockHeaderStrings = dialect.getBlockHeaderStrings()))) {
                Object[] objectArray = blockHeaderStrings;
                int n3 = blockHeaderStrings.length;
                n2 = 0;
                while (n2 < n3) {
                    Object bhs = objectArray[n2];
                    wordRule.addWord((String)bhs, blockHeaderToken);
                    ++n2;
                }
            }
            if ((blockBounds = dialect.getBlockBoundStrings()) != null) {
                String[][] stringArray4 = blockBounds;
                int n4 = blockBounds.length;
                int n5 = 0;
                while (n5 < n4) {
                    String[] block = stringArray4[n5];
                    if (block.length == 2) {
                        wordRule.addWord(block[0], blockBeginToken);
                        wordRule.addWord(block[1], blockEndToken);
                    }
                    ++n5;
                }
            }
            rules.add(wordRule);
        }
        if (this.ruleProvider != null) {
            Collections.addAll(rules, this.ruleProvider.extendRules(dataSourceContainer, TPRuleProvider.RulePosition.FINAL));
        }
        this.allRules = rules.toArray(new TPRule[0]);
    }
}

