/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.BlockRevQueue;
import org.eclipse.jgit.revwalk.DepthWalk;
import org.eclipse.jgit.revwalk.FIFORevQueue;
import org.eclipse.jgit.revwalk.Generator;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevWalk;

class DepthGenerator
extends Generator {
    private final FIFORevQueue pending;
    private final int depth;
    private final int deepenSince;
    private final RevWalk walk;
    private final RevFlag UNSHALLOW;
    private final RevFlag REINTERESTING;
    private final RevFlag DEEPEN_NOT;

    DepthGenerator(DepthWalk w, Generator s2) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        super(s2.firstParent);
        RevCommit c;
        this.pending = new FIFORevQueue(this.firstParent);
        this.walk = (RevWalk)((Object)w);
        this.depth = w.getDepth();
        this.deepenSince = w.getDeepenSince();
        this.UNSHALLOW = w.getUnshallowFlag();
        this.REINTERESTING = w.getReinterestingFlag();
        this.DEEPEN_NOT = w.getDeepenNotFlag();
        s2.shareFreeList(this.pending);
        FIFORevQueue unshallowCommits = new FIFORevQueue();
        while ((c = s2.next()) != null) {
            if (c.has(this.UNSHALLOW)) {
                unshallowCommits.add(c);
                continue;
            }
            if (((DepthWalk.Commit)c).getDepth() != 0) continue;
            this.pending.add(c);
        }
        while ((c = unshallowCommits.next()) != null) {
            this.pending.unpop(c);
        }
        for (ObjectId oid : w.getDeepenNots()) {
            RevCommit c2;
            try {
                c2 = this.walk.parseCommit(oid);
            }
            catch (IncorrectObjectTypeException notCommit) {
                continue;
            }
            FIFORevQueue queue = new FIFORevQueue();
            queue.add(c2);
            while ((c2 = queue.next()) != null) {
                if (c2.has(this.DEEPEN_NOT)) continue;
                this.walk.parseHeaders(c2);
                c2.add(this.DEEPEN_NOT);
                RevCommit[] revCommitArray = c2.getParents();
                int n = revCommitArray.length;
                int n2 = 0;
                while (n2 < n) {
                    RevCommit p = revCommitArray[n2];
                    queue.add(p);
                    ++n2;
                }
            }
        }
    }

    @Override
    int outputType() {
        return this.pending.outputType() | 0x10;
    }

    @Override
    void shareFreeList(BlockRevQueue q) {
        this.pending.shareFreeList(q);
    }

    @Override
    RevCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        DepthWalk.Commit c;
        while (true) {
            if ((c = (DepthWalk.Commit)this.pending.next()) == null) {
                return null;
            }
            if ((c.flags & 1) == 0) {
                c.parseHeaders(this.walk);
            }
            if (c.getCommitTime() < this.deepenSince || c.has(this.DEEPEN_NOT)) continue;
            int newDepth = c.depth + 1;
            int n = c.getParentCount();
            int i = 0;
            while (i < n) {
                if (this.firstParent && i > 0) break;
                RevCommit p = c.getParent(i);
                DepthWalk.Commit dp = (DepthWalk.Commit)p;
                if (dp.depth == -1) {
                    boolean failsDeepenSince = false;
                    if (this.deepenSince != 0) {
                        if ((p.flags & 1) == 0) {
                            p.parseHeaders(this.walk);
                        }
                        failsDeepenSince = p.getCommitTime() < this.deepenSince;
                    }
                    dp.depth = newDepth;
                    if (newDepth <= this.depth && !failsDeepenSince && !p.has(this.DEEPEN_NOT)) {
                        this.pending.add(p);
                    } else {
                        dp.makesChildBoundary = true;
                    }
                }
                if (dp.makesChildBoundary) {
                    c.isBoundary = true;
                }
                if (c.has(this.UNSHALLOW) || c.has(this.REINTERESTING)) {
                    p.add(this.REINTERESTING);
                    p.flags &= 0xFFFFFFFB;
                }
                ++i;
            }
            boolean produce = true;
            if ((c.flags & 4) != 0 && !c.has(this.UNSHALLOW)) {
                produce = false;
            }
            if (c.getCommitTime() < this.deepenSince) {
                produce = false;
            }
            if (produce) break;
        }
        return c;
    }
}

