/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui;

import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComboBox;
import javax.swing.plaf.basic.BasicComboPopup;
import org.basex.core.parse.CommandParser;
import org.basex.data.Data;
import org.basex.gui.GUI;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXWindow;
import org.basex.query.QueryContext;
import org.basex.util.Strings;
import org.basex.util.list.ObjectList;
import org.basex.util.list.StringList;

public final class GUIInput
extends BaseXCombo {
    private final GUI gui;
    private final BaseXCombo completions;
    private GUIInputPopup popup;
    private String prefix = "";

    GUIInput(final GUI main) {
        super((BaseXWindow)main, true, new String[0]);
        this.gui = main;
        BaseXLayout.resizeFont(this, 1.3f);
        this.completions = new BaseXCombo((BaseXWindow)main, new String[0]);
        this.completions.addActionListener(e -> this.completeInput());
        this.popup = new GUIInputPopup(this.completions);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (BaseXKeys.ESCAPE.is(e)) {
                    GUIInput.this.popup.setVisible(false);
                } else if (BaseXKeys.ENTER.is(e)) {
                    if (GUIInput.this.popup.isVisible()) {
                        GUIInput.this.completeInput();
                        GUIInput.this.popup.setVisible(false);
                    } else {
                        GUIInput.this.updateHistory();
                        if (e.getModifiersEx() == 0) {
                            GUIInput.this.gui.execute();
                        }
                    }
                }
                int count = GUIInput.this.completions.getItemCount();
                if (count == 0) {
                    return;
                }
                int bi = GUIInput.this.completions.getSelectedIndex();
                if (BaseXKeys.NEXTLINE.is(e)) {
                    if (GUIInput.this.popup.isVisible()) {
                        if (++bi == count) {
                            bi = 0;
                        }
                    } else {
                        GUIInput.this.popupMenu();
                    }
                } else if (BaseXKeys.PREVLINE.is(e)) {
                    if (GUIInput.this.popup.isVisible()) {
                        if (--bi < 0) {
                            bi = count - 1;
                        }
                    } else {
                        GUIInput.this.popupMenu();
                    }
                }
                if (bi != GUIInput.this.completions.getSelectedIndex()) {
                    GUIInput.this.completions.setSelectedIndex(bi);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (!BaseXKeys.NEXTLINE.is(e) && !BaseXKeys.PREVLINE.is(e)) {
                    if (BaseXKeys.modifier(e) || BaseXKeys.control(e)) {
                        return;
                    }
                    GUIInput.this.popupMenu();
                    if (GUIInput.this.gui.gopts.get(GUIOptions.EXECRT).booleanValue() && !GUIInput.this.cmdMode()) {
                        main.execute();
                    }
                }
            }
        });
    }

    @Override
    public void setText(String txt) {
        super.setText(txt);
        this.completions.removeAllItems();
        this.popup.setVisible(false);
    }

    void mode(String mode) {
        int i;
        this.hint(mode + "...").setText("");
        Data data = this.gui.context.data();
        int n = i = data == null ? 2 : this.gui.gopts.get(GUIOptions.SEARCHMODE);
        this.history(i == 0 ? GUIOptions.SEARCH : (i == 1 ? GUIOptions.XQUERY : GUIOptions.COMMANDS), this.gui.gopts);
    }

    private boolean cmdMode() {
        int mode = this.gui.gopts.get(GUIOptions.SEARCHMODE);
        return mode == 2 || this.gui.context.data() == null;
    }

    private boolean queryMode() {
        int mode = this.gui.gopts.get(GUIOptions.SEARCHMODE);
        return mode == 1 || mode == 0 && Strings.startsWith(this.getText(), '/');
    }

    private void completeInput() {
        int ll;
        String suffix = this.completions.getSelectedItem();
        if (suffix.isEmpty()) {
            return;
        }
        int pl = this.prefix.length();
        int n = ll = pl > 0 ? (int)this.prefix.charAt(pl - 1) : 32;
        if (Character.isLetter(ll) && Character.isLetter(suffix.charAt(0))) {
            this.prefix = this.prefix + " ";
        }
        this.setText(this.prefix + suffix);
        this.popupMenu();
        if (this.gui.gopts.get(GUIOptions.EXECRT).booleanValue() && !this.cmdMode()) {
            this.gui.execute();
        }
    }

    private void popupMenu() {
        String query = this.getText();
        ObjectList list = null;
        if (this.textField().getCaretPosition() == query.length()) {
            Data data = this.gui.context.data();
            if (this.queryMode() && data != null) {
                try (QueryContext qc = new QueryContext(this.gui.context);){
                    list = qc.suggest(query, data);
                }
            } else if (this.cmdMode()) {
                list = CommandParser.get(query, this.gui.context).suggest();
            }
        }
        if (list != null) {
            this.prefix = (String)list.pop();
            this.createCombo((StringList)list);
        } else {
            this.popup.setVisible(false);
        }
    }

    private void createCombo(StringList sl) {
        if (sl == null || sl.isEmpty()) {
            this.popup.setVisible(false);
            return;
        }
        if (this.completionsChanged(sl)) {
            this.completions.setItems((String[])sl.toArray());
            this.completions.setSelectedIndex(-1);
            this.popup = new GUIInputPopup(this.completions);
        }
        int w = this.getFontMetrics(this.getFont()).stringWidth(this.prefix);
        this.popup.show(this, Math.min(this.getWidth(), w), this.getHeight());
    }

    private boolean completionsChanged(StringList list) {
        int ls = list.size();
        if (ls != this.completions.getItemCount()) {
            return true;
        }
        for (int l = 0; l < ls; ++l) {
            if (((String)list.get(l)).equals(this.completions.getItemAt(l))) continue;
            return true;
        }
        return false;
    }

    private static final class GUIInputPopup
    extends BasicComboPopup {
        GUIInputPopup(JComboBox<Object> combo) {
            super(combo);
            int h = combo.getMaximumRowCount();
            this.setPreferredSize(new Dimension(this.getPreferredSize().width, this.getPopupHeightForRowCount(h) + 2));
        }
    }
}

