/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.engine;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.jcs3.engine.ZombieCacheService;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.behavior.ICacheServiceNonLocal;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;
import org.apache.commons.jcs3.utils.timing.ElapsedTimer;

public class ZombieCacheServiceNonLocal<K, V>
extends ZombieCacheService<K, V>
implements ICacheServiceNonLocal<K, V> {
    private static final Log log = LogManager.getLog(ZombieCacheServiceNonLocal.class);
    private int maxQueueSize;
    private final ConcurrentLinkedQueue<ZombieEvent> queue = new ConcurrentLinkedQueue();

    public ZombieCacheServiceNonLocal() {
    }

    public ZombieCacheServiceNonLocal(int maxQueueSize) {
        this();
        this.maxQueueSize = maxQueueSize;
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    private void addQueue(ZombieEvent event) {
        this.queue.add(event);
        if (this.queue.size() > this.maxQueueSize) {
            this.queue.poll();
        }
    }

    @Override
    public void update(ICacheElement<K, V> item, long listenerId) {
        if (this.maxQueueSize > 0) {
            PutEvent<K, V> event = new PutEvent<K, V>(item, listenerId);
            this.addQueue(event);
        }
    }

    @Override
    public void remove(String cacheName, K key, long listenerId) {
        if (this.maxQueueSize > 0) {
            RemoveEvent<K> event = new RemoveEvent<K>(cacheName, key, listenerId);
            this.addQueue(event);
        }
    }

    @Override
    public void removeAll(String cacheName, long listenerId) {
        if (this.maxQueueSize > 0) {
            RemoveAllEvent event = new RemoveAllEvent(cacheName, listenerId);
            this.addQueue(event);
        }
    }

    @Override
    public ICacheElement<K, V> get(String cacheName, K key, long requesterId) throws IOException {
        return null;
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMatching(String cacheName, String pattern, long requesterId) throws IOException {
        return Collections.emptyMap();
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMultiple(String cacheName, Set<K> keys, long requesterId) {
        return new HashMap();
    }

    @Override
    public Set<K> getKeySet(String cacheName) {
        return Collections.emptySet();
    }

    public synchronized void propagateEvents(ICacheServiceNonLocal<K, V> service) throws Exception {
        int cnt = 0;
        log.info("Propagating events to the new ICacheServiceNonLocal.");
        ElapsedTimer timer = new ElapsedTimer();
        while (!this.queue.isEmpty()) {
            ++cnt;
            ZombieEvent event = this.queue.poll();
            if (event instanceof PutEvent) {
                PutEvent putEvent = (PutEvent)event;
                service.update(putEvent.element, event.requesterId);
                continue;
            }
            if (event instanceof RemoveEvent) {
                RemoveEvent removeEvent = (RemoveEvent)event;
                service.remove(event.cacheName, removeEvent.key, event.requesterId);
                continue;
            }
            if (!(event instanceof RemoveAllEvent)) continue;
            service.removeAll(event.cacheName, event.requesterId);
        }
        log.info("Propagated {0} events to the new ICacheServiceNonLocal in {1}", cnt, timer.getElapsedTimeString());
    }

    private static class PutEvent<K, V>
    extends ZombieEvent {
        final ICacheElement<K, V> element;

        public PutEvent(ICacheElement<K, V> element, long requesterId) {
            this.requesterId = requesterId;
            this.element = element;
        }
    }

    protected static abstract class ZombieEvent {
        String cacheName;
        long requesterId;

        protected ZombieEvent() {
        }
    }

    private static class RemoveEvent<K>
    extends ZombieEvent {
        final K key;

        public RemoveEvent(String cacheName, K key, long requesterId) {
            this.cacheName = cacheName;
            this.requesterId = requesterId;
            this.key = key;
        }
    }

    private static class RemoveAllEvent
    extends ZombieEvent {
        public RemoveAllEvent(String cacheName, long requesterId) {
            this.cacheName = cacheName;
            this.requesterId = requesterId;
        }
    }
}

