/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.lateral.socket.tcp;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import org.apache.commons.jcs3.auxiliary.lateral.LateralCacheNoWait;
import org.apache.commons.jcs3.auxiliary.lateral.LateralCacheNoWaitFacade;
import org.apache.commons.jcs3.auxiliary.lateral.socket.tcp.LateralTCPCacheFactory;
import org.apache.commons.jcs3.auxiliary.lateral.socket.tcp.behavior.ITCPLateralCacheAttributes;
import org.apache.commons.jcs3.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.engine.control.CompositeCacheManager;
import org.apache.commons.jcs3.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;
import org.apache.commons.jcs3.utils.discovery.DiscoveredService;
import org.apache.commons.jcs3.utils.discovery.behavior.IDiscoveryListener;

public class LateralTCPDiscoveryListener
implements IDiscoveryListener {
    private static final Log log = LogManager.getLog(LateralTCPDiscoveryListener.class);
    private final ConcurrentMap<String, LateralCacheNoWaitFacade<?, ?>> facades = new ConcurrentHashMap();
    private final CopyOnWriteArrayList<String> knownDifferentlyConfiguredRegions = new CopyOnWriteArrayList();
    private final String factoryName;
    private final CompositeCacheManager cacheManager;
    private final ICacheEventLogger cacheEventLogger;
    private final IElementSerializer elementSerializer;

    @Deprecated
    protected LateralTCPDiscoveryListener(String factoryName, ICompositeCacheManager cacheManager) {
        this(factoryName, (CompositeCacheManager)cacheManager, null, null);
    }

    protected LateralTCPDiscoveryListener(String factoryName, CompositeCacheManager cacheManager, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        this.factoryName = factoryName;
        this.cacheManager = cacheManager;
        this.cacheEventLogger = cacheEventLogger;
        this.elementSerializer = elementSerializer;
    }

    public boolean addNoWaitFacade(String cacheName, LateralCacheNoWaitFacade<?, ?> facade) {
        boolean isNew = !this.containsNoWaitFacade(cacheName);
        this.facades.put(cacheName, facade);
        this.knownDifferentlyConfiguredRegions.remove(cacheName);
        return isNew;
    }

    public boolean containsNoWaitFacade(String cacheName) {
        return this.facades.containsKey(cacheName);
    }

    public <K, V> boolean containsNoWait(String cacheName, LateralCacheNoWait<K, V> noWait) {
        LateralCacheNoWaitFacade facade = (LateralCacheNoWaitFacade)this.facades.get(noWait.getCacheName());
        if (facade == null) {
            return false;
        }
        return facade.containsNoWait(noWait);
    }

    protected <K, V> boolean addNoWait(LateralCacheNoWait<K, V> noWait) {
        LateralCacheNoWaitFacade facade = (LateralCacheNoWaitFacade)this.facades.get(noWait.getCacheName());
        log.debug("addNoWait > Got facade for {0} = {1}", noWait.getCacheName(), facade);
        return this.addNoWait(noWait, facade);
    }

    protected <K, V> boolean addNoWait(LateralCacheNoWait<K, V> noWait, LateralCacheNoWaitFacade<K, V> facade) {
        if (facade != null) {
            boolean isNew = facade.addNoWait(noWait);
            log.debug("Called addNoWait, isNew = {0}", isNew);
            return isNew;
        }
        if (this.knownDifferentlyConfiguredRegions.addIfAbsent(noWait.getCacheName())) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = noWait::getCacheName;
            log.info("addNoWait > Different nodes are configured differently or region [{0}] is not yet used on this side.", supplierArray);
        }
        return false;
    }

    protected <K, V> boolean removeNoWait(LateralCacheNoWait<K, V> noWait) {
        LateralCacheNoWaitFacade facade = (LateralCacheNoWaitFacade)this.facades.get(noWait.getCacheName());
        log.debug("removeNoWait > Got facade for {0} = {1}", noWait.getCacheName(), facade);
        return this.removeNoWait(facade, noWait.getCacheName(), noWait.getIdentityKey());
    }

    protected <K, V> boolean removeNoWait(LateralCacheNoWaitFacade<K, V> facade, String cacheName, String tcpServer) {
        if (facade != null) {
            boolean removed = facade.removeNoWait(tcpServer);
            log.debug("Called removeNoWait, removed {0}", removed);
            return removed;
        }
        if (this.knownDifferentlyConfiguredRegions.addIfAbsent(cacheName)) {
            log.info("addNoWait > Different nodes are configured differently or region [{0}] is not yet used on this side.", cacheName);
        }
        return false;
    }

    @Override
    public void addDiscoveredService(DiscoveredService service) {
        ArrayList<String> regions = service.getCacheNames();
        String serverAndPort = service.getServiceAddress() + ":" + service.getServicePort();
        if (regions != null) {
            for (String cacheName : regions) {
                LateralCacheNoWaitFacade facade = (LateralCacheNoWaitFacade)this.facades.get(cacheName);
                log.debug("Got cache facade {0}", facade);
                if (facade == null || facade.containsNoWait(serverAndPort)) continue;
                ITCPLateralCacheAttributes lca = (ITCPLateralCacheAttributes)facade.getAuxiliaryCacheAttributes().clone();
                lca.setTcpServer(serverAndPort);
                LateralTCPCacheFactory factory = (LateralTCPCacheFactory)this.cacheManager.registryFacGet(this.factoryName);
                LateralCacheNoWait noWait = factory.createCacheNoWait(lca, this.cacheEventLogger, this.elementSerializer);
                factory.monitorCache(noWait);
                if (!this.addNoWait(noWait)) continue;
                log.debug("Added NoWait for cacheName [{0}] at {1}", cacheName, serverAndPort);
            }
        } else {
            log.warn("No cache names found in message {0}", service);
        }
    }

    @Override
    public void removeDiscoveredService(DiscoveredService service) {
        ArrayList<String> regions = service.getCacheNames();
        String serverAndPort = service.getServiceAddress() + ":" + service.getServicePort();
        if (regions != null) {
            for (String cacheName : regions) {
                LateralCacheNoWaitFacade facade = (LateralCacheNoWaitFacade)this.facades.get(cacheName);
                log.debug("Got cache facade {0}", facade);
                if (facade == null || !this.removeNoWait(facade, cacheName, serverAndPort)) continue;
                log.debug("Removed NoWait for cacheName [{0}] at {1}", cacheName, serverAndPort);
            }
        } else {
            log.warn("No cache names found in message {0}", service);
        }
    }
}

