;; The $Tester component has two nested components $C and $D, where $D imports
;; and calls $C. $C contains utilities used by $D to perform all the tests.
;; Most of the tests trap, $Tester exports 1 function per test and a fresh
;; $Tester is created to run each test.
(component definition $Tester
  (component $C
    (core module $CM
      (func (export "sync-async-func")
        unreachable
      )
      (func (export "async-async-func") (result i32)
        unreachable
      )
      (func (export "async-async-func-cb") (param i32 i32 i32) (result i32)
        unreachable
      )
    )
    (core instance $cm (instantiate $CM))
    (func (export "sync-async-func") async (canon lift (core func $cm "sync-async-func")))
    (func (export "async-async-func") async (canon lift (core func $cm "async-async-func") async (callback (func $cm "async-async-func-cb"))))
  )
  (component $D
    (import "c" (instance $c
      (export "sync-async-func" (func async))
      (export "async-async-func" (func async))
    ))

    (core module $Memory (memory (export "mem") 1))
    (core instance $memory (instantiate $Memory))
    (core module $Core
      (import "" "mem" (memory 1))
      (import "" "task.return" (func $task.return (param i32)))
      (import "" "subtask.cancel" (func $subtask.cancel (param i32) (result i32)))
      (import "" "thread.yield" (func $thread.yield (result i32)))
      (import "" "thread.suspend" (func $thread.suspend (result i32)))
      (import "" "waitable.join" (func $waitable.join (param i32 i32)))
      (import "" "waitable-set.new" (func $waitable-set.new (result i32)))
      (import "" "waitable-set.wait" (func $waitable-set.wait (param i32 i32) (result i32)))
      (import "" "waitable-set.poll" (func $waitable-set.poll (param i32 i32) (result i32)))
      (import "" "stream.read" (func $stream.read (param i32 i32 i32) (result i32)))
      (import "" "stream.write" (func $stream.write (param i32 i32 i32) (result i32)))
      (import "" "future.read" (func $future.read (param i32 i32) (result i32)))
      (import "" "future.write" (func $future.write (param i32 i32) (result i32)))
      (import "" "stream.cancel-read" (func $stream.cancel-read (param i32) (result i32)))
      (import "" "stream.cancel-write" (func $stream.cancel-write (param i32) (result i32)))
      (import "" "future.cancel-read" (func $future.cancel-read (param i32) (result i32)))
      (import "" "future.cancel-write" (func $future.cancel-write (param i32) (result i32)))
      (import "" "await-sync-async-func" (func $await-sync-async-func))
      (import "" "await-async-async-func" (func $await-async-async-func))

      (func (export "unreachable-cb") (param i32 i32 i32) (result i32)
        unreachable
      )
      (func (export "return-42-cb") (param i32 i32 i32) (result i32)
        (call $task.return (i32.const 42))
        (i32.const 0 (; EXIT ;))
      )

      (func (export "trap-if-sync-call-async1")
        (call $await-sync-async-func)
      )
      (func (export "trap-if-sync-call-async2")
        (call $await-async-async-func)
      )
      (func (export "trap-if-suspend")
        (call $thread.suspend)
        unreachable
      )
      (func (export "trap-if-wait")
        (call $waitable-set.wait (call $waitable-set.new) (i32.const 0xdeadbeef))
        unreachable
      )
      (func (export "trap-if-wait-cb") (result i32)
        (i32.or
          (i32.const 2 (; WAIT ;))
          (i32.shl (call $waitable-set.new) (i32.const 4)))
      )
      (func (export "poll-is-fine") (result i32)
        (local $ret i32)
        (local.set $ret (call $waitable-set.poll (call $waitable-set.new) (i32.const 0)))
        (if (i32.ne (i32.const 0 (; NONE ;)) (local.get $ret))
          (then unreachable))
        (if (i32.ne (i32.const 0) (i32.load (i32.const 0)))
          (then unreachable))
        (if (i32.ne (i32.const 0) (i32.load (i32.const 4)))
          (then unreachable))
        (i32.const 42)
      )
      (func (export "trap-if-invalid-callback-code") (param $invalid-code i32) (result i32)
        (i32.or
          (local.get $invalid-code)
          (i32.shl (call $waitable-set.new) (i32.const 4)))
      )
      (func (export "yield-is-fine") (result i32)
        (drop (call $thread.yield))
        (i32.const 42)
      )
      (func (export "yield-is-fine-cb") (result i32)
        (i32.or
          (i32.const 1 (; YIELD ;))
          (i32.shl (i32.const 0xdead) (i32.const 4)))
      )
      (func (export "trap-if-sync-cancel")
        (call $subtask.cancel (i32.const 0xdeadbeef))
        unreachable
      )
      (func (export "trap-if-sync-stream-read")
        (call $stream.read (i32.const 0xdead) (i32.const 0xbeef) (i32.const 0xdeadbeef))
        unreachable
      )
      (func (export "trap-if-sync-stream-write")
        (call $stream.write (i32.const 0xdead) (i32.const 0xbeef) (i32.const 0xdeadbeef))
        unreachable
      )
      (func (export "trap-if-sync-future-read")
        (call $future.read (i32.const 0xdead) (i32.const 0xdeadbeef))
        unreachable
      )
      (func (export "trap-if-sync-future-write")
        (call $future.write (i32.const 0xdead) (i32.const 0xdeadbeef))
        unreachable
      )
      (func (export "trap-if-sync-stream-cancel-read")
        (call $stream.cancel-read (i32.const 0xdead))
        unreachable
      )
      (func (export "trap-if-sync-stream-cancel-write")
        (call $stream.cancel-write (i32.const 0xdead))
        unreachable
      )
      (func (export "trap-if-sync-future-cancel-read")
        (call $future.cancel-read (i32.const 0xdead) (i32.const 0xdeadbeef))
        unreachable
      )
      (func (export "trap-if-sync-future-cancel-write")
        (call $future.cancel-write (i32.const 0xdead) (i32.const 0xdeadbeef))
        unreachable
      )
    )
    (type $FT (future u8))
    (type $ST (stream u8))
    (canon task.return (result u32) (core func $task.return))
    (canon subtask.cancel (core func $subtask.cancel))
    (canon thread.yield (core func $thread.yield))
    (canon thread.suspend (core func $thread.suspend))
    (canon waitable.join (core func $waitable.join))
    (canon waitable-set.new (core func $waitable-set.new))
    (canon waitable-set.wait (memory $memory "mem") (core func $waitable-set.wait))
    (canon waitable-set.poll (memory $memory "mem") (core func $waitable-set.poll))
    (canon stream.read $ST (memory $memory "mem") (core func $stream.read))
    (canon stream.write $ST (memory $memory "mem") (core func $stream.write))
    (canon future.read $FT (memory $memory "mem") (core func $future.read))
    (canon future.write $FT (memory $memory "mem") (core func $future.write))
    (canon stream.cancel-read $ST (core func $stream.cancel-read))
    (canon stream.cancel-write $ST (core func $stream.cancel-write))
    (canon future.cancel-read $FT (core func $future.cancel-read))
    (canon future.cancel-write $FT (core func $future.cancel-write))
    (canon lower (func $c "sync-async-func") (core func $await-sync-async-func'))
    (canon lower (func $c "async-async-func") (core func $await-async-async-func'))
    (core instance $core (instantiate $Core (with "" (instance
      (export "mem" (memory $memory "mem"))
      (export "task.return" (func $task.return))
      (export "subtask.cancel" (func $subtask.cancel))
      (export "thread.yield" (func $thread.yield))
      (export "thread.suspend" (func $thread.suspend))
      (export "waitable.join" (func $waitable.join))
      (export "waitable-set.new" (func $waitable-set.new))
      (export "waitable-set.wait" (func $waitable-set.wait))
      (export "waitable-set.poll" (func $waitable-set.poll))
      (export "stream.read" (func $stream.read))
      (export "stream.write" (func $stream.write))
      (export "future.read" (func $future.read))
      (export "future.write" (func $future.write))
      (export "stream.cancel-read" (func $stream.cancel-read))
      (export "stream.cancel-write" (func $stream.cancel-write))
      (export "future.cancel-read" (func $future.cancel-read))
      (export "future.cancel-write" (func $future.cancel-write))
      (export "await-sync-async-func" (func $await-sync-async-func'))
      (export "await-async-async-func" (func $await-async-async-func'))
    ))))
    (func (export "trap-if-suspend") (canon lift (core func $core "trap-if-suspend")))
    (func (export "trap-if-wait") (canon lift (core func $core "trap-if-wait")))
    (func (export "trap-if-wait-cb") (canon lift (core func $core "trap-if-wait-cb") async (callback (func $core "unreachable-cb"))))
    (func (export "poll-is-fine") (result u32) (canon lift (core func $core "poll-is-fine")))
    (func (export "trap-if-invalid-callback-code") (param "invalid-code" u32) (canon lift (core func $core "trap-if-invalid-callback-code") async (callback (func $core "unreachable-cb"))))
    (func (export "yield-is-fine") (result u32) (canon lift (core func $core "yield-is-fine")))
    (func (export "yield-is-fine-cb") (result u32) (canon lift (core func $core "yield-is-fine-cb") async (callback (func $core "return-42-cb"))))
    (func (export "trap-if-sync-call-async1") (canon lift (core func $core "trap-if-sync-call-async1")))
    (func (export "trap-if-sync-call-async2") (canon lift (core func $core "trap-if-sync-call-async2")))
    (func (export "trap-if-sync-cancel") (canon lift (core func $core "trap-if-sync-cancel")))
    (func (export "trap-if-sync-stream-read") (canon lift (core func $core "trap-if-sync-stream-read")))
    (func (export "trap-if-sync-stream-write") (canon lift (core func $core "trap-if-sync-stream-write")))
    (func (export "trap-if-sync-future-read") (canon lift (core func $core "trap-if-sync-future-read")))
    (func (export "trap-if-sync-future-write") (canon lift (core func $core "trap-if-sync-future-write")))
    (func (export "trap-if-sync-stream-cancel-read") (canon lift (core func $core "trap-if-sync-stream-cancel-read")))
    (func (export "trap-if-sync-stream-cancel-write") (canon lift (core func $core "trap-if-sync-stream-cancel-write")))
    (func (export "trap-if-sync-future-cancel-read") (canon lift (core func $core "trap-if-sync-future-cancel-read")))
    (func (export "trap-if-sync-future-cancel-write") (canon lift (core func $core "trap-if-sync-future-cancel-write")))
  )
  (instance $c (instantiate $C))
  (instance $d (instantiate $D (with "c" (instance $c))))
  (func (export "trap-if-sync-call-async1") (alias export $d "trap-if-sync-call-async1"))
  (func (export "trap-if-sync-call-async2") (alias export $d "trap-if-sync-call-async2"))
  (func (export "trap-if-suspend") (alias export $d "trap-if-suspend"))
  (func (export "trap-if-wait") (alias export $d "trap-if-wait"))
  (func (export "trap-if-wait-cb") (alias export $d "trap-if-wait-cb"))
  (func (export "poll-is-fine") (alias export $d "poll-is-fine"))
  (func (export "trap-if-invalid-callback-code") (alias export $d "trap-if-invalid-callback-code"))
  (func (export "yield-is-fine") (alias export $d "yield-is-fine"))
  (func (export "yield-is-fine-cb") (alias export $d "yield-is-fine-cb"))
  (func (export "trap-if-sync-cancel") (alias export $d "trap-if-sync-cancel"))
  (func (export "trap-if-sync-stream-read") (alias export $d "trap-if-sync-stream-read"))
  (func (export "trap-if-sync-stream-write") (alias export $d "trap-if-sync-stream-write"))
  (func (export "trap-if-sync-future-read") (alias export $d "trap-if-sync-future-read"))
  (func (export "trap-if-sync-future-write") (alias export $d "trap-if-sync-future-write"))
  (func (export "trap-if-sync-stream-cancel-read") (alias export $d "trap-if-sync-stream-cancel-read"))
  (func (export "trap-if-sync-stream-cancel-write") (alias export $d "trap-if-sync-stream-cancel-write"))
  (func (export "trap-if-sync-future-cancel-read") (alias export $d "trap-if-sync-future-cancel-read"))
  (func (export "trap-if-sync-future-cancel-write") (alias export $d "trap-if-sync-future-cancel-write"))
)

(component instance $i $Tester)
(assert_trap (invoke "trap-if-sync-call-async1") "cannot block a synchronous task before returning")
(component instance $i $Tester)
(assert_trap (invoke "trap-if-sync-call-async2") "cannot block a synchronous task before returning")
(component instance $i $Tester)
(assert_trap (invoke "trap-if-suspend") "cannot block a synchronous task before returning")
(component instance $i $Tester)
(assert_trap (invoke "trap-if-wait") "cannot block a synchronous task before returning")
(component instance $i $Tester)
(assert_trap (invoke "trap-if-wait-cb") "cannot block a synchronous task before returning")
(component instance $i $Tester)
(assert_return (invoke "poll-is-fine") (u32.const 42))
(component instance $i $Tester)
(assert_trap (invoke "trap-if-invalid-callback-code" (u32.const 3)) "unsupported callback code: 3")
(component instance $i $Tester)
(assert_trap (invoke "trap-if-invalid-callback-code" (u32.const 4)) "unsupported callback code: 4")
(component instance $i $Tester)
(assert_trap (invoke "trap-if-invalid-callback-code" (u32.const 15)) "unsupported callback code: 15")
(component instance $i $Tester)
(assert_return (invoke "yield-is-fine") (u32.const 42))
(component instance $i $Tester)
(assert_return (invoke "yield-is-fine-cb") (u32.const 42))
(component instance $i $Tester)
(assert_trap (invoke "trap-if-sync-cancel") "cannot block a synchronous task before returning")
(component instance $i $Tester)
(assert_trap (invoke "trap-if-sync-stream-read") "cannot block a synchronous task before returning")
(component instance $i $Tester)
(assert_trap (invoke "trap-if-sync-stream-write") "cannot block a synchronous task before returning")
(component instance $i $Tester)
(assert_trap (invoke "trap-if-sync-future-read") "cannot block a synchronous task before returning")
(component instance $i $Tester)
(assert_trap (invoke "trap-if-sync-future-write") "cannot block a synchronous task before returning")
(component instance $i $Tester)
(assert_trap (invoke "trap-if-sync-stream-cancel-read") "cannot block a synchronous task before returning")
(component instance $i $Tester)
(assert_trap (invoke "trap-if-sync-stream-cancel-write") "cannot block a synchronous task before returning")
(component instance $i $Tester)
(assert_trap (invoke "trap-if-sync-future-cancel-read") "cannot block a synchronous task before returning")
(component instance $i $Tester)
(assert_trap (invoke "trap-if-sync-future-cancel-write") "cannot block a synchronous task before returning")
