(module
  (table $t64 i64 0 externref)

  (func (export "get-t64") (param $i i64) (result externref) (table.get $t64 (local.get $i)))
  (func (export "set-t64") (param $i i64) (param $r externref) (table.set $t64 (local.get $i) (local.get $r)))
  (func (export "grow-t64") (param $sz i64) (param $init externref) (result i64)
    (table.grow $t64 (local.get $init) (local.get $sz))
  )
  (func (export "size-t64") (result i64) (table.size $t64))
)

(assert_return (invoke "size-t64") (i64.const 0))
(assert_trap (invoke "set-t64" (i64.const 0) (ref.extern 2)) "out of bounds table access")
(assert_trap (invoke "get-t64" (i64.const 0)) "out of bounds table access")

(assert_return (invoke "grow-t64" (i64.const 1) (ref.null extern)) (i64.const 0))
(assert_return (invoke "size-t64") (i64.const 1))
(assert_return (invoke "get-t64" (i64.const 0)) (ref.null extern))
(assert_return (invoke "set-t64" (i64.const 0) (ref.extern 2)))
(assert_return (invoke "get-t64" (i64.const 0)) (ref.extern 2))
(assert_trap (invoke "set-t64" (i64.const 1) (ref.extern 2)) "out of bounds table access")
(assert_trap (invoke "get-t64" (i64.const 1)) "out of bounds table access")

(assert_return (invoke "grow-t64" (i64.const 4) (ref.extern 3)) (i64.const 1))
(assert_return (invoke "size-t64") (i64.const 5))
(assert_return (invoke "get-t64" (i64.const 0)) (ref.extern 2))
(assert_return (invoke "set-t64" (i64.const 0) (ref.extern 2)))
(assert_return (invoke "get-t64" (i64.const 0)) (ref.extern 2))
(assert_return (invoke "get-t64" (i64.const 1)) (ref.extern 3))
(assert_return (invoke "get-t64" (i64.const 4)) (ref.extern 3))
(assert_return (invoke "set-t64" (i64.const 4) (ref.extern 4)))
(assert_return (invoke "get-t64" (i64.const 4)) (ref.extern 4))
(assert_trap (invoke "set-t64" (i64.const 5) (ref.extern 2)) "out of bounds table access")
(assert_trap (invoke "get-t64" (i64.const 5)) "out of bounds table access")
