/*
 * Copyright (c) 2009-2011, Salvatore Sanfilippo <antirez at gmail dot com>
 * Copyright (c) 2010-2011, Pieter Noordhuis <pcnoordhuis at gmail dot com>
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *   * Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 *   * Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *   * Neither the name of Redis nor the names of its contributors may be used
 *     to endorse or promote products derived from this software without
 *     specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef VALKEY_ASYNC_PRIVATE_H
#define VALKEY_ASYNC_PRIVATE_H
#include "visibility.h"

#define _EL_ADD_READ(ctx)                      \
    do {                                       \
        refreshTimeout(ctx);                   \
        if ((ctx)->ev.addRead)                 \
            (ctx)->ev.addRead((ctx)->ev.data); \
    } while (0)
#define _EL_DEL_READ(ctx)                      \
    do {                                       \
        if ((ctx)->ev.delRead)                 \
            (ctx)->ev.delRead((ctx)->ev.data); \
    } while (0)
#define _EL_ADD_WRITE(ctx)                      \
    do {                                        \
        refreshTimeout(ctx);                    \
        if ((ctx)->ev.addWrite)                 \
            (ctx)->ev.addWrite((ctx)->ev.data); \
    } while (0)
#define _EL_DEL_WRITE(ctx)                      \
    do {                                        \
        if ((ctx)->ev.delWrite)                 \
            (ctx)->ev.delWrite((ctx)->ev.data); \
    } while (0)
#define _EL_CLEANUP(ctx)                       \
    do {                                       \
        if ((ctx)->ev.cleanup)                 \
            (ctx)->ev.cleanup((ctx)->ev.data); \
        ctx->ev.cleanup = NULL;                \
    } while (0)

static inline void refreshTimeout(valkeyAsyncContext *ctx) {
#define VALKEY_TIMER_ISSET(tvp) \
    (tvp && ((tvp)->tv_sec || (tvp)->tv_usec))

#define VALKEY_EL_TIMER(ac, tvp)                             \
    if ((ac)->ev.scheduleTimer && VALKEY_TIMER_ISSET(tvp)) { \
        (ac)->ev.scheduleTimer((ac)->ev.data, *(tvp));       \
    }

    if (ctx->c.flags & VALKEY_CONNECTED) {
        VALKEY_EL_TIMER(ctx, ctx->c.command_timeout);
    } else {
        VALKEY_EL_TIMER(ctx, ctx->c.connect_timeout);
    }
}

/* Visible although private since required by libvalkey_tls.so */
LIBVALKEY_API void valkeyAsyncDisconnectInternal(valkeyAsyncContext *ac);
LIBVALKEY_API void valkeyProcessCallbacks(valkeyAsyncContext *ac);

#endif /* VALKEY_ASYNC_PRIVATE_H */
