# libreadtags

libreadtags is a library for reading tags files generated by ctags.
libreadtags assumes the tags file format explained in [tags(5)](https://docs.ctags.io/en/latest/man/tags.5.html)
of Universal-ctags.

See the comments at the top of readtags.h about the license and copyright.
libreadtags was derived from readtags.c of Exuberant-ctags.

NEWS.md describes note worty changes.

If you are looking for command line interface for tags files,
you will like [readtags command](https://docs.ctags.io/en/latest/man/readtags.1.html)
shipped as part of Universal-ctags. It uses libreadtags extensively.

You can build libreadtags with GNU Autotools and CMake.

## Autotools Usage

### Build
```shell
test -e autogen.sh && ./autogen.sh
./configure
make
```

### Test
```shell
make check
```


## CMake Usage

### Build as a standalone project

#### Configure and build only

```shell
mkdir build
cmake -DCMAKE_BUILD_TYPE=Release -DLIBREADTAGS_BUILD_SHARED=ON -S . -B build
cmake --build build --target readtags
```

#### Configure, build, and test
```shell
mkdir build
cmake -DCMAKE_BUILD_TYPE=Release -DLIBREADTAGS_BUILD_SHARED=ON -S . -B build
cmake --build build
ctest --test-dir build
```

#### Configure and install

This will install the library and headers to `/usr/local`.

```shell
mkdir build
cmake -DCMAKE_BUILD_TYPE=Release -DLIBREADTAGS_BUILD_SHARED=ON -S . -B build
sudo cmake --build build --target install
```

### Integrate into other CMake projects

```cmake
include(FetchContent)

FetchContent_Declare(
        readtags
        GIT_REPOSITORY https://github.com/universal-ctags/libreadtags.git
        GIT_TAG master
)

FetchContent_MakeAvailable(readtags)

target_link_libraries(your_target PRIVATE universal-ctags::readtags)
```
