import { useIsDarkMode } from 'hooks/use-theme'

export const EmptyIcon = () => {
  const isDarkMode = useIsDarkMode()

  return (
    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 88 96" preserveAspectRatio="xMidYMid meet">
      <g fill="none" fillRule="nonzero" stroke="#DCDCDC" strokeWidth="4">
        <path
          fill={isDarkMode ? 'hsl(209, 28%, 19%)' : '#f2f3f5'}
          d="M41.05 42.807zm0 0l-.006.003 1.917 3.508-1.876-3.532c1.866-1.05 4.007-1.044 5.82-.006 8.058 4.62 22.413 13.097 37.112 21.84C85.14 65.299 86 66.39 86 68c0 1.612-.866 2.71-1.993 3.383-15.424 9.173-29.305 17.368-37.1 21.836a5.813 5.813 0 0 1-5.812 0C33.322 88.765 19.88 80.83 3.983 71.38 2.86 70.7 2 69.61 2 67.999c0-1.615.869-2.72 1.993-3.382a8052.42 8052.42 0 0 1 17.004-10.023l.05-.03a33723.823 33723.823 0 0 1 18.288-10.75l1.27-.746.334-.196.085-.05.022-.013.004-.002z"
        />
        <path
          fill={isDarkMode ? 'hsl(208, 37%, 15%)' : 'hsl(0, 0%, 99%)'}
          strokeDasharray="0,10"
          strokeLinecap="round"
          d="M4 48c0-.96.707-1.483 1.012-1.662 9.254-5.48 37.058-21.81 37.054-21.809 1.274-.717 2.664-.69 3.844-.014 10.211 5.854 30.961 18.182 37.074 21.819.305.183 1.016.71 1.016 1.666 0 .955-.71 1.482-1.016 1.664-7.914 4.707-27.37 16.26-37.07 21.818a3.813 3.813 0 0 1-3.824.002c-9.703-5.56-29.16-17.113-37.074-21.818C4.71 49.482 4 48.955 4 48z"
        />
        <path
          fill={isDarkMode ? 'hsl(209, 28%, 19%)' : '#f2f3f5'}
          d="M41.044 2.81L41.05 2.807L41.046 2.809L41.024 2.822L40.939 2.872L40.605 3.068L39.335 3.814C33.2379 7.39542 27.1419 10.9787 21.047 14.564L20.997 14.594C15.3249 17.9281 9.6569 21.2691 3.993 24.617C2.869 25.279 2 26.384 2 27.999C2 29.61 2.86 30.7 3.983 31.38C19.88 40.83 33.322 48.765 41.095 53.219C41.9786 53.729 42.9808 53.9975 44.001 53.9975C45.0212 53.9975 46.0234 53.729 46.907 53.219C54.702 48.751 68.583 40.556 84.007 31.383C85.134 30.71 86 29.612 86 28C86 26.39 85.14 25.299 84.017 24.62C69.318 15.877 54.963 7.4 46.905 2.78C45.092 1.742 42.951 1.736 41.085 2.786"
        />
      </g>
    </svg>
  )
}
