# Building on Windows using vcpkg

Full Visual Studio is not needed, but the installation assumes [Build Tools for VS 2022](https://visualstudio.microsoft.com/downloads/?q=build+tools#build-tools-for-visual-studio-2022) are installed.

The only needed component is "Desktop development with C++".

## 1. Install vcpkg

Follow the first two steps from [Tutorial: Install and use packages with CMake](https://learn.microsoft.com/en-gb/vcpkg/get_started/get-started?pivots=shell-powershell]):

Clone and bootstrap vcpkg:

```shell
git clone https://github.com/microsoft/vcpkg.git
cd vcpkg
./bootstrap-vcpkg.bat
```

Inside `x64 Native Tools Command Prompt for VS 2022`:
Set `VCPKG_ROOT` env variable to point to vcpkg directory; also add the directory to `PATH`:
```shell
set "VCPKG_ROOT=C:\path\to\vcpkg"
set PATH=%VCPKG_ROOT%;%PATH%
```

## 2. Install required dependencies

This might take a while, so there's a single command that downloads and compiles all of them at once (below), depending on your preferences you might want to try it and in the meantime make yourself some well-deserved coffee.

```
vcpkg install openssl
vcpkg install zlib
vcpkg install pkgconf (requires verification, might not be required)
vcpkg install pcre2
vcpkg install libiconv
vcpkg install libunistring
```

Alternative:
```shell
vcpkg install openssl zlib pkgconf pcre2 libiconv libunistring
```

## 3. Generate solution and build the project

CMake should be included with _Build Tools_, but it might not be included in your `PATH`. Modify your environment appropriately.

To generate build VS2022 project files inside `build` directory (recommended to avoid mess):

```shell
cd path\to\the_Foundation
cmake -S . -B build -DCMAKE_TOOLCHAIN_FILE=x:\path\to\vcpkg\scripts\buildsystems\vcpkg.cmake -DCMAKE_POLICY_VERSION_MINIMUM=3.5
```

To build the project:
```shell
msbuild -t:Build -p:Configuration=Release -p:Platform=x64 build\the_Foundation.sln
```

Alternatively CMake itself can be used to build:
```shell
cmake --build build --config Release
```

## 4. Run test apps

When build finishes, you can try running some test applications (sources are in `the_Foundation/tests`).

Few, that should be easy to follow (when looking at their code):

```shell
./build/Release/math_Foundation.exe
./build/Release/string_Foundation.exe
./build/Release/test_Foundation.exe     # general test
```
