
///////////////////////////////////////////////////////////
//                                                       //
//                         SAGA                          //
//                                                       //
//      System for Automated Geoscientific Analyses      //
//                                                       //
//                     Tool Library:                     //
//                        SCIMAP                         //
//  Hydrological Connectivity Indices Collection (HCIC)  //
//                                                       //
//-------------------------------------------------------//
//                                                       //
//                       SCIMAP.h                        //
//                                                       //
//                 Copyright (C) 2025 by                 //
//                      Sim Reaney                       //
//               sim.reaney@durham.ac.uk                 //
//                                                       //
//-------------------------------------------------------//
//                                                       //
// This file is part of 'SAGA - System for Automated     //
// Geoscientific Analyses'. SAGA is free software; you   //
// can redistribute it and/or modify it under the terms  //
// of the GNU General Public License as published by the //
// Free Software Foundation; version 2 of the License.   //
//                                                       //
// SAGA is distributed in the hope that it will be       //
// useful, but WITHOUT ANY WARRANTY; without even the    //
// implied warranty of MERCHANTABILITY or FITNESS FOR A  //
// PARTICULAR PURPOSE. See the GNU General Public        //
// License for more details.                             //
//                                                       //
// You should have received a copy of the GNU General    //
// Public License along with this program; if not,       //
// write to the Free Software Foundation, Inc.,          //
// 59 Temple Place - Suite 330, Boston, MA 02111-1307,   //
// USA.                                                  //
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
#ifndef HEADER_INCLUDED__SCIMAP_H
#define HEADER_INCLUDED__SCIMAP_H


///////////////////////////////////////////////////////////
//                                                       //
//                                                       //
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
#include <saga_api/saga_api.h>


///////////////////////////////////////////////////////////
//                                                       //
//                                                       //
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
class CSCIMAP : public CSG_Tool_Grid
{
public:
	CSCIMAP(void);


protected:

	virtual int			On_Parameters_Enable		(CSG_Parameters *pParameters, CSG_Parameter *pParameter);

	virtual bool		On_Execute					(void);


private:

	bool				netwet						(CSG_Grid *dem, CSG_Grid *wet, CSG_Grid *channels);
	bool				downslopeSaturatedLength	(CSG_Grid *dem, CSG_Grid *wet, CSG_Grid *channels);
	bool				deliveryPoints				(CSG_Grid *dem, CSG_Grid *wet, CSG_Grid *channels);

	void				top_percent					(CSG_Grid *pGrid, CSG_Grid *pTop, double Percentile = 90.);
	bool				rescale_to_range			(CSG_Grid *pGrid);
	bool				rescale_to_percentiles		(CSG_Grid *pGrid, double min = 5., double max = 95.);

};


///////////////////////////////////////////////////////////
//                                                       //
//                                                       //
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
#endif // #ifndef HEADER_INCLUDED__SCIMAP_H
