/*
 *  RSGISCumulativeAreaClassifier.h
 *  RSGIS_LIB
 *
 *  Created by Pete Bunting on 09/06/2010.
 *  Copyright 2010 RSGISLib. All rights reserved.
 *  This file is part of RSGISLib.
 * 
 *  RSGISLib is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  RSGISLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with RSGISLib.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef RSGISCumulativeAreaClassifier_H
#define RSGISCumulativeAreaClassifier_H

#include <cmath>
#include <limits>

#include "img/RSGISCalcImage.h"
#include "img/RSGISCalcImageValue.h"
#include "img/RSGISImageCalcException.h"

#include "math/RSGISMatrices.h"
#include "math/RSGISVectors.h"

// mark all exported classes/functions with DllExport to have
// them exported by Visual Studio
#undef DllExport
#ifdef _MSC_VER
    #ifdef rsgis_classify_EXPORTS
        #define DllExport   __declspec( dllexport )
    #else
        #define DllExport   __declspec( dllimport )
    #endif
#else
    #define DllExport
#endif

namespace rsgis { namespace classifier {
    
	/**
	 * A pair of classes which generate the a rule image (distance to sample) using
	 * the euclidean distance to measure the distance between two cumulative area
	 * plots.
	 */
	
	
	class DllExport RSGISCumulativeAreaClassifierGenRules : public rsgis::img::RSGISCalcImageValue
	{
	public:
		RSGISCumulativeAreaClassifierGenRules(int numOutBands, rsgis::math::Matrix *bandValuesWidths, rsgis::math::Matrix *samples);
		void calcImageValue(float *bandValues, int numBands, double *output);
		float* calculateCumulativeArea(float *dataValues, int numVals);
		float calcEuclideanDistance(rsgis::math::Matrix *sample, int sampleNum, float *data);
		~RSGISCumulativeAreaClassifierGenRules();
	private:
		rsgis::math::Matrix *bandValuesWidths;
		rsgis::math::Matrix *samples;
	};
	
	/// Classify rule image produced by the cumulative area classifier
	class DllExport RSGISCumulativeAreaClassifierDecide : public rsgis::img::RSGISCalcImageValue
	{
	public:
		RSGISCumulativeAreaClassifierDecide(int numOutBands, double threshold);
		void calcImageValue(float *bandValues, int numBands, double *output);
		~RSGISCumulativeAreaClassifierDecide();
	private:
		double threshold;
	};
	
}}

#endif


