var searchData=
[
  ['i_20o_20constants_0',['I/O Constants',['../../../../lang/html/group__io__constants.html',1,'']]],
  ['i_20o_20event_20handling_1',['I/O Event Handling',['../../../../lang/html/event_handling.html',1,'index']]],
  ['iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_2',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_3',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['icanon_4',['ICANON',['../../../../lang/html/group__tattr__local__mode__constants.html#gaee28cceae79349ff888ba64408473382',1,'Qore::ICANON'],['../../../../lang/html/group__tattr__local__mode__constants.html#gaee28cceae79349ff888ba64408473382',1,'Qore::ICANON']]],
  ['icon_5',['icon',['../../../Util/html/struct_util_1_1_allowed_value_info.html#a5e78249c9e93b3d2262412e215c92a37',1,'Util::AllowedValueInfo']]],
  ['icrnl_6',['ICRNL',['../../../../lang/html/group__tattr__input__mode__constants.html#gaaf04993e1c6345567687305ef04fc2d6',1,'Qore::ICRNL'],['../../../../lang/html/group__tattr__input__mode__constants.html#gaaf04993e1c6345567687305ef04fc2d6',1,'Qore::ICRNL']]],
  ['id_7',['id',['../../../../lang/html/struct_qore_1_1_sse_message_info.html#aa085e294c95ad5522aa61a8610cfaf31',1,'Qore::SseMessageInfo']]],
  ['identifiers_8',['Identifiers',['../../../../lang/html/identifiers.html',1,'index']]],
  ['ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_9',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_10',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_11',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_12',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_13',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['iexten_14',['IEXTEN',['../../../../lang/html/group__tattr__local__mode__constants.html#ga85a235af8ce51b2079a4e237d7b281b0',1,'Qore::IEXTEN'],['../../../../lang/html/group__tattr__local__mode__constants.html#ga85a235af8ce51b2079a4e237d7b281b0',1,'Qore::IEXTEN']]],
  ['if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_15',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['if_20so_20additionally_20the_20class_20also_20automatically_20detects_20if_20the_20server_20supports_20the_20c_20starttls_20command_20by_20parsing_20the_20response_20to_20the_20c_20ehlo_20command_20when_20talking_20to_20esmtp_20servers_20if_20the_20a_20tls_20flag_20is_20not_20set_20on_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20and_20the_20server_20supports_20c_20starttls_20and_20a_20transport_20layer_20tls_20ssl_20connection_20was_20not_20already_20established_20then_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20will_20automatically_20execute_20a_20c_20starttls_20command_20after_20connecting_20so_20that_20the_20rest_20of_20the_20smtp_20session_20is_20performed_20securely_20this_20also_20allows_20transparent_20logins_20and_20communication_20with_20esmtp_20servers_20that_20require_20secure_20connections_20for_20the_20above_20reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_16',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_17',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['if_20the_20a_20tls_20flag_20is_20not_20set_20on_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20and_20the_20server_20supports_20c_20starttls_20and_20a_20transport_20layer_20tls_20ssl_20connection_20was_20not_20already_20established_20then_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20will_20automatically_20execute_20a_20c_20starttls_20command_20after_20connecting_20so_20that_20the_20rest_20of_20the_20smtp_20session_20is_20performed_20securely_20this_20also_20allows_20transparent_20logins_20and_20communication_20with_20esmtp_20servers_20that_20require_20secure_20connections_20for_20the_20above_20reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_18',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_19',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_20',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_21',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['if_20the_20server_20supports_20the_20c_20starttls_20command_20by_20parsing_20the_20response_20to_20the_20c_20ehlo_20command_20when_20talking_20to_20esmtp_20servers_20if_20the_20a_20tls_20flag_20is_20not_20set_20on_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20and_20the_20server_20supports_20c_20starttls_20and_20a_20transport_20layer_20tls_20ssl_20connection_20was_20not_20already_20established_20then_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20will_20automatically_20execute_20a_20c_20starttls_20command_20after_20connecting_20so_20that_20the_20rest_20of_20the_20smtp_20session_20is_20performed_20securely_20this_20also_20allows_20transparent_20logins_20and_20communication_20with_20esmtp_20servers_20that_20require_20secure_20connections_20for_20the_20above_20reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_22',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['if_20the_20smtp_20server_20supports_20esmtp_20and_20a_20c_20ehlo_20command_20is_20executed_20automatically_20instead_20of_20c_20helo_20if_20so_20additionally_20the_20class_20also_20automatically_20detects_20if_20the_20server_20supports_20the_20c_20starttls_20command_20by_20parsing_20the_20response_20to_20the_20c_20ehlo_20command_20when_20talking_20to_20esmtp_20servers_20if_20the_20a_20tls_20flag_20is_20not_20set_20on_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20and_20the_20server_20supports_20c_20starttls_20and_20a_20transport_20layer_20tls_20ssl_20connection_20was_20not_20already_20established_20then_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20will_20automatically_20execute_20a_20c_20starttls_20command_20after_20connecting_20so_20that_20the_20rest_20of_20the_20smtp_20session_20is_20performed_20securely_20this_20also_20allows_20transparent_20logins_20and_20communication_20with_20esmtp_20servers_20that_20require_20secure_20connections_20for_20the_20above_20reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_23',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['ignbrk_24',['IGNBRK',['../../../../lang/html/group__tattr__input__mode__constants.html#gaa21e7e2efbd106bc6302196c9a8b224e',1,'Qore::IGNBRK'],['../../../../lang/html/group__tattr__input__mode__constants.html#gaa21e7e2efbd106bc6302196c9a8b224e',1,'Qore::IGNBRK']]],
  ['igncr_25',['IGNCR',['../../../../lang/html/group__tattr__input__mode__constants.html#ga6684ffc51a2e624d3edfc4de4c1fe8bc',1,'Qore::IGNCR'],['../../../../lang/html/group__tattr__input__mode__constants.html#ga6684ffc51a2e624d3edfc4de4c1fe8bc',1,'Qore::IGNCR']]],
  ['ignpar_26',['IGNPAR',['../../../../lang/html/group__tattr__input__mode__constants.html#gadb90d9b6e378358b8c8e2d94a635530c',1,'Qore::IGNPAR'],['../../../../lang/html/group__tattr__input__mode__constants.html#gadb90d9b6e378358b8c8e2d94a635530c',1,'Qore::IGNPAR']]],
  ['image_27',['image',['../../../Util/html/struct_util_1_1_allowed_value_info.html#acf813f4641c687f517925a82fd4822ad',1,'Util::AllowedValueInfo']]],
  ['imaxbel_28',['IMAXBEL',['../../../../lang/html/group__tattr__input__mode__constants.html#ga8834400effd021bd507a29724b6158dd',1,'Qore::IMAXBEL'],['../../../../lang/html/group__tattr__input__mode__constants.html#ga8834400effd021bd507a29724b6158dd',1,'Qore::IMAXBEL']]],
  ['immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_29',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_30',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_31',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_32',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['import_20visibility_20constants_33',['Import Visibility Constants',['../../../../lang/html/group__import__visibility__constants.html',1,'']]],
  ['important_34',['important',['../../../MailMessage/html/struct_mail_message_1_1_mail_message_info.html#a5ccebd16d47e9ecd04de1b2a10446eaf',1,'MailMessage::MailMessageInfo::important'],['../../../MailMessage/html/class_mail_message_1_1_message.html#a1add855220afbfb9dbe76e0be2aa9819',1,'MailMessage::Message::important()'],['../../../MailMessage/html/class_mail_message_1_1_message.html#ac4ec0eb1243708e2305988d6d5b2c04e',1,'MailMessage::Message::important(softbool i)']]],
  ['importclass_35',['importClass',['../../../../lang/html/class_qore_1_1_program.html#abf634534cb29157d05aab5ff3ffd6bea',1,'Qore::Program']]],
  ['importfunction_36',['importFunction',['../../../../lang/html/class_qore_1_1_program.html#a9a2e3da4029c50643169cbb72e57f494',1,'Qore::Program::importFunction(string func)'],['../../../../lang/html/class_qore_1_1_program.html#a4ea59c8d245e924b791a74cdb551946f',1,'Qore::Program::importFunction(string func, string new_name, *softbool inject)']]],
  ['importglobalvariable_37',['importGlobalVariable',['../../../../lang/html/class_qore_1_1_program.html#a5db34046e2722a8519642ad98f412ed3',1,'Qore::Program::importGlobalVariable(string varname, bool readonly=False)'],['../../../../lang/html/class_qore_1_1_program.html#a28aaf953092daf0dcc6099fa143ec4b0',1,'Qore::Program::importGlobalVariable(string varname, string import_as, bool readonly=False)']]],
  ['importhashdecl_38',['importHashDecl',['../../../../lang/html/class_qore_1_1_program.html#a029c9dbdbdc3dc13e685f7d101e5829e',1,'Qore::Program']]],
  ['importsystemapi_39',['importSystemApi',['../../../../lang/html/class_qore_1_1_program.html#a8abea6fe89712e9b4f84c7f7b0420151',1,'Qore::Program']]],
  ['importsystemclasses_40',['importSystemClasses',['../../../../lang/html/class_qore_1_1_program.html#ad512b5c0b491823d186e0de7cf8d87d4',1,'Qore::Program']]],
  ['importsystemconstants_41',['importSystemConstants',['../../../../lang/html/class_qore_1_1_program.html#a2942f186ac759fb7a71cbb9ec0ffb72a',1,'Qore::Program']]],
  ['importsystemfunctions_42',['importSystemFunctions',['../../../../lang/html/class_qore_1_1_program.html#adc115cc0b1c0f196ed0d764eb33c4009',1,'Qore::Program']]],
  ['importsystemhashdecls_43',['importSystemHashDecls',['../../../../lang/html/class_qore_1_1_program.html#a4aef71f37e505dbe84be95b0a2848cba',1,'Qore::Program']]],
  ['in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_44',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_45',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_46',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_47',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_48',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_49',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['in_20the_20module_20are_20defined_20in_20the_20smtpclient_20namespace_20classes_20provided_3a_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20_3a_20manages_20a_20connection_20to_20an_20smtp_20server_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20_3a_20provides_20a_20connection_20object_20to_20an_20smtp_20server_20based_20on_20the_20ref_20connectionproviderintro_20connectionprovider_20module_20the_20following_20supporting_20classes_20are_20provided_20by_20the_20mailmessage_20module_3a_20mailmessage_3a_3amessage_3a_20wraps_20a_20message_20to_20be_20sent_20via_20an_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20mailmessage_3a_3aattachment_3a_20used_20to_20attach_20files_20to_20a_20mailmessage_3a_3amessage_20object_20note_20that_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20class_20automatically_20detects_20if_20the_20smtp_20server_20supports_20esmtp_20and_20a_20c_20ehlo_20command_20is_20executed_20automatically_20instead_20of_20c_20helo_20if_20so_20additionally_20the_20class_20also_20automatically_20detects_20if_20the_20server_20supports_20the_20c_20starttls_20command_20by_20parsing_20the_20response_20to_20the_20c_20ehlo_20command_20when_20talking_20to_20esmtp_20servers_20if_20the_20a_20tls_20flag_20is_20not_20set_20on_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20and_20the_20server_20supports_20c_20starttls_20and_20a_20transport_20layer_20tls_20ssl_20connection_20was_20not_20already_20established_20then_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20will_20automatically_20execute_20a_20c_20starttls_20command_20after_20connecting_20so_20that_20the_20rest_20of_20the_20smtp_20session_20is_20performed_20securely_20this_20also_20allows_20transparent_20logins_20and_20communication_20with_20esmtp_20servers_20that_20require_20secure_20connections_20for_20the_20above_20reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_50',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_51',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_52',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_53',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['in_20the_20smtpclient_20namespace_20classes_20provided_3a_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20_3a_20manages_20a_20connection_20to_20an_20smtp_20server_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20_3a_20provides_20a_20connection_20object_20to_20an_20smtp_20server_20based_20on_20the_20ref_20connectionproviderintro_20connectionprovider_20module_20the_20following_20supporting_20classes_20are_20provided_20by_20the_20mailmessage_20module_3a_20mailmessage_3a_3amessage_3a_20wraps_20a_20message_20to_20be_20sent_20via_20an_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20mailmessage_3a_3aattachment_3a_20used_20to_20attach_20files_20to_20a_20mailmessage_3a_3amessage_20object_20note_20that_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20class_20automatically_20detects_20if_20the_20smtp_20server_20supports_20esmtp_20and_20a_20c_20ehlo_20command_20is_20executed_20automatically_20instead_20of_20c_20helo_20if_20so_20additionally_20the_20class_20also_20automatically_20detects_20if_20the_20server_20supports_20the_20c_20starttls_20command_20by_20parsing_20the_20response_20to_20the_20c_20ehlo_20command_20when_20talking_20to_20esmtp_20servers_20if_20the_20a_20tls_20flag_20is_20not_20set_20on_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20and_20the_20server_20supports_20c_20starttls_20and_20a_20transport_20layer_20tls_20ssl_20connection_20was_20not_20already_20established_20then_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20will_20automatically_20execute_20a_20c_20starttls_20command_20after_20connecting_20so_20that_20the_20rest_20of_20the_20smtp_20session_20is_20performed_20securely_20this_20also_20allows_20transparent_20logins_20and_20communication_20with_20esmtp_20servers_20that_20require_20secure_20connections_20for_20the_20above_20reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_54',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_55',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_56',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_57',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['in_20your_20code_20see_20examples_20email_20q_20for_20an_20example_20program_20using_20this_20module_20all_20the_20symbols_20in_20the_20module_20are_20defined_20in_20the_20smtpclient_20namespace_20classes_20provided_3a_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20_3a_20manages_20a_20connection_20to_20an_20smtp_20server_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20_3a_20provides_20a_20connection_20object_20to_20an_20smtp_20server_20based_20on_20the_20ref_20connectionproviderintro_20connectionprovider_20module_20the_20following_20supporting_20classes_20are_20provided_20by_20the_20mailmessage_20module_3a_20mailmessage_3a_3amessage_3a_20wraps_20a_20message_20to_20be_20sent_20via_20an_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20mailmessage_3a_3aattachment_3a_20used_20to_20attach_20files_20to_20a_20mailmessage_3a_3amessage_20object_20note_20that_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20class_20automatically_20detects_20if_20the_20smtp_20server_20supports_20esmtp_20and_20a_20c_20ehlo_20command_20is_20executed_20automatically_20instead_20of_20c_20helo_20if_20so_20additionally_20the_20class_20also_20automatically_20detects_20if_20the_20server_20supports_20the_20c_20starttls_20command_20by_20parsing_20the_20response_20to_20the_20c_20ehlo_20command_20when_20talking_20to_20esmtp_20servers_20if_20the_20a_20tls_20flag_20is_20not_20set_20on_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20and_20the_20server_20supports_20c_20starttls_20and_20a_20transport_20layer_20tls_20ssl_20connection_20was_20not_20already_20established_20then_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20will_20automatically_20execute_20a_20c_20starttls_20command_20after_20connecting_20so_20that_20the_20rest_20of_20the_20smtp_20session_20is_20performed_20securely_20this_20also_20allows_20transparent_20logins_20and_20communication_20with_20esmtp_20servers_20that_20require_20secure_20connections_20for_20the_20above_20reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_58',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['in_5frefresh_59',['in_refresh',['../../../RestClient/html/class_rest_client_1_1_rest_ping_poll_operation.html#a3bf49df83d56ec4d446cf3471d082f6f',1,'RestClient::RestPingPollOperation']]],
  ['inc_60',['inc',['../../../../lang/html/class_qore_1_1_thread_1_1_counter.html#a7c098cd52caeff8f5ff18dddff2eeeb5',1,'Qore::Thread::Counter']]],
  ['inclevel_61',['incLevel',['../../../Logger/html/class_logger_1_1_logger_wrapper.html#af191dc42fb6e6958ed38000ba8c89542',1,'Logger::LoggerWrapper']]],
  ['include_20files_62',['Include Files',['../../../../lang/html/include_files.html',1,'index']]],
  ['included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_63',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_64',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['independent_20user_20and_20group_20functions_65',['Platform-Independent User and Group Functions',['../../../../lang/html/group__user__and__group__functions.html',1,'']]],
  ['index_66',['index',['../../../../lang/html/class_qore_1_1_abstract_line_iterator.html#acde61f19ac0b96adcaafbe4962e9a335',1,'Qore::AbstractLineIterator::index()'],['../../../../lang/html/class_qore_1_1_data_line_iterator.html#a2e9f211ca438b8b3f8a122b040ce46ae',1,'Qore::DataLineIterator::index()'],['../../../../lang/html/class_qore_1_1_file_line_iterator.html#a9eb374145fd48a41420b96684ff895f5',1,'Qore::FileLineIterator::index()'],['../../../../lang/html/class_qore_1_1_hash_list_iterator.html#adf87382e56f8bc3773ab4319c83e82ea',1,'Qore::HashListIterator::index()'],['../../../../lang/html/class_qore_1_1_input_stream_line_iterator.html#ac2a16a29cd14271505149e96c144c814',1,'Qore::InputStreamLineIterator::index()'],['../../../../lang/html/class_qore_1_1_list_hash_iterator.html#ad53157969b6c64ac9cb9732b4817ab59',1,'Qore::ListHashIterator::index()'],['../../../../lang/html/class_qore_1_1_list_iterator.html#a60f50a3f482803ef6f8b7488a27edf4e',1,'Qore::ListIterator::index()'],['../../../../lang/html/group__string__functions.html#gadaea9cfa0f698a6fb0650f70cf8d929e',1,'Qore::index(softstring str, softstring substr, softint pos=0)'],['../../../../lang/html/group__string__functions.html#gab2ccb59779f7860a4e67af5b5a3bc766',1,'Qore::index()'],['../../../../lang/html/group__string__functions.html#gadaea9cfa0f698a6fb0650f70cf8d929e',1,'Qore::index(softstring str, softstring substr, softint pos=0)'],['../../../../lang/html/group__string__functions.html#gab2ccb59779f7860a4e67af5b5a3bc766',1,'Qore::index()']]],
  ['index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_67',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['indexedobjectserializationinfo_68',['IndexedObjectSerializationInfo',['../../../../lang/html/struct_qore_1_1_indexed_object_serialization_info.html',1,'Qore']]],
  ['info_69',['info',['../../../RestSchemaValidator/html/struct_rest_schema_validator_1_1_rest_request_server_info.html#a46a24ff9bb5f2d682cb88c40b781b522',1,'RestSchemaValidator::RestRequestServerInfo::info'],['../../../RestSchemaValidator/html/struct_rest_schema_validator_1_1_rest_response_client_info.html#aaa9c34d34d13f654c7153e94722261e8',1,'RestSchemaValidator::RestResponseClientInfo::info'],['../../../Swagger/html/class_swagger_1_1_swagger_schema.html#aacb3a59fe721f6bfc0d40312acd08f91',1,'Swagger::SwaggerSchema::info'],['../class_smtp_ping_poll_operation.html#ac72aa9bb1c5607a8bec2054ef266ba96',1,'SmtpPingPollOperation::info'],['../../../../lang/html/class_qore_1_1zzz8datezzz9.html#a8570798c5d3d8273e45af77bd1817a3e',1,'Qore::&lt;date&gt;::info()'],['../../../Logger/html/class_logger_1_1_logger_wrapper.html#ab49411f2d262c551094c7f79fc0eca1c',1,'Logger::LoggerWrapper::info()']]],
  ['infoobject_70',['InfoObject',['../../../Swagger/html/class_swagger_1_1_info_object.html',1,'Swagger']]],
  ['information_20constants_71',['Network Address Information Constants',['../../../../lang/html/group__network__address__information__constants.html',1,'']]],
  ['information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_72',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['infp_73',['infp',['../../../../lang/html/class_qore_1_1zzz8floatzzz9.html#aea0691501b3c4e0325034bd7a77f83fb',1,'Qore::&lt;float&gt;::infp()'],['../../../../lang/html/class_qore_1_1zzz8numberzzz9.html#a77d551228c1b9919aff689fa6a5f2d02',1,'Qore::&lt;number&gt;::infp()']]],
  ['initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_74',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_75',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['initialize_76',['initialize',['../../../Swagger/html/class_swagger_1_1_object_base.html#a258b837396cd85d44cac5a5eb3c5dcc5',1,'Swagger::ObjectBase']]],
  ['inlcr_77',['INLCR',['../../../../lang/html/group__tattr__input__mode__constants.html#ga2827351fd2729b71b840315e9b487a05',1,'Qore::INLCR'],['../../../../lang/html/group__tattr__input__mode__constants.html#ga2827351fd2729b71b840315e9b487a05',1,'Qore::INLCR']]],
  ['inlist_78',['inlist',['../../../../lang/html/group__list__functions.html#ga776993c1408e78f466e9b11aff7ecc46',1,'Qore::inlist()'],['../../../../lang/html/group__list__functions.html#ga67118489d63343ab95f887d785157c51',1,'Qore::inlist(any arg, nothing x)'],['../../../../lang/html/group__list__functions.html#ga1fa8462e9bb051d40f5e60de8504fc85',1,'Qore::inlist(auto arg, softlist&lt; auto &gt; l)'],['../../../../lang/html/group__list__functions.html#ga776993c1408e78f466e9b11aff7ecc46',1,'Qore::inlist()'],['../../../../lang/html/group__list__functions.html#ga67118489d63343ab95f887d785157c51',1,'Qore::inlist(any arg, nothing x)'],['../../../../lang/html/group__list__functions.html#ga1fa8462e9bb051d40f5e60de8504fc85',1,'Qore::inlist(auto arg, softlist&lt; auto &gt; l)']]],
  ['inlist_5fhard_79',['inlist_hard',['../../../../lang/html/group__list__functions.html#ga1fdf41e61754093da9f8a3b40e2a9cea',1,'Qore::inlist_hard()'],['../../../../lang/html/group__list__functions.html#ga4668ef52b2c07e8768118bc7c8638414',1,'Qore::inlist_hard(any arg, nothing x)'],['../../../../lang/html/group__list__functions.html#ga15056f0f1b38aff845c6ca3dfefd3c54',1,'Qore::inlist_hard(auto arg, softlist&lt; auto &gt; l)'],['../../../../lang/html/group__list__functions.html#ga1fdf41e61754093da9f8a3b40e2a9cea',1,'Qore::inlist_hard()'],['../../../../lang/html/group__list__functions.html#ga4668ef52b2c07e8768118bc7c8638414',1,'Qore::inlist_hard(any arg, nothing x)'],['../../../../lang/html/group__list__functions.html#ga15056f0f1b38aff845c6ca3dfefd3c54',1,'Qore::inlist_hard(auto arg, softlist&lt; auto &gt; l)']]],
  ['inloc_80',['inLoc',['../../../Swagger/html/class_swagger_1_1_abstract_parameter_object.html#add2fcc16d90e604caad78167196a7e4b',1,'Swagger::AbstractParameterObject::inLoc'],['../../../Swagger/html/class_swagger_1_1_security_scheme_object.html#a82380efccd0bdd26e352c4eca4ff15ed',1,'Swagger::SecuritySchemeObject::inLoc']]],
  ['inode_81',['inode',['../../../../lang/html/struct_qore_1_1_dir_stat_info.html#a6613f7693e56d91213e708550a6abee9',1,'Qore::DirStatInfo::inode'],['../../../../lang/html/struct_qore_1_1_stat_info.html#a95aaa8d1c10093399bc79dd5cf8a3f05',1,'Qore::StatInfo::inode']]],
  ['inpck_82',['INPCK',['../../../../lang/html/group__tattr__input__mode__constants.html#ga2cd9fec271abb6f9352d02339d1580c4',1,'Qore::INPCK'],['../../../../lang/html/group__tattr__input__mode__constants.html#ga2cd9fec271abb6f9352d02339d1580c4',1,'Qore::INPCK']]],
  ['input_20mode_20constants_83',['Terminal Attributes Input Mode Constants',['../../../../lang/html/group__tattr__input__mode__constants.html',1,'']]],
  ['inputstream_84',['InputStream',['../../../../lang/html/class_qore_1_1_input_stream.html',1,'Qore']]],
  ['inputstreamlineiterator_85',['InputStreamLineIterator',['../../../../lang/html/class_qore_1_1_input_stream_line_iterator.html',1,'Qore']]],
  ['insert_86',['insert',['../../../../lang/html/class_qore_1_1_thread_1_1_queue.html#af0d54fc00d64f026e80685d11119bbfb',1,'Qore::Thread::Queue']]],
  ['instead_20of_20c_20helo_20if_20so_20additionally_20the_20class_20also_20automatically_20detects_20if_20the_20server_20supports_20the_20c_20starttls_20command_20by_20parsing_20the_20response_20to_20the_20c_20ehlo_20command_20when_20talking_20to_20esmtp_20servers_20if_20the_20a_20tls_20flag_20is_20not_20set_20on_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20and_20the_20server_20supports_20c_20starttls_20and_20a_20transport_20layer_20tls_20ssl_20connection_20was_20not_20already_20established_20then_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20will_20automatically_20execute_20a_20c_20starttls_20command_20after_20connecting_20so_20that_20the_20rest_20of_20the_20smtp_20session_20is_20performed_20securely_20this_20also_20allows_20transparent_20logins_20and_20communication_20with_20esmtp_20servers_20that_20require_20secure_20connections_20for_20the_20above_20reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_87',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_88',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['int_89',['Int',['../../../../lang/html/group__string__type__constants.html#gab24f0bbab16d3369f07c44956d0fa27b',1,'Qore::Type::Int'],['../../../../lang/html/group__string__type__constants.html#gab24f0bbab16d3369f07c44956d0fa27b',1,'Qore::Type::Int']]],
  ['int_90',['int',['../../../../lang/html/group__type__conversion__functions.html#ga2de8717e92c5f97ccc6511f6062d6502',1,'Qore::int(string str, int base=10)'],['../../../../lang/html/group__type__conversion__functions.html#gaedc7dfca9a2bab4770135bb01a34b63c',1,'Qore::int(softint i)'],['../../../../lang/html/group__type__conversion__functions.html#ga03ab6f55991f898f3ba14da7b8d1bde6',1,'Qore::int()'],['../../../../lang/html/group__type__conversion__functions.html#ga2de8717e92c5f97ccc6511f6062d6502',1,'Qore::int(string str, int base=10)'],['../../../../lang/html/group__type__conversion__functions.html#gaedc7dfca9a2bab4770135bb01a34b63c',1,'Qore::int(softint i)'],['../../../../lang/html/group__type__conversion__functions.html#ga03ab6f55991f898f3ba14da7b8d1bde6',1,'Qore::int()']]],
  ['intent_91',['intent',['../../../Util/html/struct_util_1_1_allowed_value_info.html#ac4c2c190f60aad030d1f5a053bc3c795',1,'Util::AllowedValueInfo::intent'],['../../../Util/html/struct_util_1_1_ui_message_info.html#a5ebb67580de1a93bf66bfea8b2c8f67f',1,'Util::UiMessageInfo::intent']]],
  ['interface_92',['interface',['../../../../lang/html/struct_qore_1_1_net_if_info.html#a7ffd71bce1084e6a7a0baf307bc7f880',1,'Qore::NetIfInfo']]],
  ['intp_93',['intp',['../../../../lang/html/class_qore_1_1zzz8boolzzz9.html#a9a417407e6d1fcd5251b5e252a947ea9',1,'Qore::&lt;bool&gt;::intp()'],['../../../../lang/html/class_qore_1_1zzz8datezzz9.html#aa834702a304a20d6443014ae09e73be9',1,'Qore::&lt;date&gt;::intp()'],['../../../../lang/html/class_qore_1_1zzz8floatzzz9.html#a1e40df6b7e6d5cd5022081fbf0e6f446',1,'Qore::&lt;float&gt;::intp()'],['../../../../lang/html/class_qore_1_1zzz8intzzz9.html#a48f2332ed8aba090985de5fee9375d65',1,'Qore::&lt;int&gt;::intp()'],['../../../../lang/html/class_qore_1_1zzz8numberzzz9.html#ae1c82d60b2445d72d4ece799aae3ce9c',1,'Qore::&lt;number&gt;::intp()'],['../../../../lang/html/class_qore_1_1zzz8stringzzz9.html#ace7f5b6ac2e7b9f4886c9e153edd46d7',1,'Qore::&lt;string&gt;::intp()'],['../../../../lang/html/class_qore_1_1zzz8valuezzz9.html#a6feb7fd9eae7eac19775a47db23ad4e5',1,'Qore::&lt;value&gt;::intp()']]],
  ['intransaction_94',['inTransaction',['../../../../lang/html/class_qore_1_1_s_q_l_1_1_abstract_datasource.html#ac7fe5b3cf6789100950622138915517e',1,'Qore::SQL::AbstractDatasource::inTransaction()'],['../../../../lang/html/class_qore_1_1_s_q_l_1_1_datasource.html#af74cb806c9e19c6099c0d2cce84a44ab',1,'Qore::SQL::Datasource::inTransaction()'],['../../../../lang/html/class_qore_1_1_s_q_l_1_1_datasource_pool.html#a3b868b40604c049b4bf78b121ede7c16',1,'Qore::SQL::DatasourcePool::inTransaction()']]],
  ['introduction_95',['Introduction',['../../../../lang/html/qore_intro.html',1,'index']]],
  ['introduction_20the_20smtpclient_20module_20provides_20a_20set_20of_20classes_20that_20can_20be_20used_20for_20easy_20communication_20with_20smtp_20servers_20for_20sending_20emails_20with_20or_20without_20tls_20ssl_20encryption_20to_20use_20this_20module_20use_20c_20requires_20smtpclient_20in_20your_20code_20see_20examples_20email_20q_20for_20an_20example_20program_20using_20this_20module_20all_20the_20symbols_20in_20the_20module_20are_20defined_20in_20the_20smtpclient_20namespace_20classes_20provided_3a_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20_3a_20manages_20a_20connection_20to_20an_20smtp_20server_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20_3a_20provides_20a_20connection_20object_20to_20an_20smtp_20server_20based_20on_20the_20ref_20connectionproviderintro_20connectionprovider_20module_20the_20following_20supporting_20classes_20are_20provided_20by_20the_20mailmessage_20module_3a_20mailmessage_3a_3amessage_3a_20wraps_20a_20message_20to_20be_20sent_20via_20an_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20mailmessage_3a_3aattachment_3a_20used_20to_20attach_20files_20to_20a_20mailmessage_3a_3amessage_20object_20note_20that_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20class_20automatically_20detects_20if_20the_20smtp_20server_20supports_20esmtp_20and_20a_20c_20ehlo_20command_20is_20executed_20automatically_20instead_20of_20c_20helo_20if_20so_20additionally_20the_20class_20also_20automatically_20detects_20if_20the_20server_20supports_20the_20c_20starttls_20command_20by_20parsing_20the_20response_20to_20the_20c_20ehlo_20command_20when_20talking_20to_20esmtp_20servers_20if_20the_20a_20tls_20flag_20is_20not_20set_20on_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20and_20the_20server_20supports_20c_20starttls_20and_20a_20transport_20layer_20tls_20ssl_20connection_20was_20not_20already_20established_20then_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20will_20automatically_20execute_20a_20c_20starttls_20command_20after_20connecting_20so_20that_20the_20rest_20of_20the_20smtp_20session_20is_20performed_20securely_20this_20also_20allows_20transparent_20logins_20and_20communication_20with_20esmtp_20servers_20that_20require_20secure_20connections_20for_20the_20above_20reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_96',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['ip_5faddress_5ftype_97',['ip_address_type',['../../../Util/html/namespace_util.html#a3c7ef6cd44f81e1af9156db4679ed387',1,'Util']]],
  ['ip_5faddress_5ftype_5fex_98',['ip_address_type_ex',['../../../Util/html/namespace_util.html#a1284793f60ecd9a893570dd5fd31037c',1,'Util']]],
  ['ipproto_5ftcp_99',['IPPROTO_TCP',['../../../../lang/html/group__protocol__constants.html#ga207783771cbf914f235bb441f69cec71',1,'Qore::IPPROTO_TCP'],['../../../../lang/html/group__protocol__constants.html#ga207783771cbf914f235bb441f69cec71',1,'Qore::IPPROTO_TCP']]],
  ['ipproto_5fudp_100',['IPPROTO_UDP',['../../../../lang/html/group__protocol__constants.html#ga60076c9f99409f2691cf66c521572c41',1,'Qore::IPPROTO_UDP'],['../../../../lang/html/group__protocol__constants.html#ga60076c9f99409f2691cf66c521572c41',1,'Qore::IPPROTO_UDP']]],
  ['is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_101',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_102',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_103',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['is_20executed_20automatically_20instead_20of_20c_20helo_20if_20so_20additionally_20the_20class_20also_20automatically_20detects_20if_20the_20server_20supports_20the_20c_20starttls_20command_20by_20parsing_20the_20response_20to_20the_20c_20ehlo_20command_20when_20talking_20to_20esmtp_20servers_20if_20the_20a_20tls_20flag_20is_20not_20set_20on_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20and_20the_20server_20supports_20c_20starttls_20and_20a_20transport_20layer_20tls_20ssl_20connection_20was_20not_20already_20established_20then_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20will_20automatically_20execute_20a_20c_20starttls_20command_20after_20connecting_20so_20that_20the_20rest_20of_20the_20smtp_20session_20is_20performed_20securely_20this_20also_20allows_20transparent_20logins_20and_20communication_20with_20esmtp_20servers_20that_20require_20secure_20connections_20for_20the_20above_20reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_104',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_105',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_106',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_107',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_108',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['is_20not_20set_20on_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20and_20the_20server_20supports_20c_20starttls_20and_20a_20transport_20layer_20tls_20ssl_20connection_20was_20not_20already_20established_20then_20the_20ref_20smtpclient_3a_3asmtpclient_20smtpclient_20object_20will_20automatically_20execute_20a_20c_20starttls_20command_20after_20connecting_20so_20that_20the_20rest_20of_20the_20smtp_20session_20is_20performed_20securely_20this_20also_20allows_20transparent_20logins_20and_20communication_20with_20esmtp_20servers_20that_20require_20secure_20connections_20for_20the_20above_20reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_109',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['is_20performed_20securely_20this_20also_20allows_20transparent_20logins_20and_20communication_20with_20esmtp_20servers_20that_20require_20secure_20connections_20for_20the_20above_20reasons_20it_20s_20normally_20not_20required_20to_20use_20the_20c_20smtptls_20or_20c_20esmtptls_20protocols_20in_20the_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20rl_20argument_20anchor_20smtpclient_5fprotocols_20ref_20smtpclient_3a_3asmtpclient_3a_3aconstructor_20string_20_5f_5f7_5f_20code_20_5f_5f7_5f_20code_20smtpclient_3a_3aconstructor_20string_20code_20code_20takes_20a_20url_20argument_20the_20protocol_20scheme_20component_20is_20handled_20as_20in_20the_20following_20table_20b_20smtpcclient_20protocol_20handling_20b_20protocol_20default_20port_20description_20c_20smtp_2025_20standard_20smtp_20port_20without_20encryption_20esmpt_20and_20c_20starttls_20detection_20is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_110',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['is_20supported_20automatically_20c_20smtps_20465_20note_20that_20port_20465_20is_20currently_20assigned_20to_20source_20specific_20multicast_20audio_20video_20a_20href_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20http_3a_20www_20iana_20org_20assignments_20port_20numbers_20a_20its_20use_20as_20a_20port_20for_20secure_20smtp_20listeners_20where_20security_20is_20enforced_20at_20the_20transport_20layer_20because_20the_20server_20immediately_20negotiates_20a_20tls_20ssl_20connection_20before_20the_20application_20protocol_20communication_20starts_20is_20but_20is_20included_20in_20this_20module_20because_20many_20smtp_20servers_20still_20operate_20this_20way_20c_20smtptls_2025_20a_20c_20starttls_20command_20is_20executed_20unconditionally_20after_20the_20connection_20to_20ensure_20a_20secure_20connection_20even_20if_20the_20server_20does_20not_20declare_20support_20for_20this_20command_20in_20the_20login_20response_20it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_111',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['is_20used_20automatically_20when_20logging_20in_20to_20esmtp_20servers_20that_20declare_20support_20for_20this_20command_20in_20the_20response_20to_20the_20c_20ehlo_20command_20c_20esmtp_20587_20like_20c_20smtp_20just_20using_20port_20587_20c_20esmtps_20465_20like_20c_20smtps_20c_20esmtptls_20587_20like_20c_20smtptls_20just_20using_20port_20587_20par_20example_3a_20code_20py_20requires_20smtpclient_20requires_20mime_20message_20msg_20the_20sender_20sender_20email_20com_20my_20subject_20msg_20setbody_20body_20msg_20addto_20my_20best_20friend_20you_20friend_20com_20msg_20attach_20filename_20mime_3a_3amimetypetext_20data_20code_20log_20sub_20string_20str_20printf_20y_3a_20s_20n_20now_5fus_20str_20smtpclient_3a_3asmtpclient_20smtp_20esmtptls_3a_20user_20password_3asmtp_20example_20com_20log_20log_20smtp_20sendmessage_20msg_20endcode_20section_20smtpclient_5freferences_20smtpclient_20references_20based_20on_3a_20http_3a_20james_20apache_20org_20server_20rfclist_20smtp_20rfc0821_20txt_20http_3a_20tools_20ietf_20org_20html_20rfc821_3a_20initial_20smtp_20protocol_20spec_20http_3a_20tools_20ietf_20org_20html_20rfc1521_3a_20quoted_20printable_20base_2064_20transfer_20encodings_20http_3a_20tools_20ietf_20org_20html_20rfc2045_3a_20mime_20headers_20content_20types_20etc_20http_3a_20tools_20ietf_20org_20html_20rfc2047_3a_20q_20and_20b_20encoded_20words_20implemented_20by_20the_20mime_20module_20http_3a_20tools_20ietf_20org_20html_20rfc2822_3a_20message_20structure_20headers_20body_20etc_20section_20smtpclient_5frelnotes_20smtpclient_20release_20notes_20subsection_20smtpclient_5fv2_5f1_20smtpclient_202_201_20added_20support_20for_20the_20data_20provider_20action_20catalog_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_112',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['is_5fbdev_113',['is_bdev',['../../../../lang/html/group__filesystem__functions.html#ga139846d1deedb967e21af11e62799ea2',1,'Qore::is_bdev(string path)'],['../../../../lang/html/group__filesystem__functions.html#ga139846d1deedb967e21af11e62799ea2',1,'Qore::is_bdev(string path)']]],
  ['is_5fcdev_114',['is_cdev',['../../../../lang/html/group__filesystem__functions.html#ga56ae16710a38109b7ed71010a5b3d9e5',1,'Qore::is_cdev(string path)'],['../../../../lang/html/group__filesystem__functions.html#ga56ae16710a38109b7ed71010a5b3d9e5',1,'Qore::is_cdev(string path)']]],
  ['is_5fdate_5fabsolute_115',['is_date_absolute',['../../../../lang/html/group__date__and__time__functions.html#ga544832cd9178c98718296c83dfddc2f6',1,'Qore::is_date_absolute(date dt)'],['../../../../lang/html/group__date__and__time__functions.html#ga1a78ee645b0b9816f7a1bbc77f0e4e3b',1,'Qore::is_date_absolute()'],['../../../../lang/html/group__date__and__time__functions.html#ga544832cd9178c98718296c83dfddc2f6',1,'Qore::is_date_absolute(date dt)'],['../../../../lang/html/group__date__and__time__functions.html#ga1a78ee645b0b9816f7a1bbc77f0e4e3b',1,'Qore::is_date_absolute()']]],
  ['is_5fdate_5frelative_116',['is_date_relative',['../../../../lang/html/group__date__and__time__functions.html#gaf7de7b0823a39642087140ff1224e033',1,'Qore::is_date_relative(date dt)'],['../../../../lang/html/group__date__and__time__functions.html#ga72eac18903961ac29592aa649823a5da',1,'Qore::is_date_relative()'],['../../../../lang/html/group__date__and__time__functions.html#gaf7de7b0823a39642087140ff1224e033',1,'Qore::is_date_relative(date dt)'],['../../../../lang/html/group__date__and__time__functions.html#ga72eac18903961ac29592aa649823a5da',1,'Qore::is_date_relative()']]],
  ['is_5fdev_117',['is_dev',['../../../../lang/html/group__filesystem__functions.html#ga594e6a60ad12517656d32a7262777b4d',1,'Qore::is_dev(string path)'],['../../../../lang/html/group__filesystem__functions.html#ga594e6a60ad12517656d32a7262777b4d',1,'Qore::is_dev(string path)']]],
  ['is_5fdir_118',['is_dir',['../../../../lang/html/group__filesystem__functions.html#ga38348592b2e5aa5589e0399c10b260fd',1,'Qore::is_dir(string path)'],['../../../../lang/html/group__filesystem__functions.html#ga38348592b2e5aa5589e0399c10b260fd',1,'Qore::is_dir(string path)']]],
  ['is_5fexecutable_119',['is_executable',['../../../../lang/html/group__filesystem__functions.html#ga0255009acc4b2cb332fd3f9d2aae7c05',1,'Qore::is_executable(string path)'],['../../../../lang/html/group__filesystem__functions.html#ga0255009acc4b2cb332fd3f9d2aae7c05',1,'Qore::is_executable(string path)']]],
  ['is_5ffile_120',['is_file',['../../../../lang/html/group__filesystem__functions.html#ga6117e36222d08c197c2c0de1cadea715',1,'Qore::is_file(string path)'],['../../../../lang/html/group__filesystem__functions.html#ga6117e36222d08c197c2c0de1cadea715',1,'Qore::is_file(string path)']]],
  ['is_5ffilename_5ftext_121',['is_filename_text',['../../../Mime/html/group___mime_misc_functions.html#ga69d463006c239dbf904e95c0ac7c58d8',1,'Mime::is_filename_text(string path)'],['../../../Mime/html/group___mime_misc_functions.html#ga69d463006c239dbf904e95c0ac7c58d8',1,'Mime::is_filename_text(string path)']]],
  ['is_5ffloat_122',['is_float',['../../../Util/html/namespace_util.html#a887e9bb948753886d47a4c1efaeb1f97',1,'Util']]],
  ['is_5fint_123',['is_int',['../../../Util/html/namespace_util.html#ae81158524bf02771e7b571583504a260',1,'Util']]],
  ['is_5fip_5fprivate_124',['is_ip_private',['../../../Util/html/namespace_util.html#a10be30a2bdadd9181486925a38151bd8',1,'Util']]],
  ['is_5fip_5fprivate_5fex_125',['is_ip_private_ex',['../../../Util/html/namespace_util.html#a1375265734d3de675eb7a1bfd9c35e90',1,'Util']]],
  ['is_5flink_126',['is_link',['../../../../lang/html/group__filesystem__functions.html#ga55cb552f0c56f8ff6915ec7ad6ab3cd8',1,'Qore::is_link(string path)'],['../../../../lang/html/group__filesystem__functions.html#ga55cb552f0c56f8ff6915ec7ad6ab3cd8',1,'Qore::is_link(string path)']]],
  ['is_5fmime_5ftext_127',['is_mime_text',['../../../Mime/html/group___mime_misc_functions.html#ga34620a34fbf92833fbb8cc41729b353a',1,'Mime::is_mime_text(string mime)'],['../../../Mime/html/group___mime_misc_functions.html#ga34620a34fbf92833fbb8cc41729b353a',1,'Mime::is_mime_text(string mime)']]],
  ['is_5fnumber_128',['is_number',['../../../Util/html/namespace_util.html#a66ac37b71c0b4a6de301aeed72e38a59',1,'Util']]],
  ['is_5fpipe_129',['is_pipe',['../../../../lang/html/group__filesystem__functions.html#ga646f8b88054dbb2004e8f47ec09aa96e',1,'Qore::is_pipe(string path)'],['../../../../lang/html/group__filesystem__functions.html#ga646f8b88054dbb2004e8f47ec09aa96e',1,'Qore::is_pipe(string path)']]],
  ['is_5freadable_130',['is_readable',['../../../../lang/html/group__filesystem__functions.html#gaf04a8a04f9130664f938cf7dc10dbaed',1,'Qore::is_readable(string path)'],['../../../../lang/html/group__filesystem__functions.html#gaf04a8a04f9130664f938cf7dc10dbaed',1,'Qore::is_readable(string path)']]],
  ['is_5fsocket_131',['is_socket',['../../../../lang/html/group__filesystem__functions.html#ga568996f46411f4fa0daaaa4e61d20d44',1,'Qore::is_socket(string path)'],['../../../../lang/html/group__filesystem__functions.html#ga568996f46411f4fa0daaaa4e61d20d44',1,'Qore::is_socket(string path)']]],
  ['is_5fsybase_132',['is_sybase',['../../../PgsqlSqlUtilBase/html/class_mssql_sql_util_base_1_1_mssql_database.html#aab3fef6601f1081a7b529fd78affbf0b',1,'MssqlSqlUtilBase::MssqlDatabase::is_sybase'],['../../../PgsqlSqlUtilBase/html/class_mssql_sql_util_base_1_1_mssql_table.html#a4d7b50f06f0eaf678e6824de8bc6d2ec',1,'MssqlSqlUtilBase::MssqlTable::is_sybase']]],
  ['is_5fwritable_133',['is_writable',['../../../../lang/html/group__filesystem__functions.html#ga1f94b219bfc67a292a80cafcd2416ee5',1,'Qore::is_writable(string path)'],['../../../../lang/html/group__filesystem__functions.html#ga1f94b219bfc67a292a80cafcd2416ee5',1,'Qore::is_writable(string path)']]],
  ['is_5fwriteable_134',['is_writeable',['../../../../lang/html/group__filesystem__functions.html#gaa7817f6649fdd56e82c65d9f62c8a707',1,'Qore::is_writeable(string path)'],['../../../../lang/html/group__filesystem__functions.html#gaa7817f6649fdd56e82c65d9f62c8a707',1,'Qore::is_writeable(string path)']]],
  ['isauthtokenerror_135',['isAuthTokenError',['../../../RestClient/html/class_rest_client_1_1_rest_client.html#a7592bfd7035ceeef93893614143d8df9',1,'RestClient::RestClient']]],
  ['isconnected_136',['isConnected',['../../../../lang/html/class_qore_1_1_ftp_client.html#ab0be2260eb45e979e4307822e49c1395',1,'Qore::FtpClient::isConnected()'],['../../../../lang/html/class_qore_1_1_h_t_t_p_client.html#adbee3f312158d29d873527085eb48bea',1,'Qore::HTTPClient::isConnected()']]],
  ['isdataascii_137',['isDataAscii',['../../../../lang/html/class_qore_1_1zzz8stringzzz9.html#a766250b7a8d910b7facce5bef7cfe855',1,'&lt;string&gt;']]],
  ['isdataavailable_138',['isDataAvailable',['../../../../lang/html/class_qore_1_1_read_only_file.html#a0bae6c89d6262b18785b0727866a3405',1,'Qore::ReadOnlyFile::isDataAvailable()'],['../../../../lang/html/class_qore_1_1_socket.html#ada15658191958a262a3c8ca44160f112',1,'Qore::Socket::isDataAvailable()']]],
  ['isdataprintableascii_139',['isDataPrintableAscii',['../../../../lang/html/class_qore_1_1zzz8stringzzz9.html#ae568ad566fc87c944a64d6ce67dd3d16',1,'&lt;string&gt;']]],
  ['isdatasecure_140',['isDataSecure',['../../../../lang/html/class_qore_1_1_ftp_client.html#a3025f2ac95d03d4e744de82b5a26ad9a',1,'Qore::FtpClient']]],
  ['isdebugenabled_141',['isDebugEnabled',['../../../Logger/html/class_logger_1_1_logger_wrapper.html#a50e52f55a85728e2066edb4357b0ddba',1,'Logger::LoggerWrapper']]],
  ['isdefined_142',['isDefined',['../../../../lang/html/class_qore_1_1_program.html#afcfa159016f0f76d7a1abdf8e3895b6b',1,'Qore::Program::isDefined()'],['../../../../lang/html/class_qore_1_1_program_control.html#a32cc156d0ffc5acbaa07024a6e608054',1,'Qore::ProgramControl::isDefined()']]],
  ['isdst_143',['isDst',['../../../../lang/html/class_qore_1_1zzz8datezzz9.html#a657e9b7211b84a2f9df8f3ccb5b91ffb',1,'&lt;date&gt;']]],
  ['isduplicaterowerrorimpl_144',['isDuplicateRowErrorImpl',['../../../PgsqlSqlUtilBase/html/class_mssql_sql_util_base_1_1_mssql_table.html#a7a500d68b83d23876283bea61be86d55',1,'MssqlSqlUtilBase::MssqlTable::isDuplicateRowErrorImpl()'],['../../../XdbcFirebirdSqlUtilBase/html/class_xdbc_firebird_sql_util_base_1_1_xdbc_firebird_table.html#acae0716c04ade4371a4f9bdb1f9765dc',1,'XdbcFirebirdSqlUtilBase::XdbcFirebirdTable::isDuplicateRowErrorImpl()'],['../../../OracleSqlUtilBase/html/class_oracle_sql_util_base_1_1_oracle_table.html#a5e77fbd2b148faa56139fcbefef795c8',1,'OracleSqlUtilBase::OracleTable::isDuplicateRowErrorImpl()']]],
  ['isenabled_145',['isEnabled',['../../../PgsqlSqlUtilBase/html/class_mssql_sql_util_base_1_1_mssql_unique_constraint.html#a3ee209bff78a77a3a00f3fdb378ec349',1,'MssqlSqlUtilBase::MssqlUniqueConstraint::isEnabled()'],['../../../OracleSqlUtilBase/html/class_oracle_sql_util_base_1_1_oracle_unique_constraint.html#a3471409acdba958183fdf6820883471f',1,'OracleSqlUtilBase::OracleUniqueConstraint::isEnabled()']]],
  ['isenabledfor_146',['isEnabledFor',['../../../Logger/html/class_logger_1_1_logger_wrapper.html#a609493abc080fb299076b3af8c419a11',1,'Logger::LoggerWrapper::isEnabledFor(int level)'],['../../../Logger/html/class_logger_1_1_logger_wrapper.html#a7b9063c14aea7f3f6aab5c292b48a76b',1,'Logger::LoggerWrapper::isEnabledFor(LoggerLevel level)'],['../../../Logger/html/class_logger_1_1_logger_wrapper.html#aabf6a9a8d453b4e511c07339f03ba245',1,'Logger::LoggerWrapper::isEnabledFor(string level)']]],
  ['isequal_147',['isEqual',['../../../../lang/html/class_qore_1_1_term_i_o_s.html#a74a86e4703525ee046e0221482484b61',1,'Qore::TermIOS']]],
  ['iserrorenabled_148',['isErrorEnabled',['../../../Logger/html/class_logger_1_1_logger_wrapper.html#a78d7b1089b47cbc38be48d86a6ffa940',1,'Logger::LoggerWrapper']]],
  ['isfatalenabled_149',['isFatalEnabled',['../../../Logger/html/class_logger_1_1_logger_wrapper.html#a9e29bfbb4b5ea5d85d68defff28fc328',1,'Logger::LoggerWrapper']]],
  ['isig_150',['ISIG',['../../../../lang/html/group__tattr__local__mode__constants.html#gaad46656657feecadbc2b3bf1cceacd92',1,'Qore::ISIG'],['../../../../lang/html/group__tattr__local__mode__constants.html#gaad46656657feecadbc2b3bf1cceacd92',1,'Qore::ISIG']]],
  ['isinfoenabled_151',['isInfoEnabled',['../../../Logger/html/class_logger_1_1_logger_wrapper.html#aa060905593017530a0c6cffcd640b395',1,'Logger::LoggerWrapper']]],
  ['islogger_152',['isLogger',['../../../Logger/html/class_logger_1_1_logger_wrapper.html#afc30ff9c5c3b087029b1b3af4052380b',1,'Logger::LoggerWrapper']]],
  ['isodayofweek_153',['isoDayOfWeek',['../../../../lang/html/class_qore_1_1zzz8datezzz9.html#ad38a12c3b55fab4825bbb7d6125df1e5',1,'&lt;date&gt;']]],
  ['isopen_154',['isOpen',['../../../../lang/html/class_qore_1_1_read_only_file.html#a2744f4642700d0f273efbce43f709fb4',1,'Qore::ReadOnlyFile::isOpen()'],['../../../../lang/html/class_qore_1_1_socket.html#a1f6e97d05075accded9da7a8ee44defd',1,'Qore::Socket::isOpen()']]],
  ['isoweekhash_155',['isoWeekHash',['../../../../lang/html/class_qore_1_1zzz8datezzz9.html#ad8c2c004a04ac7db6427f3e158d7400b',1,'&lt;date&gt;']]],
  ['isoweekinfo_156',['IsoWeekInfo',['../../../../lang/html/struct_qore_1_1_iso_week_info.html',1,'Qore']]],
  ['isoweekstring_157',['isoWeekString',['../../../../lang/html/class_qore_1_1zzz8datezzz9.html#aa03daafa0fe01dfa0abf447d8ca135fd',1,'&lt;date&gt;']]],
  ['ispersistent_158',['isPersistent',['../../../../lang/html/class_qore_1_1_h_t_t_p_client.html#a98523c048a2b9feb1067377c6e367cd2',1,'Qore::HTTPClient::isPersistent()'],['../../../HttpServerUtil/html/class_http_server_1_1_abstract_http_request_handler.html#a9d09f89c29e32a01c33ae15a518e54f1',1,'HttpServer::AbstractHttpRequestHandler::isPersistent()']]],
  ['isproxysecure_159',['isProxySecure',['../../../../lang/html/class_qore_1_1_h_t_t_p_client.html#a04c2df5e6fca680874e388a093fa136a',1,'Qore::HTTPClient']]],
  ['isregex_160',['isregex',['../../../HttpServerUtil/html/struct_http_server_1_1_http_handler_config_info.html#af6b4675b8fbac038269217e51221e852',1,'HttpServer::HttpHandlerConfigInfo']]],
  ['issecure_161',['isSecure',['../../../../lang/html/class_qore_1_1_ftp_client.html#ad6b30ff57e39fc5aa580d20b135195d9',1,'Qore::FtpClient::isSecure()'],['../../../../lang/html/class_qore_1_1_h_t_t_p_client.html#a5654958c7d5ca1106b092f85230a78f1',1,'Qore::HTTPClient::isSecure()'],['../../../../lang/html/class_qore_1_1_socket.html#a62f88e568207417db77890f565063822',1,'Qore::Socket::isSecure()']]],
  ['issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_162',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_163',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_164',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_165',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_166',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_167',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_168',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_169',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_170',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_171',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['issuemodulecmd_172',['issueModuleCmd',['../../../../lang/html/class_qore_1_1_program.html#afe6fc6b4013b8e2ff209ac9dad421487',1,'Qore::Program::issueModuleCmd(string module, string cmd)'],['../../../../lang/html/class_qore_1_1_program.html#a74e19fad3244698f2f82c40e4a816b35',1,'Qore::Program::issueModuleCmd(string module, string cmd)']]],
  ['issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_173',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_174',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_175',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_176',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_177',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_178',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_179',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_180',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['issues_204808_20issue_204808_20a_20subsection_20smtpclient_5fv2_5f0_20smtpclient_202_200_20added_20support_20for_20the_20dataprovider_20api_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204564_20issue_204564_20a_20subsection_20smtpclient_5fv1_5f9_5f3_20smtpclient_201_209_203_20fixed_20message_20serialization_20for_20smtp_20handling_20in_20case_20of_20single_20c_20characters_20on_20a_20line_20in_20serialized_20data_20issue_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203275_20issue_203275_20a_20subsection_20smtpclient_5fv1_5f9_5f2_20smtpclient_201_209_202_20implemented_20support_20for_20a_20data_20provider_20scheme_20cache_20and_20rich_20option_20information_20for_20connections_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_204025_20issue_204025_20a_20subsection_20smtpclient_5fv1_5f9_5f1_20smtpclient_201_209_201_20fixed_20type_20errors_20sending_20mails_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203813_20issue_203813_20a_20subsection_20smtpclient_5fv1_5f9_20smtpclient_201_209_20added_20the_20c_20estmps_20scheme_20for_20completeness_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202833_20issue_202833_20a_20subsection_20smtpclient_5fv1_5f8_20smtpclient_201_208_20removed_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20and_20c_20smtpconnection_3a_3agetconstructorinfoimpl_20methods_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203696_20issue_203696_20a_20added_20support_20for_20socket_20events_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_203425_20issue_203425_20a_20subsection_20smtpclient_5fv1_5f7_20smtpclient_201_207_20added_20the_20c_20smtpconnection_3a_3agetconstructorinfo_20method_20to_20allow_20connections_20to_20be_20created_20dynamically_20potentially_20in_20another_20process_20from_20a_20network_20call_20removed_20in_20smtpclient_201_208_20a_20href_20https_3a_20github_20com_20qorelanguage_20qore_20issues_202628_20issue_202628_20a_20subsection_20smtpclient_5fv1_5f6_20smtpclient_201_206_20added_20the_20ref_20smtpclient_3a_3asmtpconnection_20smtpconnection_20class_20to_20support_20the_20a_20href_20connectionprovider_20html_20index_20html_20connectionprovider_20a_20module_20updated_20for_20complex_20types_20subsection_20smtpclient_5fv1_5f5_20smtpclient_201_205_20converted_20to_20ref_20new_20style_20new_20style_20subsection_20smtpclient_5fv1_5f4_20smtpclient_201_204_20fixed_20missing_20username_20and_20missing_20password_20errors_20subsection_20smtpclient_5fv1_5f3_20smtpclient_201_203_20added_20socket_20instrumention_20support_20from_20qore_200_208_209_20optimized_20connection_20and_20login_20code_20helo_20ehlo_20and_20authorization_20are_20performed_20when_20connecting_20only_20not_20before_20each_20email_20subsection_20smtpclient_5fv1_5f2_20smtpclient_201_202_20added_20support_20for_20parsing_20a_20full_20url_20in_20the_20smtpclient_3a_3aconstructor_20added_20protocol_20support_20and_20setting_20the_20username_20password_20from_20the_20url_20use_20message_3a_3achecksendpossible_20to_20throw_20a_20more_20descriptive_20exception_20if_20the_20message_20is_20incomplete_20and_20not_20ready_20to_20be_20sent_20implemented_20support_20for_20automatically_20detecting_20if_20the_20server_20accepts_20the_20starttls_20command_20and_20if_20so_20automatically_20setting_20the_20starttls_20flag_20if_20it_20s_20not_20already_20set_20subsection_20smtpclient_5fv1_5f1_20smtpclient_201_201_20removed_20the_20message_20and_20attachment_20classes_20to_20the_20mailmessage_20module_20to_20be_20reused_20in_20the_20pop3client_20module_20subsection_20smtpclient_5fv1_5f10_20smtpclient_201_200_20updated_20to_20a_20user_20module_20added_20initial_20rudimentary_20esmtp_20handling_20starttls_20and_20quoted_20printable_20encoding_20support_20documentation_181',['SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \c &quot;requires SmtpClient&quot; in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient &quot;SmtpClient&quot;: manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot;: provides a connection object to an SMTP server (based on the @ref connectionproviderintro &quot;ConnectionProvider&quot; module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; class automatically detects if the SMTP server supports ESMTP and a \c &quot;EHLO&quot; command is executed automatically instead of \c &quot;HELO&quot; if so.  Additionally, the class also automatically detects if the server supports the \c &quot;STARTTLS&quot; command by parsing the response to the \c &quot;EHLO&quot; command when talking to ESMTP servers. If the \a tls flag is not set on the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object and the server supports \c &quot;STARTTLS&quot; (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient &quot;SmtpClient&quot; object will automatically execute a \c &quot;STARTTLS&quot; command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it&apos;s normally not required to use the \c &quot;smtptls&quot; or \c &quot;esmtptls&quot; protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) &quot;SmtpClient::constructor(string, *code, *code)&quot; takes a URL argument, the protocol (scheme) component is handled as in the following table. &lt;b&gt;SmtpcClient Protocol Handling&lt;/b&gt; |!Protocol|!Default Port|!Description |\c &quot;smtp&quot;|25|standard SMTP port without encryption; ESMPT and \c &quot;STARTTLS&quot; detection is supported automatically |\c &quot;smtps&quot;|465|note that port 465 is currently assigned to source-specific multicast audio/video \ (&lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;http://www.iana.org/assignments/port-numbers&lt;/a&gt;); \ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \  but is included in this module because many SMTP servers still operate this way |\c &quot;smtptls&quot;|25|a \c &quot;STARTTLS&quot; command is executed unconditionally after the connection to ensure a secure \ connection, even if the server does not declare support for this command in the login response.  It&apos;s \ normally not necessary to use this protocol as \c &quot;STARTTLS&quot; is used automatically when logging in to ESMTP \ servers that declare support for this command in the response to the \c &quot;EHLO&quot; command. |\c &quot;esmtp&quot;|587|like \c &quot;smtp&quot; just using port 587 |\c &quot;esmtps&quot;|465|like \c &quot;smtps&quot; |\c &quot;esmtptls&quot;|587|like \c &quot;smtptls&quot; just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(&quot;The Sender &lt;sender@email.com&gt;&quot;, &quot;My Subject&quot;); msg.setBody(body); msg.addTO(&quot;My Best Friend &lt;you@friend.com&gt;&quot;); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(&quot;y: s\n&quot;, now_us(), str);}; SmtpClient::SmtpClient smtp(&quot;esmtptls://user@password:smtp.example.com&quot;, log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable &amp; base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: &quot;Q&quot; and &quot;B&quot; encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4808&quot;&gt;issue 4808&lt;/a&gt;) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4564&quot;&gt;issue 4564&lt;/a&gt;) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \c &quot;.&quot; characters on a line in serialized data (issue &lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3275&quot;&gt;issue 3275&lt;/a&gt;) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/4025&quot;&gt;issue 4025&lt;/a&gt;) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3813&quot;&gt;issue 3813&lt;/a&gt;) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \c &quot;estmps&quot; scheme for completeness (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2833&quot;&gt;issue 2833&lt;/a&gt;) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \c SmtpConnection::getConstructorInfo() and \c SmtpConnection::getConstructorInfoImpl() methods (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3696&quot;&gt;issue 3696&lt;/a&gt;) - added support for socket events (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/3425&quot;&gt;issue 3425&lt;/a&gt;) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (&lt;a href=&quot;https://github.com/qorelanguage/qore/issues/2628&quot;&gt;issue 2628&lt;/a&gt;) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection &quot;SmtpConnection&quot; class to support the &lt;a href=&quot;../../ConnectionProvider/html/index.html&quot;&gt;ConnectionProvider&lt;/a&gt; module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style &quot;new-style&quot; @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it&apos;s not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation',['../index.html',1,'']]],
  ['issybase_182',['isSybase',['../../../PgsqlSqlUtilBase/html/class_mssql_sql_util_base_1_1_mssql_database.html#ada7b23e872106fa8e5a99e54b8992529',1,'MssqlSqlUtilBase::MssqlDatabase']]],
  ['issystem_183',['isSystem',['../../../../lang/html/class_qore_1_1zzz8objectzzz9.html#ae39303b6bbe6686472aec8cabe8b9ea5',1,'&lt;object&gt;']]],
  ['isthreadid_184',['isThreadId',['../../../../lang/html/class_qore_1_1_breakpoint.html#a3d30dc49c88708bdcc8e1ff50083bbfb',1,'Qore::Breakpoint']]],
  ['istraceenabled_185',['isTraceEnabled',['../../../Logger/html/class_logger_1_1_logger_wrapper.html#aaf6e484dd7270da85ffc430364ee76b0',1,'Logger::LoggerWrapper']]],
  ['istrip_186',['ISTRIP',['../../../../lang/html/group__tattr__input__mode__constants.html#ga96f95fe0454b14722068348b69cdcb8c',1,'Qore::ISTRIP'],['../../../../lang/html/group__tattr__input__mode__constants.html#ga96f95fe0454b14722068348b69cdcb8c',1,'Qore::ISTRIP']]],
  ['istty_187',['isTty',['../../../../lang/html/class_qore_1_1_file_line_iterator.html#a33ae9488dfc60606876eb1f4c9b2be9a',1,'Qore::FileLineIterator::isTty()'],['../../../../lang/html/class_qore_1_1_read_only_file.html#afd64015ff14cb58d2f2c365d36a9c85c',1,'Qore::ReadOnlyFile::isTty()']]],
  ['isview_188',['isView',['../../../OracleSqlUtilBase/html/class_oracle_sql_util_base_1_1_oracle_table.html#a84982ac5fca04ad91a9957a02d570b95',1,'OracleSqlUtilBase::OracleTable']]],
  ['iswarnenabled_189',['isWarnEnabled',['../../../Logger/html/class_logger_1_1_logger_wrapper.html#ac8afc6113eb22cd3ecffff677cef404b',1,'Logger::LoggerWrapper']]],
  ['iswritefinished_190',['isWriteFinished',['../../../../lang/html/class_qore_1_1_socket.html#a57f1ae016aa33f5ba449a99a8f7f6cc0',1,'Qore::Socket']]],
  ['it_20s_20normally_20not_20necessary_20to_20use_20this_20protocol_20as_20c_20starttls_20is_20used_20automatically_20when_20logging